/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.part;

import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DocumentRoot;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.indy.ui.custom.out.incubation.IncubationOption;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.tech.Tech;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class MapDiagramEditorUtil {
    public static java.util.Map<?, ?> getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static boolean openDiagram(Resource diagram) throws PartInitException {
        String path = diagram.getURI().toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "com.indy.map.diagram.part.MapDiagramEditorID") != null;
        }
        return false;
    }

    public static boolean openDiagram(URI mappingModelURI) throws PartInitException {
        String path = mappingModelURI.toPlatformString(true);
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (workspaceResource instanceof IFile) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return page.openEditor((IEditorInput)new FileEditorInput((IFile)workspaceResource), "com.indy.map.diagram.part.MapDiagramEditorID") != null;
        }
        return false;
    }

    public static void setCharset(IFile file) {
        if (file == null) {
            return;
        }
        try {
            file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MapDiagramEditorPlugin.getInstance().logError("Unable to set charset for file " + String.valueOf(file.getFullPath()), e);
        }
    }

    public static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (containerFullPath == null) {
            containerFullPath = new Path("");
        }
        if (fileName == null || fileName.trim().length() == 0) {
            fileName = "default";
        }
        IPath filePath = containerFullPath.append(fileName);
        if (extension != null && !extension.equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension(extension);
        }
        extension = filePath.getFileExtension();
        fileName = filePath.removeFileExtension().lastSegment();
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(fileName + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    private static Map createInitialModel(String name) {
        if (IncubationOption.useNoModelName()) {
            return MapFactory.eINSTANCE.createMap();
        }
        Map m = MapFactory.eINSTANCE.createMap();
        m.setName(URI.decode((String)name));
        return m;
    }

    public static void runWizard(Shell shell, Wizard wizard, String settingsKey) {
        IDialogSettings pluginDialogSettings = MapDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);
        }
        wizard.setDialogSettings(wizardDialogSettings);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        progressMonitor.beginTask("", 3);
        final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Map model = MapDiagramEditorUtil.createInitialModel();
                MapDiagramEditorUtil.attachModelToResource(model, modelResource);
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Map", (PreferencesHint)MapDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    modelResource.save(MapDiagramEditorUtil.getSaveOptions());
                    diagramResource.save(MapDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    MapDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            MapDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        MapDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        MapDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor, Shell shell) {
        TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        progressMonitor.beginTask("", 3);
        final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
        final Resource modelResource = editingDomain.getResourceSet().createResource(modelURI);
        final String diagramName = diagramURI.lastSegment();
        final String modelName = modelURI.trimFileExtension().lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Diagram diagram;
                Map model = MapDiagramEditorUtil.createInitialModel(modelName);
                MapDiagramEditorUtil.attachModelToResource(model, modelResource);
                if (model.getTech() == null) {
                    Tech tech = null;
                    URI uri = null;
                    try {
                        uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getResourceURIByFileId(MapPreferenceConstants.getString("techMapId"));
                        Resource techResource = this.getEditingDomain().getResourceSet().getResource(uri, true);
                        tech = (Tech)EMFResourceUtil.getRootElement((Resource)techResource);
                    }
                    catch (Exception ex) {
                        MapDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.gmf.map.diagram", Messages.bind((String)Messages.MapDiagramEditorUtil_0, (Object)uri.toPlatformString(true), (Object)ex.getMessage()), (Throwable)ex));
                    }
                    model.setTech((EObject)tech);
                }
                if ((diagram = ViewService.createDiagram((EObject)model, (String)"Map", (PreferencesHint)MapDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT)) != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement((EObject)model);
                }
                try {
                    modelResource.save(MapDiagramEditorUtil.getSaveOptions());
                    diagramResource.save(MapDiagramEditorUtil.getSaveOptions());
                }
                catch (IOException e) {
                    MapDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            MapDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        MapDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)modelResource));
        MapDiagramEditorUtil.setCharset(WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    private static Map createInitialModel() {
        return MapFactory.eINSTANCE.createMap();
    }

    private static void attachModelToResource(Map model, Resource resource) {
        resource.getContents().add((Object)MapDiagramEditorUtil.createDocumentRoot(model));
    }

    private static DocumentRoot createDocumentRoot(Map model) {
        DocumentRoot docRoot = MapFactory.eINSTANCE.createDocumentRoot();
        docRoot.setMap(model);
        return docRoot;
    }

    public static void selectElementsInDiagram(IDiagramWorkbenchPart diagramPart, List<EditPart> editParts) {
        diagramPart.getDiagramGraphicalViewer().deselectAll();
        EditPart firstPrimary = null;
        for (EditPart nextPart : editParts) {
            diagramPart.getDiagramGraphicalViewer().appendSelection(nextPart);
            if (firstPrimary != null || !(nextPart instanceof IPrimaryEditPart)) continue;
            firstPrimary = nextPart;
        }
        if (!editParts.isEmpty()) {
            diagramPart.getDiagramGraphicalViewer().reveal(firstPrimary != null ? firstPrimary : editParts.get(0));
        }
    }

    private static int findElementsInDiagramByID(DiagramEditPart diagramPart, EObject element, List<EditPart> editPartCollector) {
        EditPart editPart;
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)diagramPart.getViewer();
        int intialNumOfEditParts = editPartCollector.size();
        if (element instanceof View && (editPart = (EditPart)viewer.getEditPartRegistry().get(element)) != null) {
            editPartCollector.add(editPart);
            return 1;
        }
        String elementID = EMFCoreUtil.getProxyID((EObject)element);
        List associatedParts = viewer.findEditPartsForElement(elementID, IGraphicalEditPart.class);
        for (EditPart nextPart : associatedParts) {
            EditPart parentPart = nextPart.getParent();
            while (parentPart != null && !associatedParts.contains(parentPart)) {
                parentPart = parentPart.getParent();
            }
            if (parentPart != null) continue;
            editPartCollector.add(nextPart);
        }
        if (intialNumOfEditParts == editPartCollector.size()) {
            if (!associatedParts.isEmpty()) {
                editPartCollector.add((EditPart)associatedParts.get(0));
            } else if (element.eContainer() != null) {
                return MapDiagramEditorUtil.findElementsInDiagramByID(diagramPart, element.eContainer(), editPartCollector);
            }
        }
        return editPartCollector.size() - intialNumOfEditParts;
    }

    public static View findView(DiagramEditPart diagramEditPart, EObject targetElement, LazyElement2ViewMap lazyElement2ViewMap) {
        boolean hasStructuralURI = false;
        if (targetElement.eResource() instanceof XMLResource) {
            hasStructuralURI = ((XMLResource)targetElement.eResource()).getID(targetElement) == null;
        }
        Diagram view = null;
        LinkedList<EditPart> editPartHolder = new LinkedList<EditPart>();
        if (hasStructuralURI && !lazyElement2ViewMap.getElement2ViewMap().isEmpty()) {
            view = lazyElement2ViewMap.getElement2ViewMap().get(targetElement);
        } else if (MapDiagramEditorUtil.findElementsInDiagramByID(diagramEditPart, targetElement, editPartHolder) > 0) {
            EditPart editPart = editPartHolder.get(0);
            view = editPart.getModel() instanceof View ? (View)editPart.getModel() : null;
        }
        return view == null ? diagramEditPart.getDiagramView() : view;
    }

    public static class LazyElement2ViewMap {
        private java.util.Map<EObject, View> element2ViewMap;
        private View scope;
        private Set<? extends EObject> elementSet;

        public LazyElement2ViewMap(View scope, Set<? extends EObject> elements) {
            this.scope = scope;
            this.elementSet = elements;
        }

        public final java.util.Map<EObject, View> getElement2ViewMap() {
            if (this.element2ViewMap == null) {
                this.element2ViewMap = new HashMap<EObject, View>();
                for (EObject eObject : this.elementSet) {
                    View view;
                    if (!(eObject instanceof View) || (view = (View)eObject).getDiagram() != this.scope.getDiagram()) continue;
                    this.element2ViewMap.put(eObject, view);
                }
                LazyElement2ViewMap.buildElement2ViewMap(this.scope, this.element2ViewMap, this.elementSet);
            }
            return this.element2ViewMap;
        }

        private static boolean buildElement2ViewMap(View parentView, java.util.Map<EObject, View> element2ViewMap, Set<? extends EObject> elements) {
            if (elements.size() == element2ViewMap.size()) {
                return true;
            }
            if (parentView.isSetElement() && !element2ViewMap.containsKey(parentView.getElement()) && elements.contains(parentView.getElement())) {
                element2ViewMap.put(parentView.getElement(), parentView);
                if (elements.size() == element2ViewMap.size()) {
                    return true;
                }
            }
            boolean complete = false;
            Iterator it = parentView.getChildren().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            it = parentView.getSourceEdges().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            it = parentView.getTargetEdges().iterator();
            while (it.hasNext() && !complete) {
                complete = LazyElement2ViewMap.buildElement2ViewMap((View)it.next(), element2ViewMap, elements);
            }
            return complete;
        }
    }
}

