/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.diagram.part;

import com.indy.map.Inliner;
import com.indy.map.MapPackage;
import com.indy.map.Outliner;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;

public class MapVisualIDRegistry {
    private static final String DEBUG_KEY = "com.indy.gmf.map.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return MapVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return MapVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return MapVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return MapVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return MapVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return MapVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Map".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return MapVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            if (view.eContainer() instanceof View) {
                view = (View)view.eContainer();
                continue;
            }
            return diagram != null ? diagram.getType() : null;
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if ("inheritanceLink".equals(type) || "joinLink".equals(type) || "joinDeductedLink".equals(type) || "targetDataSetLink".equals(type) || "targetLink".equals(type) || "targetSetLink".equals(type) || "operatorLink".equals(type) || "datastore.view".equals(type)) {
                return -2;
            }
            Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY));
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (MapPackage.eINSTANCE.getMap().isSuperTypeOf(domainElement.eClass())) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = MapVisualIDRegistry.getModelID(containerView);
        if (!"Map".equals(containerModelID)) {
            return -1;
        }
        if ("Map".equals(containerModelID)) {
            containerVisualID = MapVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (MapPackage.eINSTANCE.getQuery().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (MapPackage.eINSTANCE.getOutliner().isSuperTypeOf(domainElement.eClass()) || MapPackage.eINSTANCE.getInliner().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (MapPackage.eINSTANCE.getFilter().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (MapPackage.eINSTANCE.getVariable().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (MapPackage.eINSTANCE.getDatastore().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (MapPackage.eINSTANCE.getJoin().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (MapPackage.eINSTANCE.getInputParameter().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (!MapPackage.eINSTANCE.getOperator().isSuperTypeOf(domainElement.eClass())) break;
                return 2008;
            }
            case 7001: {
                if (!MapPackage.eINSTANCE.getSetDescriptor().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!MapPackage.eINSTANCE.getQueryField().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7011: {
                if (!MapPackage.eINSTANCE.getItemProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7003: {
                if (!MapPackage.eINSTANCE.getSetDescriptor().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7004: {
                if (!MapPackage.eINSTANCE.getField().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7005: {
                if (!MapPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7007: {
                if (!MapPackage.eINSTANCE.getComputedField().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7009: {
                if (!MapPackage.eINSTANCE.getItemProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7091: {
                if (!MapPackage.eINSTANCE.getSerdeField().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7092: {
                if (domainElement.eContainer() instanceof Outliner && MapPackage.eINSTANCE.getField().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!(domainElement.eContainer() instanceof Inliner) || !MapPackage.eINSTANCE.getQueryField().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7093: {
                if (domainElement.eContainer() instanceof Outliner && MapPackage.eINSTANCE.getQueryField().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (!(domainElement.eContainer() instanceof Inliner) || !MapPackage.eINSTANCE.getField().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = MapVisualIDRegistry.getModelID(containerView);
        if (!"Map".equals(containerModelID)) {
            return false;
        }
        if ("Map".equals(containerModelID)) {
            containerVisualID = MapVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7011 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (5090 == nodeVisualID) {
                    return true;
                }
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7091 == nodeVisualID) {
                    return true;
                }
                if (7092 == nodeVisualID) {
                    return true;
                }
                if (7093 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5010 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7091: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7092: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7093: {
                if (3009 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = MapVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7007: 
            case 7009: 
            case 7011: 
            case 7091: 
            case 7092: 
            case 7093: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2002: 
            case 2003: 
            case 2005: 
            case 2007: 
            case 2008: 
            case 3001: 
            case 3002: 
            case 3005: 
            case 3007: 
            case 3008: 
            case 3009: 
            case 3012: 
            case 3014: {
                return true;
            }
        }
        return false;
    }
}

