/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.utils;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class XmlReaderToWriter {
    int proof = -1;
    int levelToSkip = 0;

    public static XmlReaderToWriter createInstance() {
        return new XmlReaderToWriter();
    }

    public int writeAll(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        int ret = 0;
        while (xmlr.hasNext()) {
            ret += this.write(xmlr, writer);
            xmlr.next();
        }
        writer.flush();
        return ret += this.write(xmlr, writer);
    }

    private int write(XMLStreamReader xmlr, XMLStreamWriter writer) throws XMLStreamException {
        int ret = 0;
        if (this.levelToSkip > 0) {
            switch (xmlr.getEventType()) {
                case 1: {
                    if (++this.proof >= this.levelToSkip) break;
                    return 0;
                }
                case 2: {
                    if (this.proof-- >= this.levelToSkip) break;
                    return 0;
                }
                case 7: 
                case 8: {
                    return 0;
                }
            }
        }
        switch (xmlr.getEventType()) {
            case 1: {
                ret = 1;
                String localName = xmlr.getLocalName();
                String namespaceURI = xmlr.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.length() > 0) {
                    String prefix = xmlr.getPrefix();
                    if (prefix != null) {
                        writer.writeStartElement(prefix, localName, namespaceURI);
                    } else {
                        writer.setDefaultNamespace(namespaceURI);
                        writer.writeStartElement(localName);
                    }
                } else {
                    writer.writeStartElement(localName);
                }
                int i = 0;
                int len = xmlr.getNamespaceCount();
                while (i < len) {
                    writer.writeNamespace(xmlr.getNamespacePrefix(i), xmlr.getNamespaceURI(i));
                    ++i;
                }
                i = 0;
                len = xmlr.getAttributeCount();
                while (i < len) {
                    String attUri = xmlr.getAttributeNamespace(i);
                    if (attUri != null && !attUri.isEmpty()) {
                        writer.writeAttribute(attUri, xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                    } else {
                        writer.writeAttribute(xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 4: 
            case 6: {
                writer.writeCharacters(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
                break;
            }
            case 3: {
                writer.writeProcessingInstruction(xmlr.getPITarget(), xmlr.getPIData());
                break;
            }
            case 12: {
                writer.writeCData(xmlr.getText());
                break;
            }
            case 5: {
                writer.writeComment(xmlr.getText());
                break;
            }
            case 9: {
                writer.writeEntityRef(xmlr.getLocalName());
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 11: {
                writer.writeDTD(xmlr.getText());
            }
        }
        return ret;
    }

    public void setSkipProof(int levelToSkip) {
        this.levelToSkip = levelToSkip;
    }
}

