/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.RemoteSessionInfo;
import java.util.HashMap;
import java.util.Map;

public class LocalSession {
    private IEngineClient current;
    private RemoteSessionInfo rsi;
    private String currentHost;
    private int currentPort;
    private Boolean currentSSL = false;
    private Boolean currentHttp = false;

    public LocalSession(String currentHost, int currentPort, Boolean isSSL, Boolean isHTTP, IEngineClient remote, RemoteSessionInfo rsi) {
        this.current = remote;
        this.currentHost = currentHost;
        this.currentPort = currentPort;
        this.currentSSL = isSSL;
        this.currentHttp = isHTTP;
        this.rsi = rsi;
    }

    public Map<String, Object> getConnectionInformation() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("protocol", this.currentHttp != null && this.currentHttp != false ? "http" : "rmi");
        info.put("encryption", this.currentSSL != null && this.currentSSL != false ? "ssl/tls" : "none");
        return info;
    }

    public RemoteSessionInfo getInfo() {
        return this.rsi;
    }

    public IEngineClient getRemoteObject() {
        return this.current;
    }

    public String getRemoteHost() {
        return this.currentHost;
    }

    public int getRemotePort() {
        return this.currentPort;
    }

    public Boolean isUsingSsl() {
        return this.currentSSL;
    }
}

