/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.json.IDeferedSerialization;
import com.indy.runtime.json.IIterativeValue;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.Messages;
import jakarta.xml.bind.DatatypeConverter;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectHandler {
    private static final Logger LOGGER = LogManager.getLogger(ObjectHandler.class);
    static XMLInputFactory inputFactory;

    private ObjectHandler() {
    }

    public static void handleToXml(Object node, String memberName, XMLEventWriter jew, XMLEventFactory factory) throws Exception {
        boolean iterativeValue = false;
        if (node instanceof IIterativeValue) {
            iterativeValue = true;
        }
        if (node instanceof Iterable) {
            node = ((Iterable)((Object)node)).iterator();
        }
        if (memberName != null && !iterativeValue) {
            if (!JsonUtils.checkIfNameIsValid((String)memberName)) {
                try {
                    memberName = "_." + JsonUtils.encodeHexString((String)memberName) + "._";
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.debug("unsupported encoding", (Throwable)e);
                }
            }
            jew.add(factory.createStartElement(new QName((String)memberName), null, null));
        }
        if (node == null) {
            jew.add(factory.createAttribute(JsonConstants.XML_NIL, "true"));
        } else if (node instanceof Map) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "json:object"));
            Map nodeMap = (Map)((Object)node);
            for (Map.Entry entry : nodeMap.entrySet()) {
                Object child = entry.getValue();
                ObjectHandler.handleToXml(child, (String)entry.getKey(), jew, factory);
            }
        } else if (node instanceof Iterator) {
            if (!(node instanceof IIterativeValue)) {
                jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "json:array"));
            }
            Iterator it = node;
            try {
                while (it.hasNext()) {
                    Object o = it.next();
                    if (node instanceof IDeferedSerialization) {
                        o = UtilsService.getJsonUtils().createGenericalObjectWithRealObject(o);
                    }
                    if (iterativeValue) {
                        ObjectHandler.handleToXml(o, (String)memberName, jew, factory);
                        continue;
                    }
                    ObjectHandler.handleToXml(o, "e", jew, factory);
                }
            }
            finally {
                if (it instanceof Closeable) {
                    ((Closeable)((Object)it)).close();
                }
            }
        } else if (node instanceof String) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "string"));
            jew.add(factory.createCharacters(UtilsService.getXmlUtils().escapeXML((String)((Object)node))));
        } else if (node instanceof Integer) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "int"));
            jew.add(factory.createCharacters(DatatypeConverter.printInt((int)((Integer)((Object)node)))));
        } else if (node instanceof BigInteger) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "integer"));
            jew.add(factory.createCharacters(DatatypeConverter.printInteger((BigInteger)((BigInteger)((Object)node)))));
        } else if (node instanceof Boolean) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "boolean"));
            jew.add(factory.createCharacters(DatatypeConverter.printBoolean((boolean)((Boolean)((Object)node)))));
        } else if (node instanceof BigDecimal) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "decimal"));
            jew.add(factory.createCharacters(DatatypeConverter.printDecimal((BigDecimal)((BigDecimal)((Object)node)))));
        } else if (node instanceof byte[]) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "base64Binary"));
            jew.add(factory.createCharacters(DatatypeConverter.printBase64Binary((byte[])((byte[])node))));
        } else if (node instanceof Long) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "long"));
            jew.add(factory.createCharacters(DatatypeConverter.printLong((long)((Long)((Object)node)))));
        } else if (node instanceof Double) {
            jew.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi"), "double"));
            jew.add(factory.createCharacters(DatatypeConverter.printDouble((double)((Double)((Object)node)))));
        } else if (node instanceof IJsonUtils.Adapter) {
            for (XMLEvent event : (Collection)((IJsonUtils.Adapter)((Object)node)).adapt(Collection.class, null)) {
                jew.add(event);
            }
        } else {
            throw new Exception(Messages.getString("ObjectHandler.0") + node.getClass().getName());
        }
        if (memberName != null && !iterativeValue) {
            jew.add(factory.createEndElement(new QName((String)memberName), null));
        }
    }
}

