/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json.internal;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;

public class JsonEventCatcher {
    JsonEventReader jer;

    public JsonEventCatcher(JsonEventReader reader) {
        this.jer = reader;
    }

    public boolean read(JsonEventHandler handler, String paramPath) throws Exception {
        Path path = new Path(paramPath);
        Path currentPath = new Path();
        ArrayDeque<JSonEvent> container = new ArrayDeque<JSonEvent>();
        JSonEvent previous = null;
        boolean listen = false;
        boolean returnValue = false;
        while (this.jer.hasNext()) {
            JSonEvent event = this.jer.readNext();
            if (event.getType() == JSonEvent.Type.START_OBJECT || event.getType() == JSonEvent.Type.START_ARRAY) {
                if (previous != null && previous.getType() == JSonEvent.Type.MEMBER) {
                    currentPath.add(previous.getName());
                } else {
                    currentPath.add("e");
                }
                if (currentPath.equals(path)) {
                    handler.handleStart();
                    listen = true;
                }
                container.push(event);
            } else if (event.getType() == JSonEvent.Type.END_OBJECT || event.getType() == JSonEvent.Type.END_ARRAY) {
                container.pop();
                if (currentPath.equals(path)) {
                    handler.handleEvent(event);
                    handler.handleEnd();
                    listen = false;
                }
                currentPath.remove();
            } else if (currentPath.isEmpty() && paramPath.equals("*") && (event.getType() == JSonEvent.Type.VALUE || event.getType() == JSonEvent.Type.STRING)) {
                handler.handleStart();
                handler.handleEvent(event);
                handler.handleEnd();
            }
            previous = event;
            if (!listen) continue;
            handler.handleEvent(event);
        }
        return returnValue;
    }

    public static interface JsonEventHandler {
        public void handleEvent(JSonEvent var1) throws Exception;

        public void handleEnd() throws Exception;

        public void handleStart() throws Exception;
    }

    static class Path {
        Deque<String> stack = new ArrayDeque<String>();

        public Path() {
        }

        public Path(String path) {
            String[] stringArray = path.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                this.add(str);
                ++n2;
            }
        }

        void add(String str) {
            this.stack.push(str);
        }

        void remove() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }

        boolean isEmpty() {
            return this.stack.isEmpty();
        }

        public int hashCode() {
            return Objects.hash(this.stack);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Path) {
                Path path = (Path)obj;
                if (path.stack.size() == this.stack.size()) {
                    Iterator<String> iterator = this.stack.iterator();
                    Iterator<String> comparedIterator = path.stack.iterator();
                    while (iterator.hasNext()) {
                        String compareStr = comparedIterator.next();
                        String str = iterator.next();
                        if (compareStr.equals("*") || str.equals(compareStr)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            Object ret = "";
            Iterator<String> iterator = this.stack.descendingIterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                ret = (String)ret + "/" + string;
            }
            return ret;
        }
    }
}

