/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql;

import com.indy.ui.sql.ISQLDictionary;
import com.indy.ui.sql.internal.KeyWords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SQLDictionary
implements ISQLDictionary {
    private List<ISQLDictionary.Item> items = new ArrayList<ISQLDictionary.Item>();
    private Set<String> keyWords = new HashSet<String>();

    public SQLDictionary() {
        this.keyWords.addAll(Arrays.asList(KeyWords.fgKeywords));
        this.keyWords.addAll(Arrays.asList(KeyWords.sqlFunctions));
    }

    @Override
    public Collection<ISQLDictionary.Item> getItems() {
        return this.items;
    }

    @Override
    public Collection<String> getKeywords() {
        return this.keyWords;
    }

    @Override
    public void addItem(ISQLDictionary.Item item) {
        this.items.add(item);
    }

    @Override
    public ISQLDictionary.Item getItem(String label) {
        Optional<ISQLDictionary.Item> r = this.items.stream().filter(i -> i.getLabel().equalsIgnoreCase(label)).findAny();
        if (r.isPresent()) {
            return r.get();
        }
        return null;
    }
}

