/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.osgihook.utils.JavaProps;
import com.indy.osgihook.utils.StambiaEnvironmentPropertyReader;
import com.indy.ui.custom.out.common.Unloadable;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static ColorRegistry colorRegistry;
    public static final String PLUGIN_ID = "com.indy.ui.custom.out";
    private static final String HIDDEN_ACTIVITY_ID = "com.indy.ui.custom.out.hiddenActivity";
    private static final String PROJECT_EXPLORER_VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private static Activator plugin;
    private IWindowListener windowListener;
    private IPartListener partListener;
    private ITreeViewerListener projectExplorerTreeListener = new ITreeViewerListener(){

        private void releaseResource(IFile f, final CommonViewer v) {
            ITreeContentProvider p = (ITreeContentProvider)v.getContentProvider();
            final Object[] c = p.getChildren((Object)f);
            if (c.length == 0) {
                return;
            }
            Set set = v.getNavigatorContentService().findContentExtensionsByTriggerPoint(c[0]);
            for (Object o : set) {
                if (!(((NavigatorContentExtension)o).getContentProvider() instanceof Unloadable)) continue;
                ((Unloadable)((NavigatorContentExtension)o).getContentProvider()).unload(c);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    v.remove(c);
                    if (v.getNavigatorContentService().getActivationService() != null) {
                        v.getNavigatorContentService().getActivationService().activateExtensions(new String[]{"dummy"}, false);
                    }
                    Object[] objectArray = c;
                    int n = c.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ((NavigatorContentService)v.getNavigatorContentService()).forgetContribution(o);
                        ++n2;
                    }
                }
            });
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            CommonViewer v = (CommonViewer)event.getSource();
            if (!(v.getContentProvider() instanceof ITreeContentProvider)) {
                return;
            }
            if (event.getElement() instanceof IFile) {
                IFile f = (IFile)event.getElement();
                if (f.getFileExtension() != null && (f.getFileExtension().equals("proc") || f.getFileExtension().equals("map") || f.getFileExtension().equals("md"))) {
                    this.releaseResource(f, v);
                }
            } else {
                TreePath[] treePathArray = v.getExpandedTreePaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath o = treePathArray[n2];
                    int i = 0;
                    while (i < o.getSegmentCount()) {
                        IFile f;
                        if (o.getLastSegment() != event.getElement() && o.getSegment(i) == event.getElement() && o.getLastSegment() instanceof IFile && (f = (IFile)o.getLastSegment()).getFileExtension() != null && (f.getFileExtension().equals("proc") || f.getFileExtension().equals("map") || f.getFileExtension().equals("md"))) {
                            this.releaseResource(f, v);
                        }
                        ++i;
                    }
                    ++n2;
                }
            }
        }
    };
    private boolean isWorkbenchStarted = false;

    public Activator() {
        this.partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part.getSite().getId().equals(Activator.PROJECT_EXPLORER_VIEW_ID) && ((ProjectExplorer)part).getCommonViewer() != null) {
                    ((ProjectExplorer)part).getCommonViewer().removeTreeListener(Activator.this.projectExplorerTreeListener);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                IWorkbenchActivitySupport as = Activator.this.getWorkbench().getActivitySupport();
                IActivityManager am = as.getActivityManager();
                if (Activator.PROJECT_EXPLORER_VIEW_ID.equals(part.getSite().getId()) && ((ProjectExplorer)part).getCommonViewer() != null) {
                    ((ProjectExplorer)part).getCommonViewer().addTreeListener(Activator.this.projectExplorerTreeListener);
                }
            }
        };
        this.windowListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                window.getActivePage().addPartListener(Activator.this.partListener);
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                if (window != null && window.getActivePage() != null && Activator.this.partListener != null) {
                    window.getActivePage().removePartListener(Activator.this.partListener);
                }
            }

            public void windowActivated(IWorkbenchWindow window) {
            }
        };
    }

    public Color getColor(RGB rgb) {
        return this.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public Color getColor(int red, int green, int blue) {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry(Display.getCurrent(), true);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(red);
        buf.append("#");
        buf.append(green);
        buf.append("#");
        buf.append(blue);
        String colorName = buf.toString();
        Color c = colorRegistry.get(colorName);
        if (c == null) {
            colorRegistry.put(colorName, new RGB(red, green, blue));
            c = colorRegistry.get(colorName);
        }
        return c;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.isWorkbenchStarted) {
            this.getWorkbench().removeWindowListener(this.windowListener);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void handleWorkbenchStarted() {
        try {
            this.getWorkbench().addWindowListener(this.windowListener);
            if (this.partListener != null && this.getWorkbench().getActiveWorkbenchWindow() != null && this.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                this.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListener);
            }
            DebugUIPlugin debugUIPlugin = DebugUIPlugin.getDefault();
        }
        finally {
            this.isWorkbenchStarted = true;
        }
    }

    public String readProperty(String key, String defaultValue) {
        String v = this.readProperty(key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public String readProperty(JavaProps prop) {
        EnvironmentInfo envInfo = (EnvironmentInfo)E4InjectorHelper.getService(EnvironmentInfo.class);
        String v = StambiaEnvironmentPropertyReader.readProperty((JavaProps)prop, (EnvironmentInfo)envInfo);
        if (v == null) {
            return prop.getDefault();
        }
        return v;
    }

    public String readProperty(String key) {
        EnvironmentInfo envInfo = (EnvironmentInfo)E4InjectorHelper.getService(EnvironmentInfo.class);
        return StambiaEnvironmentPropertyReader.readProperty((String)key, (EnvironmentInfo)envInfo);
    }

    public void writeProperty(String key, String value) {
        ((EnvironmentInfo)E4InjectorHelper.getService(EnvironmentInfo.class)).setProperty(key, value);
    }
}

