/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialogEditor
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private Text text;
    private boolean isEditable;
    private boolean monoLine = false;
    private int style = 0;

    public TextDialogEditor(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue) {
        super(parentShell);
        this.init(parentShell, dialogTitle, dialogMessage, initialValue, true);
    }

    public void init(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, boolean isEditable) {
        this.title = dialogTitle;
        this.setShellStyle(68720);
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.isEditable = isEditable;
    }

    public TextDialogEditor(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, boolean isEditable) {
        super(parentShell);
        this.init(parentShell, dialogTitle, dialogMessage, initialValue, isEditable);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    public void setMonoLine(boolean monoLine) {
        this.monoLine = monoLine;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(768, 1028, false, true);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.text = !this.monoLine ? new Text(composite, 0xB12 | this.style) : new Text(composite, 0x810 | this.style);
        this.text.setEditable(this.isEditable);
        GridData data = new GridData(4, 4, true, true);
        if (!this.monoLine) {
            data.heightHint = 20 * this.text.getLineHeight();
        }
        this.text.setLayoutData((Object)data);
        this.createAdditionalControls(composite);
        TextDialogEditor.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createAdditionalControls(Composite parent) {
    }

    protected Text getText() {
        return this.text;
    }

    public String getValue() {
        return this.value;
    }
}

