/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.action.editor;

import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.PropertiesBrowserPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.handlers.WidgetMethodHandler;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;

public class EmfActionsReplacer
implements ISelectionChangedListener {
    private IAction emfCpy;
    private IAction emfPaste;
    private IAction emfCut;
    private IAction emfDelete;
    private IAction txtCpy;
    private IAction txtPaste;
    private IAction txtCut;
    private IAction txtDelete;
    private boolean inited = false;
    private boolean propertiesHasFocus = false;
    private FocusControler fL = new FocusControler();
    private IEditorSite editorSite;
    private ITabSelectionListener tabListener;
    private PropertiesBrowserPage page;
    private List<Viewer> viewers;
    private FocusListener viewerFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            EmfActionsReplacer.this.setPropsHasFocus(false);
        }
    };

    public boolean isInited() {
        return this.inited;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.registerFocusListener(this.page.getControl());
        if (event.getSource() instanceof Viewer) {
            this.registerFocusListener(((Viewer)event.getSource()).getControl());
        }
    }

    public void init(IEditorSite site, List<Viewer> viewers, PropertiesBrowserPage page) {
        this.editorSite = site;
        this.page = page;
        this.tabListener = new ITabSelectionListener(){

            public void tabSelected(ITabDescriptor tabDescriptor) {
                EmfActionsReplacer.this.registerFocusListener(EmfActionsReplacer.this.page.getControl());
            }
        };
        page.addTabSelectionListener(this.tabListener);
        this.viewers = new ArrayList<Viewer>(viewers);
        for (Viewer v : viewers) {
            v.getControl().addFocusListener(this.viewerFocusListener);
            v.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.emfCpy = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId());
        this.emfPaste = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.emfCut = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId());
        this.emfDelete = this.getActionBarContributor().getActionBars().getGlobalActionHandler(ActionFactory.DELETE.getId());
        WidgetMethodHandler h = new WidgetMethodHandler();
        h.setInitializationData(null, null, (Object)"copy");
        this.txtCpy = new FocusAction((IHandler)h);
        h = new WidgetMethodHandler();
        h.setInitializationData(null, null, (Object)"paste");
        this.txtPaste = new FocusAction((IHandler)h);
        h = new WidgetMethodHandler();
        h.setInitializationData(null, null, (Object)"cut");
        this.txtCut = new FocusAction((IHandler)h);
        this.txtDelete = new Action(){

            public void run() {
                Control focusControl = Display.getCurrent().getFocusControl();
                if (focusControl.isEnabled()) {
                    try {
                        if ((focusControl.getStyle() & 8) == 0 && focusControl instanceof Text) {
                            if (((Text)focusControl).getSelectionCount() > 0) {
                                Point p = ((Text)focusControl).getSelection();
                                Object txt = ((Text)focusControl).getText();
                                txt = ((String)txt).substring(0, p.x) + ((String)txt).substring(p.y);
                                ((Text)focusControl).setText((String)txt);
                                ((Text)focusControl).setSelection(p.x);
                            } else {
                                Point p = ((Text)focusControl).getSelection();
                                Object txt = ((Text)focusControl).getText();
                                if (p.x < ((String)txt).length()) {
                                    txt = ((String)txt).substring(0, p.x) + ((String)txt).substring(p.x + 1);
                                    ((Text)focusControl).setText((String)txt);
                                    ((Text)focusControl).setSelection(p.x);
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", Messages.EmfActionsReplacer_0, t));
                    }
                }
            }
        };
        this.registerFocusListener(page.getControl());
        this.inited = true;
    }

    public void dispose() {
        if (this.viewers != null) {
            for (Viewer v : this.viewers) {
                v.removeSelectionChangedListener((ISelectionChangedListener)this);
                if (v.getControl().isDisposed()) continue;
                v.getControl().removeFocusListener(this.viewerFocusListener);
            }
            this.viewers.clear();
        }
        if (this.fL != null) {
            this.fL.dispose();
        }
        if (this.page != null) {
            this.page.removeTabSelectionListener(this.tabListener);
        }
        this.page = null;
        this.editorSite = null;
    }

    private void registerFocusListener(Control c) {
        if (!c.isDisposed()) {
            this.fL.addControl(c);
            if (c instanceof Composite) {
                Control[] controlArray = ((Composite)c).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control cc = controlArray[n2];
                    this.registerFocusListener(cc);
                    ++n2;
                }
            }
        }
    }

    public void setPropsHasFocus(boolean value) {
        if (value == this.propertiesHasFocus) {
            return;
        }
        this.propertiesHasFocus = value;
        if (this.propertiesHasFocus) {
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.txtCpy);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.txtPaste);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.txtCut);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.txtDelete);
        } else {
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.emfCpy);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.emfPaste);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.emfCut);
            this.getActionBarContributor().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.emfDelete);
        }
        this.getActionBarContributor().update();
    }

    private EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    private IEditorSite getEditorSite() {
        return this.editorSite;
    }

    private class FocusAction
    extends Action {
        private IHandler h;

        public FocusAction(IHandler h) {
            this.h = h;
        }

        public void run() {
            try {
                this.h.execute(null);
            }
            catch (Throwable t) {
                String action = null;
                if (this == EmfActionsReplacer.this.txtCpy) {
                    action = "copy";
                } else if (this == EmfActionsReplacer.this.txtCut) {
                    action = "cut";
                } else if (this == EmfActionsReplacer.this.txtDelete) {
                    action = "delete";
                } else if (this == EmfActionsReplacer.this.txtPaste) {
                    action = "paste";
                }
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.ui.custom.out", "Failed to " + action + " text", t));
            }
        }
    }

    private class FocusControler
    implements FocusListener {
        List<Control> listenedControl = new ArrayList<Control>();

        private FocusControler() {
        }

        void addControl(final Control c) {
            if (!this.listenedControl.contains(c)) {
                c.addFocusListener((FocusListener)this);
                c.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        FocusControler.this.listenedControl.remove(c);
                    }
                });
            }
        }

        public void focusGained(FocusEvent e) {
            boolean viewerHasFocus = true;
            for (Viewer v : EmfActionsReplacer.this.viewers) {
                if (v.getControl() != e.getSource()) continue;
                viewerHasFocus = false;
                break;
            }
            EmfActionsReplacer.this.setPropsHasFocus(viewerHasFocus);
        }

        public void focusLost(FocusEvent e) {
        }

        void dispose() {
            for (Control c : this.listenedControl) {
                if (c.isDisposed()) continue;
                c.removeFocusListener((FocusListener)this);
            }
            this.listenedControl.clear();
        }
    }
}

