/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.action.editor;

import com.indy.ui.custom.out.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.IUpdate;

public class TextViewerSupport
implements FocusListener,
DisposeListener {
    private TextViewer textViewer;
    private List<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>();
    private MenuManager menuMgr;
    private IHandlerService handlerService;

    public TextViewerSupport(TextViewer textViewer, MenuManager menuMgr) {
        this.textViewer = textViewer;
        this.menuMgr = menuMgr;
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (IHandlerActivation a : TextViewerSupport.this.handlerActivations) {
                    manager.add(((ActionHandler)a.getHandler()).getAction());
                }
            }
        });
        this.textViewer.getTextWidget().setMenu(this.menuMgr.createContextMenu((Control)this.textViewer.getTextWidget()));
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (IHandlerActivation a : TextViewerSupport.this.handlerActivations) {
                    if (!(((ActionHandler)a.getHandler()).getAction() instanceof IUpdate)) continue;
                    ((IUpdate)((ActionHandler)a.getHandler()).getAction()).update();
                }
            }
        });
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.handlerService = (IHandlerService)window.getService(IHandlerService.class);
        StyledText textWidget = textViewer.getTextWidget();
        textWidget.addFocusListener((FocusListener)this);
        textWidget.addDisposeListener((DisposeListener)this);
        if (textViewer.getTextWidget().isFocusControl()) {
            this.activateContext();
        }
    }

    public void focusLost(FocusEvent e) {
        this.deactivateContext();
    }

    public void focusGained(FocusEvent e) {
        this.activateContext();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.deactivateContext();
    }

    protected void activateContext() {
        if (this.handlerActivations.isEmpty()) {
            this.activateHandler(4, "org.eclipse.ui.edit.copy", Messages.TextViewerSupport_0);
            this.activateHandler(5, "org.eclipse.ui.edit.paste", Messages.TextViewerSupport_1);
        }
    }

    protected void activateHandler(int operation, String actionDefinitionId, String text) {
        StyledText textWidget = this.textViewer.getTextWidget();
        IHandler actionHandler = this.createActionHandler(operation, actionDefinitionId, text);
        IHandlerActivation handlerActivation = this.handlerService.activateHandler(actionDefinitionId, actionHandler, (Expression)new ActiveFocusControlExpression((Control)textWidget));
        this.handlerActivations.add(handlerActivation);
    }

    private IHandler createActionHandler(int operation, String actionDefinitionId, String actionText) {
        TextAction action = new TextAction(operation, actionText);
        action.setActionDefinitionId(actionDefinitionId);
        this.menuMgr.add((IAction)action);
        return new ActionHandler((IAction)action);
    }

    protected void deactivateContext() {
        if (!this.handlerActivations.isEmpty()) {
            for (IHandlerActivation activation : this.handlerActivations) {
                this.handlerService.deactivateHandler(activation);
                activation.getHandler().dispose();
            }
            this.handlerActivations.clear();
            this.menuMgr.removeAll();
        }
    }

    public class ActiveFocusControlExpression
    extends Expression {
        private Control focusControl;

        public ActiveFocusControlExpression(Control control) {
            this.focusControl = control;
        }

        public void collectExpressionInfo(ExpressionInfo info) {
            info.markDefaultVariableAccessed();
            info.addVariableNameAccess("activeShell");
            info.addVariableNameAccess("activeWorkbenchWindow");
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            if (Display.getCurrent() != null && this.focusControl.isFocusControl()) {
                return EvaluationResult.TRUE;
            }
            return EvaluationResult.FALSE;
        }
    }

    public class TextAction
    extends Action
    implements IUpdate {
        int operation;

        TextAction(int operation, String text) {
            super(text);
            this.operation = operation;
        }

        public void run() {
            if (TextViewerSupport.this.textViewer.canDoOperation(this.operation)) {
                TextViewerSupport.this.textViewer.doOperation(this.operation);
            }
        }

        public boolean isEnabled() {
            return TextViewerSupport.this.textViewer.canDoOperation(this.operation);
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = TextViewerSupport.this.textViewer != null && TextViewerSupport.this.textViewer.canDoOperation(this.operation);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }
    }
}

