/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common;

import com.indy.ui.custom.out.common.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class TooltipHelper {
    private boolean toolTipActive = false;
    private Shell popup = null;
    private String text;
    private UIJob scheduleClose = new UIJob(Messages.TooltipHelper_0){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TooltipHelper.this.toolTipActive && TooltipHelper.this.popup != null && !TooltipHelper.this.popup.isDisposed()) {
                TooltipHelper.this.hideTooltip();
            }
            return Status.OK_STATUS;
        }
    };
    private Listener displayListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 32 && !TooltipHelper.this.toolTipActive) {
                TooltipHelper.this.hideTooltip();
            }
            if (event.type == 5 && TooltipHelper.this.scheduleClose.getState() != 1) {
                TooltipHelper.this.scheduleClose.schedule(500L);
            }
            if (event.type == 3) {
                if (!TooltipHelper.this.toolTipActive) {
                    Point pt = TooltipHelper.this.popup.getDisplay().getCursorLocation();
                    Rectangle r1 = TooltipHelper.this.popup.getBounds();
                    if (r1.contains(pt)) {
                        TooltipHelper.this.popup.close();
                        TooltipHelper.this.toolTipActive = true;
                        TooltipHelper.this.createPopup();
                        TooltipHelper.this.relocatePopup();
                        TooltipHelper.this.popup.open();
                        TooltipHelper.this.popup.getDisplay().addFilter(3, TooltipHelper.this.displayListener);
                        TooltipHelper.this.popup.getDisplay().addFilter(32, TooltipHelper.this.displayListener);
                    }
                } else {
                    Point pt = TooltipHelper.this.popup.getDisplay().getCursorLocation();
                    Rectangle r1 = TooltipHelper.this.popup.getBounds();
                    if (!r1.contains(pt)) {
                        TooltipHelper.this.toolTipActive = false;
                        TooltipHelper.this.popup.close();
                        TooltipHelper.this.createPopup();
                    }
                }
            }
        }
    };
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            if (!TooltipHelper.this.toolTipActive) {
                switch (event.type) {
                    case 32: {
                        if (TooltipHelper.this.popup != null && !TooltipHelper.this.popup.isDisposed() && TooltipHelper.this.popup.isVisible()) break;
                        event.widget.getDisplay().timerExec(50, new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TooltipHelper.this.popup != null && !(this).TooltipHelper.this.popup.isDisposed()) {
                                    (this).TooltipHelper.this.popup.setVisible(true);
                                    (this).TooltipHelper.this.popup.getDisplay().addFilter(3, (this).TooltipHelper.this.displayListener);
                                    (this).TooltipHelper.this.popup.getDisplay().addFilter(32, (this).TooltipHelper.this.displayListener);
                                    (this).TooltipHelper.this.popup.getDisplay().addFilter(5, (this).TooltipHelper.this.displayListener);
                                    TooltipHelper.this.relocatePopup();
                                }
                            }
                        });
                    }
                }
            }
        }
    };
    private Control control;
    private boolean sizeInitialized = false;

    protected void relocatePopup() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        Rectangle clientArea = this.control.getDisplay().getClientArea();
        Point preferredLocation = this.control.getLocation();
        preferredLocation.y += this.control.getSize().y;
        preferredLocation = this.control.getParent().toDisplay(preferredLocation);
        if (clientArea.width / 2 > preferredLocation.x) {
            clientArea.width /= 2;
        }
        Point preferredSize = this.popup.getSize();
        if (!this.sizeInitialized) {
            preferredSize.x += 20;
            preferredSize.y += 20;
            this.sizeInitialized = true;
        }
        if (preferredLocation.y + preferredSize.y > clientArea.height) {
            preferredLocation.y -= preferredSize.y;
        }
        if (preferredLocation.y < clientArea.y) {
            preferredLocation.y = clientArea.y;
        }
        if (preferredLocation.x + preferredSize.x > clientArea.width) {
            preferredLocation.x -= preferredLocation.x + preferredSize.x - clientArea.width;
        }
        if (preferredLocation.x < clientArea.x) {
            preferredLocation.x = clientArea.x;
        }
        this.popup.setLocation(preferredLocation.x, preferredLocation.y);
        this.popup.setSize(preferredSize.x, preferredSize.y);
    }

    private void hideTooltip() {
        this.popup.getDisplay().timerExec(50, new Runnable(){

            @Override
            public void run() {
                Point pt = TooltipHelper.this.popup.getDisplay().getCursorLocation();
                Rectangle r1 = TooltipHelper.this.popup.getBounds();
                Rectangle r2 = TooltipHelper.this.control.getBounds();
                Point p = TooltipHelper.this.control.toDisplay(r2.x, r2.y);
                r2 = new Rectangle(p.x, p.y, r2.width, r2.height);
                if (!r1.contains(pt) && !r2.contains(pt)) {
                    TooltipHelper.this.popup.getDisplay().removeFilter(3, TooltipHelper.this.displayListener);
                    TooltipHelper.this.popup.getDisplay().removeFilter(32, TooltipHelper.this.displayListener);
                    TooltipHelper.this.popup.getDisplay().removeFilter(5, TooltipHelper.this.displayListener);
                    TooltipHelper.this.popup.setVisible(false);
                }
            }
        });
    }

    private void createPopup() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
        }
        this.popup = new Shell(this.control.getShell(), this.toolTipActive ? 20 : 4);
        this.popup.setLayout((Layout)new FillLayout());
        Text l = new Text((Composite)this.popup, 578);
        l.setText(this.text);
        l.setEditable(false);
        l.setBackground(Display.getDefault().getSystemColor(29));
        this.popup.setSize(this.popup.computeSize(-1, -1));
        this.popup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                e.display.removeFilter(3, TooltipHelper.this.displayListener);
                e.display.removeFilter(32, TooltipHelper.this.displayListener);
                e.display.removeFilter(5, TooltipHelper.this.displayListener);
            }
        });
    }

    public void dispose() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.getDisplay().removeFilter(3, this.displayListener);
            this.popup.getDisplay().removeFilter(32, this.displayListener);
            this.popup.getDisplay().removeFilter(5, this.displayListener);
            if (this.scheduleClose.getState() != 1) {
                this.scheduleClose.cancel();
            }
            this.popup.dispose();
            this.popup = null;
        }
        this.control = null;
    }

    public TooltipHelper(String content, Control control) {
        this.control = control;
        this.text = content;
        this.createPopup();
        control.addListener(32, this.listener);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TooltipHelper.this.dispose();
            }
        });
    }
}

