/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.listener;

import com.indy.ui.custom.out.listener.EditorListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;

public class EditorListenerRegistryMulti {
    static Map<DiagramEditor, List<EditorListener>> map = Collections.synchronizedMap(new HashMap());

    public static void register(DiagramEditor editor, EditorListener listener) {
        List<EditorListener> list = map.get(editor);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
            map.put(editor, list);
        }
        list.add(listener);
    }

    public static void fireDispose(DiagramEditor editor) {
        List<EditorListener> list = map.get(editor);
        if (list != null) {
            for (EditorListener listener : list) {
                listener.handleDispose((IDiagramWorkbenchPart)editor);
            }
            list.clear();
            map.remove(editor);
        }
    }

    static void unregister(DiagramEditor editor, EditorListener listener) {
        List<EditorListener> list = map.get(editor);
        if (list != null) {
            list.remove(listener);
        }
    }
}

