<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://saxon.sf.net/" xmlns:rdbms="http://www.stambia.com/rdbms" extension-element-prefixes="saxon" exclude-result-prefixes="xsl saxon rdbms ">
	<xsl:variable name="indice" saxon:assignable="yes"/>
	<xsl:variable name="varJoins" saxon:assignable="yes"/>
	<xsl:template name="rdbms:join">
		<xsl:param name="bracket" tunnel="yes"/>
		<xsl:param name="joins"/>
		<xsl:variable name="addProofJoins">
			<xsl:for-each select="$joins/join">
				<join>
					<xsl:copy-of select="@*"/>
					<xsl:variable name="proof">
						<xsl:apply-templates mode="joinProof" select=".">
							<xsl:with-param name="left" select="left"/>
							<xsl:with-param name="joins" select="$joins/join" tunnel="yes"/>
						</xsl:apply-templates>
					</xsl:variable>
					<xsl:attribute name="proof" select="string-length($proof)"/>
					<xsl:copy-of select="*"/>
				</join>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="treeJoin">
			<saxon:assign name="varJoins">
				<empty/>
			</saxon:assign>
			<xsl:for-each select="$addProofJoins/join">
				<xsl:sort select="if ($bracket) then @id else @proof" data-type="number"/>
				<xsl:sort select="@id" data-type="number"/>
				<xsl:variable name="overrideRight" select="$varJoins[.//left=current()/right or .//right=current()/right]">
					<!--on cherche si cette jointure est la partie droite d'une autre qui aurait déjà été traité
Si c'est le cas on override-->
				</xsl:variable>
				<xsl:variable name="overrideLeft" select="$varJoins[.//left=current()/left or .//right=current()/left]">
					<!--on cherche si cette jointure est la partie gauche d'une autre qui aurait déjà été traité
Si c'est le cas on override-->
				</xsl:variable>
				<saxon:assign name="varJoins">
					<xsl:variable name="tab">
						<saxon:assign name="indice" select="0"/>
						<saxon:while test="@id>$indice">
							<saxon:assign name="indice" select="$indice + 1"/>&#x9;<xsl:value-of select="'&#x9;'"/>
						</saxon:while>
					</xsl:variable>
					<join>
						<xsl:choose>
							<xsl:when test="$overrideLeft=$overrideRight">
								<!--Les deux tables sont déjà présentes-->
								<xsl:copy-of select="$overrideLeft/(@* | *)"/>
								<on>
									<xsl:value-of select="on"/>
								</on>
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy-of select="@* | expr | type | on"/>
								<id>
									<xsl:value-of select="@id"/>
								</id>
								<left>
									<xsl:choose>
										<xsl:when test="$overrideLeft">
											<xsl:copy-of select="$overrideLeft"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="left"/>
										</xsl:otherwise>
									</xsl:choose>
								</left>
								<right>
									<xsl:choose>
										<xsl:when test="$overrideRight">
											<xsl:copy-of select="$overrideRight"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="right"/>
										</xsl:otherwise>
									</xsl:choose>
								</right>
							</xsl:otherwise>
						</xsl:choose>
					</join>
					<xsl:copy-of select="$varJoins[not(exists(id[.=$overrideRight//id])) and not(exists(id[.=$overrideLeft//id]))]"/>
				</saxon:assign>
			</xsl:for-each>
			<xsl:copy-of select="$varJoins[name()='join']"/>
		</xsl:variable>
		<xsl:for-each select="$treeJoin/join">
			<xsl:apply-templates select="." mode="formatJoin"/>
			<xsl:if test="not(position()=last())">,
</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="join" mode="joinProof">
		<xsl:param name="joins" tunnel="yes"/>
		<xsl:param name="left"/>
		<xsl:for-each select="$joins[not(.=current())]">
			<xsl:if test=" string(right)=string($left) ">1<xsl:apply-templates select="." mode="joinProof">
					<xsl:with-param name="left" select="left"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="join" mode="formatJoin">
		<xsl:param select="'&#x9;'" name="tab"/>
		<xsl:param name="bracket" tunnel="yes"/>
		<xsl:variable name="tab" select="if ($bracket) then $tab else ''"/>
		<xsl:if test="$bracket and exists(ancestor::join)">(</xsl:if>
		<xsl:choose>
			<xsl:when test="left/join">
				<xsl:apply-templates select="left/join" mode="formatJoin">
					<xsl:with-param name="tab">
						<xsl:value-of select="$tab"/>
						<xsl:value-of select="'&#x9;'"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="left"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="concat('&#xA;',$tab,expr,' ')"/>
		<xsl:choose>
			<xsl:when test="right/join">
				<xsl:apply-templates select="right/join" mode="formatJoin">
					<xsl:with-param name="tab">
						<xsl:value-of select="$tab"/>
						<xsl:value-of select="'&#x9;'"/>
					</xsl:with-param>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="right"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="on">
			<xsl:variable name="on">
				<xsl:choose>
					<xsl:when test="count(on)=1">
						<xsl:value-of select="on"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="on">
							<xsl:if test="position()>1">
								<xsl:text> AND </xsl:text>
							</xsl:if>
							<xsl:value-of select="concat('(',.,')')"/>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:value-of select="concat('&#xA;',$tab,'ON ',$on)"/>
		</xsl:if>
		<xsl:if test="$bracket and exists(ancestor::join)">)</xsl:if>
	</xsl:template>
	<xsl:template match="join" mode="join">
		<xsl:param name="bracket" tunnel="yes"/>
		<xsl:variable name="left">
			<xsl:choose>
				<xsl:when test="not(join)">
					<!--Si plus de jointures filles-->
					<xsl:if test="$bracket or ../name()!='join'">
						<xsl:value-of select="left"/>
					</xsl:if>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$bracket">
					<!--Si jointures filles-->
					<xsl:variable name="disableRight" select="right = join//left or right=join//right"/>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:choose>
						<xsl:when test="$disableRight">
							<xsl:value-of select="left"/>
							<xsl:value-of select="concat(' ',expr,' ')"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="join">
						<xsl:text>
</xsl:text>
						<xsl:if test="$bracket">(</xsl:if>
						<xsl:apply-templates select="join" mode="join"/>
						<xsl:if test="$bracket">)</xsl:if>
						<xsl:text>
</xsl:text>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="$disableLeft">
							<xsl:value-of select="concat(' ',expr,' ')"/>
							<xsl:value-of select="right"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="disableRight" select="right = join//left or right=join//right">
						<!--si la partie droite est utilisée dans une sous jointure
alors on écrit la partie gauche-->
					</xsl:variable>
					<xsl:variable name="disableLeft" select="left = join//left or left=join//right"/>
					<xsl:if test="../name()!='join'">
						<xsl:value-of select="left"/>
					</xsl:if>
					<xsl:value-of select="concat(' ',expr,' ')"/>
					<xsl:choose>
						<xsl:when test="$disableRight"/>
					</xsl:choose>
					<xsl:value-of select="right"/>
					<xsl:if test="on"> ON <xsl:value-of select="on"/>
					</xsl:if>
					<xsl:apply-templates select="join" mode="join"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="concat($left,' ')"/>
	</xsl:template>
</xsl:stylesheet>
