<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:md="http://www.stambia.com/md" xmlns:indy="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:mdc="java:com.semarchy.xdi.designer.generation.xsl.global.XpathCache" xmlns:UUID="java.util.UUID" xmlns:tech="http://www.stambia.com/tech" exclude-result-prefixes="indy mdj UUID tech mdc">
	<xsl:param name="startType" select="'com.stambia.rdbms.product'"/>
	<xsl:variable name="startType2" select="if ($startType!='') then $startType else /*/@defType[1]"/>
	<xsl:variable name="parentRef" select="if (/*/@tech!='') then /*/@tech else /*/@md:ref"/>
	<xsl:variable name="techId">
		<xsl:variable name="tmp">
			<xsl:choose>
				<xsl:when test="/*/@tech!=''">
					<xsl:value-of select="/*/@tech"/>
				</xsl:when>
				<xsl:when test="/*/@md:ref!=''">
					<xsl:choose>
						<xsl:when test="contains(/*/@md:ref,'.tech#')">
							<xsl:value-of select="/*/@md:ref"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="mdj:getRef(/*/@md:ref)/@md:ref"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="md:getFileId($tmp)"/>
	</xsl:variable>
	<xsl:variable name="firstTech" select="document(md:findURI($techId))"/>
	<xsl:variable name="tech">
		<xsl:variable name="allLevel">
			<xsl:apply-templates select="$firstTech/*" mode="copyLevels"/>
		</xsl:variable>
		<tech:tech>
			<xsl:for-each-group select="$allLevel/*" group-by="@code">
				<level code="{@code}">
					<xsl:for-each select="$allLevel/*[@code=current()/@code]/@*">
						<xsl:if test=".!=''">
							<xsl:copy/>
						</xsl:if>
					</xsl:for-each>
					<xsl:variable name="allAttribute">
						<xsl:for-each select="$allLevel/*[@code=current()/@code]/attribute/@code">
							<xsl:sort select="position()" order="descending"/>
							<xsl:variable name="attribute" select=".."/>
							<xsl:element name="{../name()}">
								<xsl:copy-of select="../@*"/>
								<xsl:copy-of select="."/>
							</xsl:element>
						</xsl:for-each>
					</xsl:variable>
					<xsl:for-each-group select="$allAttribute/*" group-by="@code">
						<xsl:copy-of select="."/>
					</xsl:for-each-group>
					<xsl:variable name="allXpathExpression">
						<xsl:for-each select="$allLevel/*[@code=current()/@code]/xPathExpression/code">
							<xsl:sort select="position()" order="descending"/>
							<xsl:variable name="xpath" select=".."/>
							<xsl:element name="{../name()}">
								<xsl:copy-of select="../@*"/>
								<xsl:copy-of select="../*[not(name()='code')]"/>
								<xsl:copy-of select="."/>
							</xsl:element>
						</xsl:for-each>
					</xsl:variable>
					<xsl:for-each-group select="$allXpathExpression/*" group-by="code">
						<xsl:copy-of select="."/>
					</xsl:for-each-group>
				</level>
			</xsl:for-each-group>
		</tech:tech>
	</xsl:variable>
	<xsl:template match="*" mode="copyLevels">
		<xsl:copy-of select="level"/>
		<xsl:if test="@md:ref!='' or @ref!=''">
			<xsl:apply-templates select="if (@md:ref!='') then document(md:findURI(md:getFileId(@md:ref))) else document(md:findURI(md:getFileId(@ref))) " mode="copyLevels"/>
		</xsl:if>
	</xsl:template>
	<xsl:variable name="techPath" select="mdj:relativizeURI(base-uri(/),base-uri($tech))"/>
	<xsl:output method="xml" encoding="UTF-8"/>
	<xsl:template match="/">
		<xsl:call-template name="xmlToMd">
			<xsl:with-param name="root" select="/"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="xmlToMd">
		<xsl:param name="root"/>
		<xsl:apply-templates select="$root//*[@defType=$startType2]" mode="toMd"/>
	</xsl:template>
	<xsl:template match="metaDataLink | template" mode="toMd">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="*" mode="toMd">
		<xsl:variable name="conf" select="if (name()=concat(../name(),'Conf')) then 'true' else 'false'"/>
		<xsl:variable name="root" select="if (@defType=$startType2) then 'true' else 'false'"/>
		<xsl:variable name="level" select="if ($conf='true') then $tech//level[@code=current()/../@defType] else  $tech//level[@code=current()/@defType] "/>
		<xsl:if test="$level">
			<xsl:element name="{if ($conf='true')  then 'configuration' else (if ($root='true') then 'md:node' else 'node')}">
				<xsl:if test="$root='true'">
					<xsl:attribute name="md:ref" select="$parentRef"><!--concat($techPath,'#', $level/../../tech:tech/@id, '?fileId=',$techId,'?')--></xsl:attribute>
				</xsl:if>
				<xsl:variable name="this" select="."/>
				<xsl:copy-of select="@defType | @id | @name  | @position"/>
				<xsl:for-each select="$level/attribute">
					<xsl:variable name="value" select="$this/@*[name()=current()/@xmlName]"/>
					<xsl:variable name="tagValues" select="$this/*[name()=current()/@xmlName]"/>
					<xsl:choose>
						<xsl:when test="$value!=''">
							<xsl:choose>
								<xsl:when test="@type='reference'">
									<attribute defType="{concat($level/@code,'.',@code)}" ref="{$value}"/>
								</xsl:when>
								<xsl:otherwise>
									<attribute defType="{concat($level/@code,'.',@code)}" value="{$value}"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="$tagValues">
							<attribute defType="{concat($level/@code,'.',@code)}">
								<xsl:for-each select="$tagValues">
									<xsl:choose>
										<xsl:when test="@type='reference'">
											<refs>
												<xsl:value-of select="text()"/>
											</refs>
										</xsl:when>
										<xsl:otherwise>
											<values>
												<xsl:value-of select="text()"/>
											</values>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</attribute>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:apply-templates mode="toMd" select="*"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@*" mode="toMd">
		<xsl:copy/>
	</xsl:template>
	<!--#### FUNCTION ###"-->
	<xsl:function name="md:findURI">
		<xsl:param name="id"/>
		<xsl:value-of select="mdj:findURIByFileId($id)"/>
	</xsl:function>
	<xsl:function name="md:getFileId">
		<xsl:param name="var"/>
		<xsl:variable select="substring-after($var,'fileId=')" name="tmp"/>
		<xsl:value-of select="if (contains($tmp,'$')) then substring-before($tmp,'$') else substring-before($tmp,'?') "/>
	</xsl:function>
</xsl:stylesheet>
