<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:md="http://www.stambia.com/md" xmlns:tech="http://www.stambia.com/tech" xmlns:set="http://exslt.org/sets" xmlns:saxon="http://saxon.sf.net/" xmlns:jdbcToXml="java:com.indy.engine.actionCodes.Utils" xmlns:rdbms="http://www.stambia.com/rdbms" xmlns:sqlToXml="http://www.stambia.com/sqlToXml" xmlns:UUID="java.util.UUID" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" extension-element-prefixes="saxon">
	<xsl:include href="global/rdbms.joins.xsl"/>
	<xsl:output method="xml" cdata-section-elements="query sqlToXml:mapping"/>
	<xsl:param name="elementsToKeep"/>
	<xsl:param name="branchsToDisable"/>
	<xsl:variable name="debug" select="false()"/>
	<xsl:variable name="endSourceSets" saxon:assignable="yes">
		<sourceSet/>
	</xsl:variable>
	<xsl:template match="/">
		<data xmlns:md="http://www.stambia.com/md">
			<xsl:copy-of select="/sqlToXml:descriptor/data/@*"/>
			<xsl:variable name="merge">
				<xsl:apply-templates select="/sqlToXml:descriptor/data/* " mode="merge"/>
			</xsl:variable>
			<xsl:variable name="purge">
				<xsl:apply-templates select="$merge" mode="purge"/>
			</xsl:variable>
			<xsl:variable name="createSourceSet">
				<xsl:apply-templates select="$purge" mode="analyse"/>
			</xsl:variable>
			<xsl:variable name="rattachSourceSet">
				<xsl:apply-templates select="$createSourceSet" mode="rattachSourceSet"/>
			</xsl:variable>
			<xsl:variable name="resolveQuery">
				<xsl:apply-templates select="$rattachSourceSet" mode="resolveQuery"/>
			</xsl:variable>
			<xsl:if test="$debug">
				<original>
					<xsl:copy-of select="/"/>
				</original>
				<merge>
					<xsl:copy-of select="$merge"/>
				</merge>
				<purge>
					<xsl:copy-of select="$purge"/>
				</purge>
				<analyse>
					<xsl:copy-of select="$createSourceSet"/>
				</analyse>
				<rattach>
					<xsl:copy-of select="$rattachSourceSet"/>
				</rattach>
				<resolvQuery>
					<xsl:copy-of select="$resolveQuery"/>
				</resolvQuery>
			</xsl:if>
			<xsl:copy-of select="$resolveQuery"/>
		</data>
	</xsl:template>
	<xsl:template match="attribute" mode="merge">
		<xsl:param name="expNumber" tunnel="yes"/>
		<xsl:variable name="mapInfo" select="(//sourceSet/field[@id=current()/@id])[1]">
			<!--important de laisser (...)[1] car il peut en avoir plusieurs dans le cas d'un field constant (hors sourceSet)-->
		</xsl:variable>
		<xsl:if test="$mapInfo">
			<xsl:variable select="jdbcToXml:splitCommaExpression($mapInfo/text()[1])" name="expressions"/>
			<xsl:variable select="if (count($expressions)=1 or $expNumber=0) then $expressions[1] else if ($expNumber>count($expressions)) then 'null' else $expressions[$expNumber]" name="text"/>
			<xsl:if test="count($expressions)>1"/>
			<attribute sqlToXml:aliasWord="{$mapInfo/@aliasWord}" sqlToXml:alias="{$mapInfo/@alias}" sqlToXml:isAggregate="{$mapInfo/@isAggregate}" sqlToXml:mapping="{$text}" sqlToXml:id="{UUID:randomUUID()}" sqlToXml:location="{$mapInfo/@location}" sqlToXml:sortOrder="{$mapInfo/@sortOrder}">
				<xsl:copy-of select="@*"/>
				<xsl:copy-of select="$mapInfo/tag"/>
				<xsl:copy-of select="$mapInfo/from"/>
			</attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="namespace" mode="merge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="md:static" mode="merge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="md:static" mode="purge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="md:static" mode="analyse">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="md:static" mode="resolveQuery">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="element | port | operation | input | output | part | simpleType | service | wsdl | fault | headerPart" mode="merge">
		<xsl:param name="expNumber" tunnel="yes" select="0"/>
		<xsl:param name="countExpressions" tunnel="yes" select="0"/>
		<xsl:variable name="mapInfo" select="(//sourceSet/field[@id=current()/@id])[1]">
			<!--important de laisser (...)[1] car il peut en avoir plusieurs dans le cas d'un field constant (hors sourceSet)-->
		</xsl:variable>
		<xsl:variable name="overrideName">
			<xsl:choose>
				<xsl:when test="name()='input' or name()='output'">
					<value name="{name()}"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$mapInfo">
				<xsl:variable name="current" select="."/>
				<xsl:variable name="expressions" select="jdbcToXml:splitCommaExpression($mapInfo/text()[1])"/>
				<xsl:variable name="count" select="count($expressions)"/>
				<xsl:variable name="newCountExpressions" select="if ($count>number($countExpressions)) then $count else $countExpressions"/>
				<xsl:for-each select="$expressions">
					<!--if ($count=1) then $expressions
else
if ($newCountExpressions!=$countExpressions and $expNumber>0) then $expressions[position()=$expNumber or position()>$countExpressions] 
else
 if ($newCountExpressions>1) then if ($expNumber=0) then $expressions 
else 
$expressions[$expNumber] 
else 
$expressions[1]-->
					<!--Si il y a plus que précédement d'expressions alors on prend l'expression avec le numéro courant et les expressions nouvelles-->
					<xsl:if test="not(last()>1 and string(position())=tokenize($branchsToDisable,',')) and (last()=1 or $expNumber=0 or (position()=$expNumber) or ( position()>$countExpressions))">
						<xsl:variable name="expNumber" select="if (last()=1) then $expNumber
else
position()">
							<!--si expNumber n'as pas encore été seté-->
						</xsl:variable>
						<element sqlToXml:aliasWord="{$mapInfo/@aliasWord}" sqlToXml:alias="{$mapInfo/@alias}" sqlToXml:mapping="{.}" sqlToXml:id="_{UUID:randomUUID()}" sqlToXml:isAggregate="{$mapInfo/@isAggregate}" sqlToXml:isKey="{$mapInfo/@isKey}" sqlToXml:_querySetName="{$mapInfo/../@name}" sqlToXml:_integrationSelectHint="{$mapInfo/../@integrationSelectHint}" sqlToXml:_distinct="{$mapInfo/../@distinct}" sqlToXml:location="{$mapInfo/@location}" sqlToXml:forceIsNillable="{$mapInfo/@forceIsNillable}" sqlToXml:sortOrder="{$mapInfo/@sortOrder}">
							<xsl:if test="$current/name()='part'">
								<xsl:attribute name="typeOrElement"><xsl:choose><xsl:when test="exists($current/element)">element</xsl:when><xsl:otherwise>type</xsl:otherwise></xsl:choose></xsl:attribute>
							</xsl:if>
							<xsl:copy-of select="$current/@*"/>
							<xsl:copy-of select="$overrideName/value/@*"/>
							<xsl:if test="$mapInfo/@isKey='true'">
								<xsl:copy-of select="$mapInfo/../query"/>
							</xsl:if>
							<xsl:copy-of select="$mapInfo/tag"/>
							<xsl:copy-of select="$mapInfo/from"/>
							<xsl:apply-templates mode="merge" select="$current/*">
								<!-- see bug 2197 -->
								<xsl:sort select="if (name()='input') then 1 else if (name()='output') then 2 else if (name()='fault') then 3 else @position" data-type="number"/>
								<xsl:with-param name="expNumber" select="$expNumber" tunnel="yes"/>
								<xsl:with-param name="countExpressions" select="$newCountExpressions" tunnel="yes"/>
							</xsl:apply-templates>
						</element>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<element>
					<xsl:if test="name()='part'">
						<xsl:attribute name="typeOrElement"><xsl:choose><xsl:when test="(exists(sequence) or exists(all) or exists(choice))">type</xsl:when><xsl:when test="element">element</xsl:when></xsl:choose></xsl:attribute>
					</xsl:if>
					<xsl:copy-of select="@*"/>
					<xsl:copy-of select="$overrideName/value/@*"/>
					<xsl:apply-templates mode="merge" select="*">
						<!-- see bug 2197 -->
						<xsl:sort select="if (name()='input') then 1 else if (name()='output') then 2 else if (name()='fault') then 3 else @position" data-type="number"/>
					</xsl:apply-templates>
				</element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="merge">
		<xsl:param name="countExpressions" tunnel="yes"/>
		<xsl:param name="expNumber" tunnel="yes"/>
		<xsl:apply-templates mode="merge" select="*">
			<xsl:with-param name="countExpressions" tunnel="yes" select="$countExpressions"/>
			<xsl:with-param name="expNumber" tunnel="yes" select="$expNumber"/>
			<xsl:sort select="@position" data-type="number"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="@id | @position | @defType" mode="purge">
		<xsl:attribute name="md:{name()}" select="."/>
	</xsl:template>
	<xsl:template match="attribute[@sqlToXml:id]" mode="purge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="@*" mode="purge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="namespace" mode="purge">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="element[exists(descendant-or-self::*/@sqlToXml:id)]" mode="purge">
		<element>
			<xsl:apply-templates select="@*" mode="purge"/>
			<xsl:copy-of select="query"/>
			<xsl:copy-of select="tag"/>
			<xsl:copy-of select="from"/>
			<xsl:apply-templates mode="purge" select="*"/>
		</element>
	</xsl:template>
	<xsl:template match="*" mode="purge"/>
	<xsl:template match="attribute" mode="purge">
		<xsl:if test="@defType=tokenize($elementsToKeep,',')">
			<emptyAttribute>
				<xsl:copy-of select="@*|*"/>
			</emptyAttribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="element" mode="purge">
		<xsl:if test="@defType=tokenize($elementsToKeep,',')">
			<emptyElement>
				<xsl:copy-of select="@*|*"/>
			</emptyElement>
		</xsl:if>
	</xsl:template>
	<xsl:template match="emptyElement" mode="analyse">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="namespace" mode="analyse">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="element[@sqlToXml:isKey='true']" mode="analyse">
		<xsl:param name="currentResultSetId" tunnel="yes"/>
		<xsl:variable name="currentResultSetId" select="if ($currentResultSetId!='' and not($endSourceSets=$currentResultSetId)) then $currentResultSetId else @sqlToXml:id"/>
		<element sqlToXml:sourceSet="{$currentResultSetId}">
			<xsl:copy-of select="@*[not(name()='sqlToXml:_querySetName' or name()='sqlToXml:_distinct'  or name()='sqlToXml:_integrationSelectHint')]"/>
			<xsl:if test="$currentResultSetId=@sqlToXml:id">
				<!--si le source vient d'être initialisée-->
				<xsl:attribute name="sqlToXml:querySet" select="@sqlToXml:_querySetName"/>
				<xsl:attribute name="sqlToXml:distinct" select="@sqlToXml:_distinct"/>
				<xsl:attribute name="sqlToXml:integrationSelectHint" select="@sqlToXml:_integrationSelectHint"/>
				<xsl:copy-of select="query"/>
			</xsl:if>
			<xsl:copy-of select="tag"/>
			<xsl:copy-of select="from"/>
			<xsl:apply-templates mode="analyse" select="*">
				<xsl:with-param name="currentResultSetId" select="$currentResultSetId" tunnel="yes"/>
			</xsl:apply-templates>
			<xsl:if test="exists(following::element[@sqlToXml:id][@sqlToXml:isKey='true'][1][ancestor::element/@sqlToXml:id=$currentResultSetId])">
				<!--HREROLLE 28/07/2010 pourquoi not(.//element[@sqlToXml:id]) ?
not(.//element[@sqlToXml:id]) and exists(following::element[@sqlToXml:id][@sqlToXml:isKey='true'][1][ancestor::element/@sqlToXml:id=$currentResultSetId])-->
				<!--Si plus de fils qui utilise ce sourceSet et un following en clef qui en a besoin-->
				<saxon:assign name="endSourceSets">
					<xsl:copy-of select="$endSourceSets"/>
					<sourceSet>
						<xsl:value-of select="$currentResultSetId"/>
					</sourceSet>
				</saxon:assign>
			</xsl:if>
		</element>
		<xsl:choose>
			<xsl:when test="@sqlToXml:id"/>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="analyse"/>
	<xsl:template match="element" mode="analyse">
		<xsl:param name="currentResultSetId" tunnel="yes"/>
		<element>
			<xsl:copy-of select="@*[not(name()='sqlToXml:_querySetName' or name()='sqlToXml:_distinct' or name()='sqlToXml:_integrationSelectHint')]"/>
			<xsl:copy-of select="tag"/>
			<xsl:copy-of select="from"/>
			<xsl:apply-templates mode="analyse" select="*"/>
		</element>
	</xsl:template>
	<xsl:template match="attribute" mode="analyse">
		<xsl:param name="currentResultSetId" tunnel="yes"/>
		<xsl:if test="@sqlToXml:id">
			<attribute sqlToXml:sourceSet="{$currentResultSetId}">
				<xsl:copy-of select="@*"/>
				<xsl:copy-of select="tag"/>
				<xsl:copy-of select="from"/>
			</attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="rattachSourceSet">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:copy-of select="*|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="element | attribute" mode="rattachSourceSet">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:choose>
				<xsl:when test="@sqlToXml:sourceSet!=''">
					<!--On fait rien-->
				</xsl:when>
				<xsl:when test="@sqlToXml:id!=''">
					<xsl:attribute name="sqlToXml:sourceSet"><xsl:value-of select="ancestor::*[@sqlToXml:sourceSet][1]/@sqlToXml:sourceSet"/></xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="*" mode="rattachSourceSet"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="query" mode="resolveQuery">
		<xsl:variable name="current" select=".."/>
		<xsl:variable name="sourceSetsOfQuerySet" select="$current/ancestor-or-self::*[@sqlToXml:querySet=$current/@sqlToXml:querySet]/@sqlToXml:sourceSet"/>
		<xsl:variable name="ancestor" select="$current/ancestor-or-self::*[@sqlToXml:sourceSet=$sourceSetsOfQuerySet]"/>
		<xsl:variable name="descendant" select="$current//*[@sqlToXml:sourceSet=$current/@sqlToXml:sourceSet]"/>
		<xsl:variable name="select" select="$ancestor | $descendant | $ancestor/*[@name='internalProperty:sortKey']"/>
		<xsl:variable name="orderBy" select="$ancestor | $descendant[@sqlToXml:isKey='true']"/>
		<query>select <xsl:if test="../@sqlToXml:integrationSelectHint!=''">
				<xsl:value-of select="../@sqlToXml:integrationSelectHint"/>
			</xsl:if>
			<xsl:if test="../@sqlToXml:distinct='true'">distinct </xsl:if>
			<xsl:for-each select="$select">
				<!--Recherche des clefs parentes-->
				<xsl:value-of select="concat(@sqlToXml:mapping,' ',@sqlToXml:aliasWord,' ',@sqlToXml:alias)"/>
				<xsl:if test="not(position()=last())">,
</xsl:if>
			</xsl:for-each>
from 
<xsl:variable name="joins">
				<xsl:call-template name="reduceJoins">
					<xsl:with-param name="joins" select="explicitJoins"/>
					<xsl:with-param name="fields" select="$select"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="$joins"/>
			<xsl:value-of select="from"/>
			<xsl:if test="where!=''">
where 1=1 
<xsl:value-of select="where"/>
			</xsl:if>
			<xsl:if test="$select[@sqlToXml:isAggregate='true'] and count($select)>count($select[@sqlToXml:isAggregate='true']) ">
group by 
<xsl:for-each select="$select[not(@sqlToXml:isAggregate='true')]/@sqlToXml:mapping">
					<xsl:value-of select="."/>
					<xsl:if test="not(position()=last())">,
</xsl:if>
				</xsl:for-each>
			</xsl:if>
			<xsl:if test="$orderBy">
order by 
		<xsl:for-each select="$orderBy">
					<xsl:for-each select="*[@name='internalProperty:sortKey']">
						<xsl:value-of select="./@sqlToXml:alias"/>
						<xsl:if test="./@sqlToXml:sortOrder!=''"><xsl:value-of select="concat(' ',./@sqlToXml:sortOrder)"/></xsl:if>, 
					</xsl:for-each> 	
					<xsl:value-of select="@sqlToXml:alias"/>
					<xsl:if test="@sqlToXml:sortOrder!=''">&#160;<xsl:value-of select="@sqlToXml:sortOrder"/></xsl:if>
					<xsl:if test="not(position()=last())">,
</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</query>
	</xsl:template>
	<xsl:template name="reduceJoins">
		<xsl:param name="fields"/>
		<xsl:param name="joins"/>
		<xsl:variable name="mandatory" select="$joins//join[(left=$fields/from  and right=$fields/from and type!='INNER') or type='INNER']"/>
		<xsl:call-template name="rdbms:join">
			<xsl:with-param name="bracket" select="$joins/@bracket" tunnel="yes"/>
			<xsl:with-param name="joins">
				<xsl:copy-of select="$mandatory">
					<!--Laisser le copie au lieu du select directement dans le paramètre, car ca crée unniveau supplémentaire nécessaire-->
				</xsl:copy-of>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="1=2">
			<xsl:variable name="allMFroms" select="distinct-values($mandatory/(left | right))"/>
			<xsl:variable name="allFroms" select="distinct-values($fields/from)"/>
			<xsl:variable name="missingFroms" select="$fields/from[not($mandatory/(left | right)=.)]"/>
			<xsl:variable name="rest" select="set:difference($joins//join,$mandatory)"/>
			<xsl:variable name="mandatory" select="$mandatory | $rest[(left=missingFroms and type='RIGHT') or (right=missingFroms and type='LEFT')]"/>
			<xsl:message select="$missingFroms"/>
			<xsl:message select="concat('init: ',count($joins//join),' reduce: ', count($mandatory))"/>
			<xsl:if test="count($allFroms)>count($allMFroms)">
				<xsl:message select="concat('initFrom: ',count($allFroms),' reduce: ', count($allMFroms))"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="emptyElement" mode="resolveQuery">
		<element>
			<xsl:copy-of select="@*|*"/>
		</element>
	</xsl:template>
	<xsl:template match="namespace" mode="resolveQuery">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="emptyAttribute" mode="resolveQuery">
		<attribute>
			<xsl:copy-of select="@*|*"/>
		</attribute>
	</xsl:template>
	<xsl:template match="*" mode="resolveQuery">
		<xsl:if test="descendant-or-self::*[@sqlToXml:id]">
			<xsl:element name="{name()}">
				<xsl:if test="name()='element' and @sqlToXml:sourceSet!=''  and not((following::element[@sqlToXml:isKey='true'] | .//element)[@sqlToXml:sourceSet=current()/@sqlToXml:sourceSet])">
					<xsl:attribute name="sqlToXml:isLast">true</xsl:attribute>
					<!--De toute façon seul le premier last est important, car l'actioncode prend en compte à partir du premier. Les balises sans type avec des fils ne sont pas calculées ici, mais bien prise en compte dans l'actioncode-->
				</xsl:if>
				<xsl:apply-templates mode="resolveQuery" select="@*|*"/>
				<xsl:copy-of select="tag"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="@*" mode="resolveQuery">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="element" mode="analyseBak">
		<xsl:param name="currentResultSetId" tunnel="yes"/>
		<xsl:variable name="mapInfo" select="//sourceSet/field[@id=current()/@id]"/>
		<xsl:choose>
			<xsl:when test="1=2 and $mapInfo/@isKey='true' and $currentResultSetId!='' and not($endSourceSets=$currentResultSetId)">
				<!--Si le resultSetCourant est déjà ouvert et n'est pas terminé-->
				<element sqlToXml:aliasWord="{$mapInfo/@aliasWord}" sqlToXml:alias="{$mapInfo/@alias}" sqlToXml:id="{@id}" sqlToXml:isAggregate="{$mapInfo/@isAggregate}" sqlToXml:isKey="true" sqlToXml:sourceSet="{$currentResultSetId}" sqlToXml:forceIsNillable="{$mapInfo/@forceIsNillable}">
					<xsl:copy-of select="@*"/>
					<sqlToXml:mapping>
						<xsl:value-of select="$mapInfo"/>
					</sqlToXml:mapping>
					<xsl:apply-templates mode="analyse" select="*"/>
					<xsl:if test="not(.//element[@id=//sourceSet/field/@id])">
						<!--Si n'existe plus de fils pour lesquels ce sourceSet courant est sources-->
						<saxon:assign name="endSourceSets">
							<xsl:copy-of select="$endSourceSets"/>
							<sourceSet>
								<xsl:value-of select="$currentResultSetId"/>
							</sourceSet>
						</saxon:assign>
					</xsl:if>
				</element>
			</xsl:when>
			<xsl:when test="1=2 and $mapInfo/@isKey='true'">
				<!--Si le resultSetCourant n'existe pas ou est fermé alors on en cré un nouveau-->
				<element sqlToXml:aliasWord="{$mapInfo/@aliasWord}" sqlToXml:alias="{$mapInfo/@alias}" sqlToXml:id="{$mapInfo/@id}" sqlToXml:isKey="true" sqlToXml:isAggregate="{$mapInfo/@isAggregate}" sqlToXml:sourceSet="{$mapInfo/@id}" sqlToXml:querySet="{$mapInfo/../@name}" sqlToXml:distinct="{$mapInfo/../@distinct}" sqlToXml:forceIsNillable="{$mapInfo/@forceIsNillable}">
					<xsl:copy-of select="@*"/>
					<sqlToXml:mapping>
						<xsl:value-of select="$mapInfo"/>
					</sqlToXml:mapping>
					<xsl:copy-of select="$mapInfo/../query"/>
					<xsl:apply-templates select="*" mode="analyse">
						<xsl:with-param name="currentResultSetId" select="@id" tunnel="yes"/>
					</xsl:apply-templates>
				</element>
			</xsl:when>
			<xsl:when test="$mapInfo">
				<element sqlToXml:aliasWord="{$mapInfo/@aliasWord}" sqlToXml:alias="{$mapInfo/@alias}" sqlToXml:id="{$mapInfo/@id}" sqlToXml:isAggregate="{$mapInfo/@isAggregate}" sqlToXml:sourceSet="{$currentResultSetId}" sqlToXml:forceIsNillable="{$mapInfo/@forceIsNillable}">
					<xsl:copy-of select="@*"/>
					<sqlToXml:mapping>
						<xsl:value-of select="$mapInfo"/>
					</sqlToXml:mapping>
					<xsl:apply-templates mode="analyse" select="*"/>
				</element>
			</xsl:when>
			<xsl:otherwise>
				<element>
					<xsl:copy-of select="@*"/>
					<xsl:apply-templates mode="analyse" select="*"/>
				</element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
