#!/bin/bash

# use -usage parameter to know the syntax of this command

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

XDI_RUNTIME_CLASSPATH="$XDI_RUNTIME_CLASSPATH":"$XDI_RUNTIME_HOME"/lib/core/js-1.7R2.jar

"$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_RUNTIME_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" org.mozilla.javascript.tools.shell.Main "$@"