/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest;

import com.indy.addons.httprest.NtlmAuthentication;
import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.semarchy.xdi.base.core.auth.BasicOrDigestAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Authentication;
import com.semarchy.xdi.base.core.auth.OAuthAuthentication;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeReader;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Md2AuthenticationFactory {
    public static AuthenticationInfo getAuthenticationInfo(MdNode node, URL httpURL, String httpMethod, MdNode proxyNode) throws Exception {
        if (node == null) {
            return null;
        }
        String defType = node.getDefType();
        if ("com.stambia.wsdl.oauth".equals(defType) || "com.stambia.security.oauth".equals(defType)) {
            String consumerKey = MdAttributeReader.readAttribute((String)"consumerKey", (MdNode)node);
            String consumerSecret = MdAttributeReader.readAttribute((String)"consumerSecret", (MdNode)node);
            String signatureMethod = MdAttributeReader.readAttribute((String)"signatureMethod", (MdNode)node);
            String token = MdAttributeReader.readAttribute((String)"token", (MdNode)node);
            String tokenSecret = MdAttributeReader.readAttribute((String)"tokenSecret", (MdNode)node);
            return new OAuthAuthentication(httpURL, httpMethod, consumerKey, consumerSecret, signatureMethod, token, tokenSecret);
        }
        if ("com.stambia.wsdl.oauth2".equals(defType) || "com.stambia.security.oauth2".equals(defType)) {
            String clientId = MdAttributeReader.readAttribute((String)"clientId", (MdNode)node);
            String clientSecret = MdAttributeReader.readAttribute((String)"clientSecret", (MdNode)node);
            String accessToken = MdAttributeReader.readAttribute((String)"accessToken", (MdNode)node);
            String refreshToken = MdAttributeReader.readAttribute((String)"refreshToken", (MdNode)node);
            String tokenEndpoint = MdAttributeReader.readAttribute((String)"tokenEndpoint", (MdNode)node);
            Integer validityDuration = null;
            try {
                validityDuration = Integer.valueOf(MdAttributeReader.readAttribute((String)"expiresIn", (MdNode)node));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Integer attemptNumber = null;
            try {
                attemptNumber = Integer.valueOf(MdAttributeReader.readAttribute((String)"numberOfAttempts", (MdNode)node));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Integer refreshTimeout = null;
            try {
                refreshTimeout = Integer.valueOf(MdAttributeReader.readAttribute((String)"connectionTimeout", (MdNode)node));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String flowType = MdAttributeReader.readAttribute((String)"flowType", (MdNode)node);
            String authenticationEndpoint = MdAttributeReader.readAttribute((String)"authorizationEndpoint", (MdNode)node);
            String login = MdAttributeReader.readAttribute((String)"username", (MdNode)node);
            String password = MdAttributeReader.readAttribute((String)"password", (MdNode)node);
            String redirectionEndpoint = MdAttributeReader.readAttribute((String)"redirectionEndpoint", (MdNode)node);
            Object scope = null;
            List l = MdAttributeReader.readAttributeList((String)"scope", (MdNode)node);
            if (l != null) {
                for (String s : l) {
                    scope = scope == null ? s : (String)scope + " " + s;
                }
            }
            boolean sendClientId = MdAttributeReader.readAttribute((String)"useClientId4TokenGeneration", (MdNode)node, (Boolean)false);
            boolean sendClientSecret = MdAttributeReader.readAttribute((String)"useClientSecret4TokenGeneration", (MdNode)node, (Boolean)false);
            String clientCredentialPolicy = MdAttributeReader.readAttribute((String)"sendClientCredentialsPolicy", (MdNode)node, null);
            OAuth2.CredentialMode credentialPolicy = OAuth2.CredentialMode.NONE;
            if (clientCredentialPolicy == null) {
                if (sendClientId) {
                    credentialPolicy = sendClientSecret ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET : OAuth2.CredentialMode.PARAMETER_CLIENT_ID;
                }
            } else {
                credentialPolicy = OAuth2.CredentialMode.fromLabel((String)clientCredentialPolicy);
            }
            String tokenEndpointHttpMethod = MdAttributeReader.readAttribute((String)"tokenEndpointHttpMethod", (MdNode)node);
            Map additionalParameters = MdAttributeReader.readAttributeMap((String)"authorizationParameter", (MdNode)node);
            Map additionalHeaders = MdAttributeReader.readAttributeMap((String)"additionalHttpHeaders", (MdNode)node);
            Boolean enableCertificatefVerif = true;
            String enableCertificateVerification = MdAttributeReader.readAttribute((String)"enableCertificateVerification", (MdNode)node);
            if (enableCertificateVerification != null && !enableCertificateVerification.isEmpty()) {
                enableCertificatefVerif = Boolean.valueOf(enableCertificateVerification);
            }
            Boolean enableHostnameVerif = true;
            String enableHostnameVerification = MdAttributeReader.readAttribute((String)"enableHostnameVerification", (MdNode)node);
            if (enableHostnameVerification != null && !enableHostnameVerification.isEmpty()) {
                enableHostnameVerif = Boolean.valueOf(enableHostnameVerification);
            }
            String proxyHost = null;
            Integer proxyPort = null;
            String proxyUsername = null;
            String proxyPassword = null;
            if (proxyNode != null) {
                proxyHost = MdAttributeReader.readAttribute((String)"host", (MdNode)proxyNode);
                proxyPort = Integer.valueOf(MdAttributeReader.readAttribute((String)"port", (MdNode)proxyNode));
                proxyUsername = MdAttributeReader.readAttribute((String)"username", (MdNode)proxyNode);
                proxyPassword = MdAttributeReader.readAttribute((String)"password", (MdNode)proxyNode);
            }
            return new OAuth2Authentication(accessToken, refreshToken, tokenEndpoint, clientId, clientSecret, validityDuration, attemptNumber, refreshTimeout, flowType, authenticationEndpoint, login, password, redirectionEndpoint, (String)scope, credentialPolicy, tokenEndpointHttpMethod, additionalParameters, enableHostnameVerif, enableCertificatefVerif, additionalHeaders, proxyHost, proxyPort, proxyUsername, proxyPassword);
        }
        if ("com.stambia.wsdl.basicauth".equals(defType) || "com.stambia.security.basic".equals(defType)) {
            String login = MdAttributeReader.readAttribute((String)"userName", (MdNode)node);
            String pwd = MdAttributeReader.readAttribute((String)"password", (MdNode)node);
            return new BasicOrDigestAuthentication(login, pwd, httpMethod, httpURL);
        }
        if ("com.stambia.wsdl.ntlm".equals(defType)) {
            String username = MdAttributeReader.readAttribute((String)"userName", (MdNode)node);
            String password = MdAttributeReader.readAttribute((String)"password", (MdNode)node);
            String domain = MdAttributeReader.readAttribute((String)"domain", (MdNode)node);
            return new NtlmAuthentication(username, password, domain);
        }
        return null;
    }
}

