/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.internal;

import com.indy.addons.httprest.internal.JsonSchemaVisitor;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.ui.custom.out.services.IJsonSchemaConverter;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IJsonSchemaConverter.class}, scope=ServiceScope.PROTOTYPE)
public class JsonSchemaReverserComponent
implements IJsonSchemaConverter<MdNode> {
    public MdNode convertJsonSchema(InputStream jsonSchema, int recursivityLevel, String encoding) throws Exception {
        ParseOptions parseOptions = new ParseOptions();
        OpenAPIV3Parser openAPIParser = new OpenAPIV3Parser();
        String def = new String(this.createOpenAPIWrapper(jsonSchema, encoding));
        def = def.replace("\"#/$defs/", "\"#/components/schemas/");
        def = def.replace("\"#/definitions/", "\"#/components/schemas/");
        SwaggerParseResult res = openAPIParser.readContents(def, Collections.EMPTY_LIST, parseOptions);
        OpenAPI api = res.getOpenAPI();
        HashMap schs = new HashMap();
        api.getComponents().getSchemas().entrySet().stream().forEach(e -> {
            Schema schema = schs.put((String)e.getKey(), (Schema)e.getValue());
        });
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        JsonSchemaVisitor v = new JsonSchemaVisitor(node, recursivityLevel, schs);
        v.visit((Schema)schs.get("root"));
        return (MdNode)node.getNode().remove(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] createOpenAPIWrapper(InputStream is, String inputStreamEncoding) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bout = new BufferedOutputStream(out);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            JsonEventWriter jsonWriter = new JsonEventWriter((OutputStream)bout, "UTF-8");
            try {
                try (JsonEventReader jsonReader = new JsonEventReader((Reader)new BufferedReader(new InputStreamReader(is, inputStreamEncoding)));){
                    jsonWriter.setSkipStringEscaping(true);
                    jsonWriter.add(JSonEvent.createStartDocument());
                    jsonWriter.add(JSonEvent.createStartObject());
                    jsonWriter.add(JSonEvent.createMember((String)"openapi"));
                    jsonWriter.add(JSonEvent.createString((String)"3.0.0"));
                    jsonWriter.add(JSonEvent.createMember((String)"info"));
                    jsonWriter.add(JSonEvent.createStartObject());
                    jsonWriter.add(JSonEvent.createEndObject());
                    jsonWriter.add(JSonEvent.createMember((String)"components"));
                    jsonWriter.add(JSonEvent.createStartObject());
                    jsonWriter.add(JSonEvent.createMember((String)"schemas"));
                    jsonWriter.add(JSonEvent.createStartObject());
                    jsonWriter.add(JSonEvent.createMember((String)"root"));
                    Stack<JSonEvent> stack = new Stack<JSonEvent>();
                    ArrayList<JSonEvent> refsContent = new ArrayList<JSonEvent>();
                    while (jsonReader.hasNext()) {
                        JSonEvent ev2 = null;
                        ev2 = jsonReader.readNext();
                        if (ev2.getType() == JSonEvent.Type.START_DOCUMENT || ev2.getType() == JSonEvent.Type.END_DOCUMENT) continue;
                        if (stack.isEmpty()) {
                            if (ev2.getType() == JSonEvent.Type.MEMBER && (ev2.getName().equals("$defs") || ev2.getName().equals("definitions"))) {
                                stack.push(jsonReader.readNext());
                                continue;
                            }
                            jsonWriter.add(ev2);
                            continue;
                        }
                        switch (ev2.getType()) {
                            case START_ARRAY: 
                            case START_ITEM_ARRAY: 
                            case START_OBJECT: {
                                stack.push(ev2);
                                break;
                            }
                            case END_ARRAY: 
                            case END_ITEM_ARRAY: 
                            case END_OBJECT: {
                                stack.pop();
                            }
                        }
                        if (stack.isEmpty()) continue;
                        refsContent.add(ev2);
                    }
                    refsContent.forEach(ev -> jsonWriter.add(ev));
                    jsonWriter.add(JSonEvent.createEndObject());
                    jsonWriter.add(JSonEvent.createEndObject());
                    jsonWriter.add(JSonEvent.createEndObject());
                    jsonWriter.add(JSonEvent.createEndDocument());
                    jsonReader.close();
                    jsonWriter.flush();
                }
                if (jsonWriter == null) return out.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (jsonWriter == null) throw throwable;
                jsonWriter.close();
                throw throwable;
            }
            jsonWriter.close();
            return out.toByteArray();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

