/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.wizard;

import com.indy.addons.httprest.Md2AuthenticationFactory;
import com.indy.addons.httprest.wizard.InvocationUI;
import com.indy.addons.httprest.wizard.Messages;
import com.indy.addons.httprest.wizard.NodeHandlerI;
import com.indy.addons.httprest.wizard.NodeHandlerRest;
import com.indy.addons.httprest.wizard.NodeHandlerWsdl;
import com.indy.addons.httprest.wizard.RestWizard;
import com.indy.addons.httprest.wizard.RestWizardBean;
import com.indy.addons.httprest.wizard.RuntimeHttpInvoker;
import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.stambia.md.MdNode;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RestWizardControler {
    private final org.apache.logging.log4j.Logger logger = LogManager.getLogger(this.getClass());
    private static final WeakHashMap<MdNode, InputHint> inputHints = new WeakHashMap();
    private InputHint hint = null;
    private RestWizardBean bean;
    private MdNode reversedMdNode;
    private MdNode authenticationNode;
    private MdNode authenticationProxyNode;
    private MdNode keyStoreNode;
    private MdNode trustStoreNode;
    private List<MdNode> securityNodes = new ArrayList<MdNode>();
    private MdNode rootMdNode;
    private List<MdNode> proxyHttpNode = null;
    private List<MdNode> keyStoreAndTrustStoreNodeList = null;
    private InvokeResult lastResult;
    private NodeHandlerI nodeHandler;
    private RestWizard.RestReverseMode reverseMode;
    private Job invokeJob = new Job(Messages.WSController_2){

        public IStatus run(IProgressMonitor monitor) {
            try {
                RuntimeHttpInvoker i = new RuntimeHttpInvoker(RestWizardControler.this);
                RestWizardControler.this.lastResult = i.doSend(RestWizardControler.this.createInvocationInput());
            }
            catch (Throwable ex) {
                return new Status(4, "com.indy.addons.httprest", Messages.WSController_3, ex);
            }
            return Status.OK_STATUS;
        }
    };

    public RestWizardControler(MdNode reversedNode, RestWizard.RestReverseMode reverseMode) {
        this.reversedMdNode = reversedNode;
        this.hint = inputHints.get(this.reversedMdNode);
        this.reverseMode = reverseMode;
        this.bean = new RestWizardBean(this.reverseMode);
        this.nodeHandler = reverseMode.equals((Object)RestWizard.RestReverseMode.HTTPREST) ? new NodeHandlerRest(this) : new NodeHandlerWsdl(this);
        this.initialize();
        this.invokeJob.setUser(true);
        this.hint = inputHints.get(this.reversedMdNode);
    }

    public RestWizard.RestReverseMode getReverseMode() {
        return this.reverseMode;
    }

    public MdNode getAuthenticationMdNode() {
        return this.authenticationNode;
    }

    public MdNode getAuthenticationProxyMdNode() {
        return this.authenticationProxyNode;
    }

    public List<MdNode> getExistingAuthenticationMdNode() {
        return this.securityNodes;
    }

    public void setAuthenticationMdNodes(List<MdNode> securityNodes) {
        this.securityNodes = securityNodes;
    }

    private void initialize() {
        if (this.hint == null) {
            this.hint = new InputHint();
            inputHints.put(this.reversedMdNode, this.hint);
        }
        this.nodeHandler.fillBean(this.reversedMdNode);
        this.createInvocationInput();
    }

    public List<MdNode> refreshExistingAuthenticationMdNode() {
        this.securityNodes = new ArrayList<MdNode>();
        this.securityNodes.addAll(this.rootMdNode.getNodeByCode("com.stambia.wsdl.oauth"));
        this.securityNodes.addAll(this.rootMdNode.getNodeByCode("com.stambia.wsdl.oauth2"));
        this.securityNodes.addAll(this.rootMdNode.getNodeByCode("com.stambia.wsdl.basicauth"));
        this.securityNodes.addAll(this.rootMdNode.getNodeByCode("com.stambia.wsdl.ntlm"));
        this.nodeHandler.refreshExistingAuthenticationMdNode(this.rootMdNode);
        return this.securityNodes;
    }

    public List<MdNode> refreshExistingProxyMdNode() {
        if (this.proxyHttpNode == null) {
            try {
                this.proxyHttpNode = (List)this.rootMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_PROXY_REF");
            }
            catch (Exception ex) {
                this.logger.warn("Error while refreshing proxy node", (Throwable)ex);
            }
            if (this.proxyHttpNode == null) {
                this.proxyHttpNode = Collections.EMPTY_LIST;
            }
        }
        return this.proxyHttpNode;
    }

    public List<MdNode> refreshExistingKeystoreAndTruststoreMdNode() {
        if (this.keyStoreAndTrustStoreNodeList == null) {
            try {
                this.keyStoreAndTrustStoreNodeList = (List)this.rootMdNode.evaluateXpathExpressionMdSet("INTERNAL_AVAILABLE_KEYSTORE_TRUSTSTORE_REF");
            }
            catch (Exception ex) {
                Logger.getLogger(RestWizardControler.class.getName()).log(Level.SEVERE, Messages.NodeHandlerWsdl_0, ex);
            }
            if (this.keyStoreAndTrustStoreNodeList == null) {
                this.keyStoreAndTrustStoreNodeList = Collections.EMPTY_LIST;
            }
        }
        return this.keyStoreAndTrustStoreNodeList;
    }

    public InvokeResult getLastResult() {
        return this.lastResult;
    }

    public RestWizardBean getBean() {
        return this.bean;
    }

    public Job handleCallURL() {
        this.invokeJob.cancel();
        this.invokeJob.setUser(true);
        this.invokeJob.schedule();
        return this.invokeJob;
    }

    public void handleCancelCall() {
        this.invokeJob.cancel();
        this.lastResult = null;
        this.invokeJob.cancel();
    }

    public URL getURL() throws MalformedURLException, UnsupportedEncodingException {
        String resource = this.getBean().getHttpResourcePath();
        ArrayList<RestWizardBean.Parameter> params = new ArrayList<RestWizardBean.Parameter>();
        for (RestWizardBean.Parameter p : this.getBean().getParameters()) {
            if (p.value == null || p.type == null || !p.send.booleanValue()) continue;
            switch (p.type) {
                case HTTP_URL_ENCODED: {
                    params.add(p);
                    break;
                }
                case HTTP_URL_REPLACEMENT: {
                    resource = resource.replace("{" + p.name + "}", p.value);
                    break;
                }
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.getBean().getHttpEndpoint());
        StringBuffer pathBuf = new StringBuffer();
        String resourceQuery = null;
        if (resource.contains("?")) {
            int i = resource.indexOf("?");
            resourceQuery = i + 1 < resource.length() ? resource.substring(i + 1) : null;
            resource = resource.substring(0, i);
        }
        String[] p = resource.split("/", -1);
        int i = 0;
        while (i < p.length) {
            block19: {
                block18: {
                    block17: {
                        if (i != 0) break block17;
                        if (!resource.startsWith("/")) break block18;
                        break block19;
                    }
                    pathBuf.append("/");
                }
                pathBuf.append(URLEncoder.encode(p[i], "UTF-8"));
            }
            ++i;
        }
        buf.append(pathBuf);
        if (resourceQuery != null) {
            buf.append("?");
            boolean first = false;
            String[] stringArray = resourceQuery.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!first) {
                    buf.append("&");
                } else {
                    first = false;
                }
                String[] p2 = s.split("=");
                buf.append(URLEncoder.encode(p2[0], "UTF-8"));
                if (p2.length > 1) {
                    buf.append("=");
                    buf.append(URLEncoder.encode(p2[1], "UTF-8"));
                }
                ++n2;
            }
        }
        if (params.size() > 0) {
            if (resourceQuery == null) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            StringBuffer bufParameters = new StringBuffer();
            for (RestWizardBean.Parameter p3 : params) {
                if (bufParameters.length() > 0) {
                    bufParameters.append("&");
                }
                bufParameters.append(URLEncoder.encode(p3.name, "UTF-8"));
                bufParameters.append("=");
                bufParameters.append(URLEncoder.encode(p3.value, "UTF-8"));
            }
            buf.append(bufParameters.toString());
        }
        return new URL(buf.toString());
    }

    public List<MdNode> getNewNode(MdNode originalMdNode) {
        return this.nodeHandler.getNewNode(originalMdNode, this.createInvocationInput());
    }

    private InvocationInput createInvocationInput() {
        URL url = null;
        try {
            url = this.getURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new InvocationInput(this.reverseMode, url, this.getBean().getHttpMethod(), this.getBean().getParameters(), this.getBean().getHttpEndpoint(), this.getBean().getHttpResourcePath(), this.getBean().getHttpResourcePaths(), this.getBean().getHttpInputContentType(), this.getBean().getHttpInputMediaType(), this.getBean().getInputData(), this.getBean().getHeaders(), this.getAuthenticationMdNode(), this.getAuthenticationProxyMdNode());
    }

    public InputHint getHint() {
        return this.hint;
    }

    public MdNode getReversedMdNode() {
        return this.reversedMdNode;
    }

    public MdNode getSecurityParentNode() {
        return this.rootMdNode;
    }

    public void setRootMdNode(MdNode rootMdNode) {
        this.rootMdNode = rootMdNode;
    }

    public void registerHint() {
        InputHint hint = new InputHint();
        hint.txtInput = this.getBean().getInputData();
        for (RestWizardBean.Parameter p : this.getBean().getParameters()) {
            hint.parameterValues.put(p.name, p.value);
        }
        inputHints.put(this.reversedMdNode, hint);
    }

    public void setAuthenticationMdNode(MdNode securityNode) {
        this.authenticationNode = securityNode;
    }

    public void setAuthenticationProxyMdNode(MdNode securityNode) {
        this.authenticationProxyNode = securityNode;
    }

    public void setKeyStoreNode(MdNode keyStoreNode) {
        this.keyStoreNode = keyStoreNode;
    }

    public MdNode getKeyStoreMdNode() {
        return this.keyStoreNode;
    }

    public void setTrustStoreNode(MdNode trustStoreNode) {
        this.trustStoreNode = trustStoreNode;
    }

    public MdNode getTrustStoreMdNode() {
        return this.trustStoreNode;
    }

    public Map<String, Object> getKeyStoreParams() {
        if (this.bean.getKeyStoreParams() != null) {
            return this.bean.getKeyStoreParams().toMap();
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> getTrustStoreParams() {
        if (this.bean.getTrustStoreParams() != null) {
            return this.bean.getTrustStoreParams().toMap();
        }
        return Collections.emptyMap();
    }

    public static enum BindingType {
        HTTP_HEADER("http:header", Arrays.asList(RestWizard.RestReverseMode.WSDL, RestWizard.RestReverseMode.HTTPREST)),
        HTTP_METHOD("http:method", Arrays.asList(RestWizard.RestReverseMode.WSDL)),
        HTTP_URL_ENCODED("http:urlEncoded", Arrays.asList(RestWizard.RestReverseMode.WSDL, RestWizard.RestReverseMode.HTTPREST)),
        HTTP_URL_REPLACEMENT("http:urlReplacement", Arrays.asList(RestWizard.RestReverseMode.WSDL, RestWizard.RestReverseMode.HTTPREST)),
        MIME_CONTENT("mime:content", Arrays.asList(RestWizard.RestReverseMode.WSDL, RestWizard.RestReverseMode.HTTPREST)),
        HTTP_COOKIE("http:cookie", Arrays.asList(RestWizard.RestReverseMode.HTTPREST));

        private String code;
        private Set<RestWizard.RestReverseMode> enabledModes;

        private BindingType(String code, List<RestWizard.RestReverseMode> modes) {
            this.code = code;
            this.enabledModes = modes != null ? new HashSet<RestWizard.RestReverseMode>(modes) : new HashSet<RestWizard.RestReverseMode>();
        }

        public String getCode() {
            return this.code;
        }

        public boolean isActive(RestWizard.RestReverseMode reverseMode) {
            return this.enabledModes.contains((Object)reverseMode);
        }
    }

    public static interface IHttpInvoker {
        public InvokeResult doSend(InvocationInput var1) throws Exception;
    }

    public static class InputHint {
        Map<String, String> parameterValues = new HashMap<String, String>();
        String txtInput = "";
    }

    public class InvocationInput {
        public AuthenticationInfo authenticationInfo;
        public AuthenticationInfo authenticationProxyInfo;
        public String endpoint;
        public List<String[]> headers;
        public String input;
        public String inputContentType;
        public String inputMediaType;
        public String method;
        public List<RestWizardBean.Parameter> parameters = new ArrayList<RestWizardBean.Parameter>();
        public String resource;
        public List<String> resources = new ArrayList<String>();
        public MdNode securityNode;
        public MdNode proxySecurityNode;

        public InvocationInput(RestWizard.RestReverseMode reverseMode, URL url, String method, List<RestWizardBean.Parameter> parameters, String endpoint, String resource, List<String> resources, String inputContentType, String inputMediaType, String input, List<String[]> headers, MdNode securityNode, MdNode proxySecurityNode) {
            this.method = method;
            this.parameters = parameters;
            this.endpoint = endpoint;
            this.resource = resource;
            this.resources = resources;
            this.inputContentType = inputContentType;
            this.inputMediaType = inputMediaType;
            this.input = input;
            this.headers = headers;
            this.securityNode = securityNode;
            this.proxySecurityNode = proxySecurityNode;
            this.authenticationInfo = this.createAuthentication(this.securityNode, url);
            this.authenticationProxyInfo = this.createProxyAuthentication(this.proxySecurityNode, url);
            if ("GET".equals(method) || "HEAD".equals(method)) {
                boolean supportInput = false;
                for (RestWizardBean.Parameter p : parameters) {
                    if (p.type != BindingType.MIME_CONTENT) continue;
                    supportInput = true;
                    break;
                }
                if ("GET".equals(method) && reverseMode == RestWizard.RestReverseMode.HTTPREST) {
                    supportInput = true;
                }
                if (!supportInput) {
                    this.input = null;
                }
            }
        }

        private AuthenticationInfo createAuthentication(MdNode securityNode, URL url) {
            try {
                this.authenticationInfo = Md2AuthenticationFactory.getAuthenticationInfo(securityNode, url, this.getMethod(), this.proxySecurityNode);
                return this.authenticationInfo;
            }
            catch (Exception e) {
                RestWizardControler.this.logger.warn("Error while creating authentication info", (Throwable)e);
                return this.authenticationInfo;
            }
        }

        private AuthenticationInfo createProxyAuthentication(MdNode securityNode, URL url) {
            try {
                this.authenticationProxyInfo = Md2AuthenticationFactory.getAuthenticationInfo(securityNode, url, this.getMethod(), null);
                return this.authenticationProxyInfo;
            }
            catch (Exception e) {
                RestWizardControler.this.logger.warn("Error while creating authentication info", (Throwable)e);
                return this.authenticationProxyInfo;
            }
        }

        public AuthenticationInfo getAuthenticationInfo() {
            return this.authenticationInfo;
        }

        public MdNode getAuthenticationNode() {
            return this.securityNode;
        }

        public MdNode getAuthenticationProxyNode() {
            return this.proxySecurityNode;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public List<String[]> getHeaders() {
            return this.headers;
        }

        public String getInput() {
            return this.input;
        }

        public String getInputContentType() {
            return this.inputContentType;
        }

        public String getMediaType() {
            return this.inputMediaType;
        }

        public String getMethod() {
            return this.method;
        }

        public List<RestWizardBean.Parameter> getParameters() {
            return this.parameters;
        }

        public AuthenticationInfo getProxyAuthenticationInfo() {
            return this.authenticationProxyInfo;
        }

        public List<String> getResources() {
            return this.resources;
        }

        public String getResource() {
            return this.resource;
        }
    }

    public class InvokeResult {
        private String charSet;
        private String contentType;
        private String datas;
        private boolean error;
        private Map<String, List<String>> headers;
        private Map<String, String> cookies;
        private String responseMessage;
        private int responseCode;

        public InvokeResult(String encoding, byte[] datas, boolean error, Map<String, List<String>> headers, Map<String, String> cookies, String responseMessage, int responseCode) {
            this.error = error;
            this.headers = headers;
            this.cookies = cookies;
            this.responseMessage = responseMessage;
            this.responseCode = responseCode;
            for (String k : this.headers.keySet()) {
                List<String> l;
                if (k == null || !k.trim().equalsIgnoreCase("Content-Type") || (l = this.headers.get(k)) == null) continue;
                for (String s : l) {
                    if (s.contains(";")) {
                        int i = s.indexOf(";");
                        this.contentType = s.substring(0, i);
                        this.charSet = s.substring(i + 1).trim().replace("charset=", "");
                        continue;
                    }
                    this.contentType = s;
                }
            }
            if (this.charSet == null) {
                this.charSet = encoding != null ? encoding : "UTF-8";
            }
            try {
                this.datas = new String(datas, this.charSet);
            }
            catch (UnsupportedEncodingException e) {
                this.datas = new String(datas);
            }
        }

        String getCharset() {
            return this.charSet;
        }

        String getContentType() {
            return this.contentType;
        }

        String getDatas() {
            return this.datas;
        }

        Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        Map<String, String> getCookies() {
            return this.cookies;
        }

        public String getHttpResponseMessage() {
            return this.responseMessage;
        }

        public int getHttpResponseCode() {
            return this.responseCode;
        }

        boolean isError() {
            return this.error;
        }

        public void setContentType(String s) {
            if (s != null) {
                this.contentType = s;
            }
        }

        public String computeMediaType() {
            String defaultMediaType = RestWizardControler.this.bean.getHttpOutputMediaTypePerResultCode().get("" + this.responseCode);
            if (defaultMediaType != null && !defaultMediaType.isEmpty()) {
                return defaultMediaType;
            }
            String mediaType = RestWizardControler.this.bean.getHttpOutputMediaType();
            if (mediaType != null && !mediaType.isEmpty()) {
                return mediaType;
            }
            if (this.contentType != null) {
                if (this.contentType.toLowerCase().contains("json")) {
                    return InvocationUI.MimeType.JSON.getMediaType();
                }
                if (this.contentType.toLowerCase().contains("xml")) {
                    return InvocationUI.MimeType.XML.getMediaType();
                }
                if (this.contentType.toLowerCase().contains("text")) {
                    return InvocationUI.MimeType.TEXT.getMediaType();
                }
                if (this.contentType.toLowerCase().contains("form")) {
                    return InvocationUI.MimeType.FORM.getMediaType();
                }
            }
            return "";
        }
    }
}

