/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.ResourceOwnerGrantBean;
import com.indy.addons.oauth2.wizard.SecretsResolver;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.designer.core.SSLContextFactory;
import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGrantFlow {
    ResourceOwnerGrantBean bean;
    final SecretsResolver secretsResolver;
    private final Logger logger = LogManager.getLogger(AbstractGrantFlow.class);

    AbstractGrantFlow(ResourceOwnerGrantBean bean) {
        this.bean = bean;
        this.secretsResolver = new SecretsResolver();
    }

    protected Map<String, String> getAccessTokenEndpointQueryParam() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.bean.credentialMode == OAuth2.CredentialMode.PARAMETER_CLIENT_ID) {
            params.put("client_id", this.resolveSecrets(this.bean.clientId)[0]);
        } else if (this.bean.credentialMode == OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET) {
            String[] clientIdAndSecrets = this.resolveSecrets(this.bean.clientId, this.bean.clientSecret);
            params.put("client_id", clientIdAndSecrets[0]);
            params.put("client_secret", clientIdAndSecrets[1]);
        }
        if (this.bean.authParams != null) {
            params.putAll(this.bean.authParams);
        }
        params.put("scope", String.join((CharSequence)" ", this.bean.scopes));
        return params;
    }

    String[] resolveSecrets(String ... values) throws Exception {
        return this.secretsResolver.resolveSecrets(values);
    }

    private static ApacheHttpClient.SslConfig createSslConfig(boolean enableCertificateVerification, boolean enableHostnameVerification) throws Exception {
        if (enableCertificateVerification) {
            SSLContextFactory.SSLContextParameters contextParams = new SSLContextFactory.SSLContextParameters();
            return new ApacheHttpClient.SslConfig(SSLContextFactory.createSSLContext((SSLContextFactory.SSLContextParameters)contextParams), !enableHostnameVerification);
        }
        X509TrustManager trustMgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustMgr}, null);
        return new ApacheHttpClient.SslConfig(sslContext, !enableHostnameVerification);
    }

    public AuthorizationCodeGrantFlow.AccessTokenResponse getToken() throws Exception {
        String url = this.bean.tokenURI;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.bean.additionalHeaders != null) {
            headers.putAll(this.bean.additionalHeaders);
        }
        ApacheHttpClient httpHelper = ApacheHttpClient.build((ApacheHttpClient.SslConfig)AbstractGrantFlow.createSslConfig(this.bean.enableCertificateVerification, this.bean.enableHostnameVerification));
        Credentials credentials = null;
        if (this.bean.credentialMode == OAuth2.CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET) {
            String[] clientIdAndSecrets = this.resolveSecrets(this.bean.clientId, this.bean.clientSecret);
            credentials = ApacheHttpClient.createBasicAuthCredentials((String)clientIdAndSecrets[0], (char[])clientIdAndSecrets[1].toCharArray());
            BasicAuthentication basicAuth = new BasicAuthentication(clientIdAndSecrets[0], clientIdAndSecrets[1]);
            headers.put("authorization", basicAuth.getAuthenticationHeaderValue(null));
        }
        Map<String, String> queryParam = this.getAccessTokenEndpointQueryParam();
        HttpClientResponseHandler responseHandler = r -> {
            String charsetAsString = StandardCharsets.UTF_8.name();
            try {
                String contentType = r.getEntity().getContentType();
                Charset charset = ContentType.parseLenient((CharSequence)contentType).getCharset();
                if (charset != null) {
                    charsetAsString = charset.name();
                }
            }
            catch (Exception e) {
                this.logger.debug("Cannot parse content type", (Throwable)e);
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (JsonEventReader reader = new JsonEventReader(r.getEntity().getContent(), charsetAsString);){
                HashMap<String, String> res = new HashMap<String, String>();
                String propName = null;
                while (reader.hasNext()) {
                    try {
                        JSonEvent ev = reader.readNext();
                        switch (ev.getType()) {
                            case MEMBER: {
                                propName = ev.getName();
                                break;
                            }
                            case STRING: 
                            case VALUE: {
                                res.put(propName, ev.getName());
                                propName = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
                return new AuthorizationCodeGrantFlow.AccessTokenResponse(res);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
        if ("POST".equals(this.bean.httpMethod)) {
            headers.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            return (AuthorizationCodeGrantFlow.AccessTokenResponse)httpHelper.post(url, queryParam, headers, credentials, this.bean.credentialMode == OAuth2.CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET, responseHandler);
        }
        return (AuthorizationCodeGrantFlow.AccessTokenResponse)httpHelper.get(url, queryParam, headers, credentials, this.bean.credentialMode == OAuth2.CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET, responseHandler);
    }
}

