/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class URLParser {
    static int MODE_FRAGMENT = 1;
    static int MODE_PARAMETER = 2;
    private String url;
    private Map<String, String> parameters = new HashMap<String, String>();

    public URLParser(String url, int mode) {
        Assert.isTrue((mode == MODE_FRAGMENT || mode == MODE_PARAMETER ? 1 : 0) != 0);
        this.url = url;
        this.parse(mode);
    }

    private void parse(int mode) {
        if (this.url == null) {
            return;
        }
        int i = this.url.indexOf(MODE_PARAMETER == mode ? "?" : "#");
        if (i == -1) {
            return;
        }
        if (i + 1 >= this.url.length()) {
            return;
        }
        String paramString = this.url.substring(i + 1).trim();
        String[] stringArray = paramString.split("\\&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] p = s.split("=");
            if (p.length > 1) {
                String key = p[0].trim();
                String value = null;
                try {
                    value = URLDecoder.decode(p[1].trim(), "UTF-8");
                }
                catch (Exception e) {
                    value = p[1].trim();
                }
                this.parameters.put(key, value);
            }
            ++n2;
        }
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Collection<String> getParameters() {
        return this.parameters.keySet();
    }
}

