/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.command;

import com.indy.engine.Global;
import com.indy.engine.command.Messages;
import com.indy.engine.common.command.parser.CommandI;
import com.indy.engine.common.command.parser.CommandInstanceI;
import com.indy.engine.common.command.parser.CommandLineParserI;
import com.indy.engine.common.command.parser.CommandParserExceptionI;
import com.indy.engine.common.command.parser.ICommandExecutorI;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.LocalSession;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EngineCommandsRemote {
    private PrintStream out;
    private InputStream in;
    CommandLineParserI commandParser = new CommandLineParserI();
    IEngineClient engineAPI = null;
    String hostConnected = "";
    String portConnected = "";
    public static final String EXIT_COMMAND = "exit";
    public static final String MSG_SYNTAX_ERROR = Messages.getString("EngineCommandsRemote.0");
    public final Logger logger = LogManager.getLogger((String)"com.indy.engine");
    String pHost;
    String pPort;
    String pUser;
    String pPassword;
    String pCryptedPassword;
    private boolean displayStartLine = true;
    private static String connectErrorMessage = Messages.getString("EngineCommandsRemote.11");
    Integer exitCode;

    public EngineCommandsRemote() {
        this(System.in, System.out);
    }

    public EngineCommandsRemote(InputStream in) {
        this(in, System.out);
    }

    public EngineCommandsRemote(InputStream in, PrintStream out) {
        this.out = out;
        this.in = in;
        this.comConnectDefine();
    }

    public String getpHost() {
        return this.pHost;
    }

    public String getpPort() {
        return this.pPort;
    }

    public boolean executeNew() {
        try (Scanner scanner = null;){
            HashMap<String, String> commandMap = new HashMap<String, String>();
            scanner = System.getProperty("os.name").toLowerCase().contains("win") ? new Scanner(this.in, "Cp850") : new Scanner(this.in, "UTF-8");
            String line = null;
            boolean exit = false;
            while (!exit) {
                if (this.displayStartLine) {
                    if (this.hostConnected.equals("")) {
                        this.out.print("> ");
                    } else {
                        this.out.print(this.hostConnected + ":" + this.portConnected + " > ");
                    }
                }
                if (scanner.hasNext(EXIT_COMMAND)) {
                    exit = true;
                    continue;
                }
                line = scanner.nextLine();
                if ((line = line.replaceAll("(-conf.*xml\\s)", "")).trim().startsWith("connect")) {
                    this.executeCommand(line);
                    continue;
                }
                if (!this.connectOrReconnect()) continue;
                commandMap.put("singleCommand", line);
                if (!this.checkLine(line, this.out)) continue;
                try {
                    Map result = this.getEngineAPI().invokeCommand(commandMap);
                    Map context = (Map)result.get("context");
                    if (context != null) {
                        Object returnCode = context.get("lastExecutionDeliveryReturnCode");
                        if (returnCode instanceof Integer) {
                            this.exitCode = (Integer)returnCode == 1 ? 0 : (Integer)returnCode;
                        } else if (context.get("returnCode") instanceof Integer) {
                            this.exitCode = (Integer)context.get("returnCode");
                        }
                    }
                    this.out.println(result.get("singleResult"));
                }
                catch (Exception e) {
                    this.out.println(Messages.getString("EngineCommandsRemote.1") + e.getMessage());
                }
            }
            return true;
        }
    }

    protected boolean checkLine(String line, PrintStream out) {
        return true;
    }

    public boolean executeCommand(String args) throws Exception {
        boolean ret = false;
        try {
            this.commandParser.executeCommandLine(args);
        }
        catch (CommandParserExceptionI e) {
            this.out.println(MSG_SYNTAX_ERROR);
            throw e;
        }
        return ret;
    }

    void comConnectDefine() {
        try {
            CommandI comConnect = new CommandI("connect", "connect [to <host|connectionName>] [port <port>] [silent] [user <user>] [password <password>] [uncryptedPassword <password>]", Messages.getString("EngineCommandsRemote.2"), new ICommandExecutorI(){

                public void execute(CommandInstanceI commandInstance) {
                    try {
                        EngineCommandsRemote.this.pHost = commandInstance.getParameterValue(0);
                        if (EngineCommandsRemote.this.pHost == null) {
                            EngineCommandsRemote.this.pHost = "localhost";
                        }
                        try {
                            EngineCommandsRemote.this.pPort = commandInstance.getParameterValue(1);
                            if (EngineCommandsRemote.this.pPort == null) {
                                EngineCommandsRemote.this.pPort = String.valueOf(Global.HTTP_PORT);
                            }
                        }
                        catch (Exception e) {
                            EngineCommandsRemote.this.pPort = String.valueOf(Global.HTTP_PORT);
                        }
                        String silent = commandInstance.getParameterValue(2);
                        EngineCommandsRemote.this.pUser = commandInstance.getParameterValue(3);
                        EngineCommandsRemote.this.pCryptedPassword = commandInstance.getParameterValue(4);
                        EngineCommandsRemote.this.pPassword = commandInstance.getParameterValue(5);
                        HashMap<String, String> credentials = new HashMap<String, String>();
                        if (EngineCommandsRemote.this.pUser != null) {
                            credentials.put("user", EngineCommandsRemote.this.pUser);
                        }
                        if (EngineCommandsRemote.this.pPassword != null) {
                            if (silent == null) {
                                EngineCommandsRemote.this.out.println(Messages.getString("EngineCommandsRemote_UncryptedDeprecated"));
                            }
                            credentials.put("password", EngineCommandsRemote.this.pPassword);
                        }
                        if (EngineCommandsRemote.this.pCryptedPassword != null) {
                            credentials.put("password", EngineCommandsRemote.this.pCryptedPassword);
                        }
                        if (silent == null) {
                            EngineCommandsRemote.this.out.println(MessageFormat.format(Messages.getString("EngineCommandsRemote.8"), EngineCommandsRemote.this.pHost, EngineCommandsRemote.this.pPort));
                        }
                        if (EngineCommandsRemote.this.pHost == null) {
                            try {
                                InetAddress addr = InetAddress.getLocalHost();
                                EngineCommandsRemote.this.pHost = addr.getHostName();
                            }
                            catch (UnknownHostException e1) {
                                EngineCommandsRemote.this.pHost = "localhost";
                            }
                        }
                        LocalSession cc = EngineFactory.getEngine((String)EngineCommandsRemote.this.pHost, (int)new Integer(EngineCommandsRemote.this.pPort), credentials);
                        EngineCommandsRemote.this.engineAPI = cc.getRemoteObject();
                        if (silent == null) {
                            EngineCommandsRemote.this.out.println(Messages.getString("EngineCommandsRemote.9"));
                        }
                        EngineCommandsRemote.this.hostConnected = EngineCommandsRemote.this.pHost;
                        EngineCommandsRemote.this.portConnected = EngineCommandsRemote.this.pPort;
                    }
                    catch (Exception e) {
                        EngineCommandsRemote.this.logger.warn("An exception occured : ", (Throwable)e);
                        EngineCommandsRemote.this.exitCode = -1;
                        EngineCommandsRemote.this.out.println(e.getMessage());
                    }
                }
            });
            this.commandParser.AddCommand(comConnect);
        }
        catch (CommandParserExceptionI e) {
            this.logger.warn("An exception occured : ", (Throwable)e);
        }
    }

    public void setDisplayStartLine(boolean b) {
        this.displayStartLine = b;
    }

    public boolean connectOrReconnect() {
        try {
            this.engineAPI.isConnected();
        }
        catch (Exception e) {
            if (this.pHost != null && this.pPort != null) {
                try {
                    HashMap<String, String> credentials = new HashMap<String, String>();
                    if (this.pUser != null) {
                        credentials.put("user", this.pUser);
                    }
                    if (this.pPassword != null) {
                        credentials.put("password", this.pPassword);
                    }
                    if (this.pCryptedPassword != null) {
                        credentials.put("password", this.pCryptedPassword);
                    }
                    LocalSession cc = EngineFactory.getEngine((String)this.pHost, (int)new Integer(this.pPort), credentials);
                    this.portConnected = this.pPort;
                    this.hostConnected = this.pHost;
                    this.engineAPI = cc.getRemoteObject();
                }
                catch (Exception e1) {
                    this.exitCode = -1;
                    this.out.println(Messages.getString("EngineCommandsRemote.10") + this.pHost + ":" + this.pPort + "\n" + e1.getMessage());
                    this.logger.warn("An exception occured : ", (Throwable)e1);
                    return false;
                }
            }
            this.out.println(connectErrorMessage);
            return false;
        }
        return true;
    }

    public IEngineClient getEngineAPI() {
        return this.engineAPI;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }
}

