/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.egit.jgit;

import com.google.common.collect.ImmutableMap;
import com.indy.emf.compare.integration.internal.XdiDiffEngine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookRegistry;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMappingMerger;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.provider.MergeStatus;

public class StbEMFResourceMerger
extends EMFResourceMappingMerger {
    IStorage left;
    IStorage right;
    IStorage ancestor;
    URI savedResourceURI = null;

    private boolean hasRealConflict(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (conflict.getKind() != ConflictKind.REAL) continue;
            return true;
        }
        return false;
    }

    StbEMFResourceMerger(IStorage left, IStorage right, IStorage ancestor) {
        this.left = left;
        this.right = right;
        this.ancestor = ancestor;
    }

    protected void mergeMapping(ResourceMapping mapping, IMergeContext mergeContext, Set<ResourceMapping> failingMappings, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ResourceSetHookRegistry resourceSetHookRegistry = EMFCompareIDEPlugin.getDefault().getResourceSetHookRegistry();
        StorageTraversal ancestorTr = new StorageTraversal((Set)(this.ancestor == null ? Collections.EMPTY_SET : Collections.singleton(this.ancestor)));
        NotLoadingResourceSet ancestor = NotLoadingResourceSet.create((StorageTraversal)ancestorTr, (IProgressMonitor)subMonitor, (ResourceSetHookRegistry)resourceSetHookRegistry);
        StorageTraversal leftTrr = new StorageTraversal(Collections.singleton(this.left));
        NotLoadingResourceSet left = NotLoadingResourceSet.create((StorageTraversal)leftTrr, (IProgressMonitor)subMonitor, (ResourceSetHookRegistry)resourceSetHookRegistry);
        StorageTraversal rigjtTr = new StorageTraversal(Collections.singleton(this.right));
        NotLoadingResourceSet right = NotLoadingResourceSet.create((StorageTraversal)rigjtTr, (IProgressMonitor)subMonitor, (ResourceSetHookRegistry)resourceSetHookRegistry);
        EMFCompare.Builder builder = EMFCompare.builder();
        builder.setDiffEngine((IDiffEngine)new XdiDiffEngine());
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        EMFCompare comparator = builder.build();
        Comparison comparison = comparator.compare(EMFCompare.createDefaultScope((Notifier)left, (Notifier)right, (Notifier)ancestor));
        if (comparison.getDiagnostic().getSeverity() == 4) {
            failingMappings.add(mapping);
            subMonitor.setWorkRemaining(0);
            return;
        }
        if (this.hasRealConflict(comparison)) {
            failingMappings.add(mapping);
        } else {
            this.performBatchMerge(comparison, subMonitor.newChild(3));
            this.save((Notifier)left, leftTrr, rigjtTr, ancestorTr);
        }
        subMonitor.setWorkRemaining(0);
    }

    private void performBatchMerge(Comparison comparison, SubMonitor subMonitor) {
        BatchMerger merger = new BatchMerger((IMerger.Registry)MERGER_REGISTRY, EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
        merger.copyAllRightToLeft((Iterable)comparison.getDifferences(), BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor));
    }

    protected void save(Notifier notifier, StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
        if (notifier instanceof ResourceSet) {
            ResourceUtil.saveAllResources((ResourceSet)((ResourceSet)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"), (StorageTraversal)leftTraversal, (StorageTraversal)rightTraversal, (StorageTraversal)originTraversal);
            if (!((ResourceSet)notifier).getResources().isEmpty()) {
                this.savedResourceURI = ((Resource)((ResourceSet)notifier).getResources().get(0)).getURI();
            }
        } else if (notifier instanceof Resource) {
            ResourceUtil.saveResource((Resource)((Resource)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            this.savedResourceURI = ((Resource)notifier).getURI();
        }
    }

    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            HashSet<ResourceMapping> failingMappings = new HashSet<ResourceMapping>();
            this.mergeMapping(null, mergeContext, failingMappings, (IProgressMonitor)subMonitor.newChild(1));
            IStatus status = Status.OK_STATUS;
            if (!failingMappings.isEmpty()) {
                ResourceMapping[] failingArray = failingMappings.toArray(new ResourceMapping[failingMappings.size()]);
                status = new MergeStatus("org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString((String)"EMFResourceMappingMerger.mergeFailedConflicts"), failingArray);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

