/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.common;

import com.indy.engine.action.common.Messages;
import com.indy.engine.action.common.SecretValueManager;
import com.indy.engine.core.externalvalueresolver.ExternalValueResolverManager;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;

public class SecretValueImpl
implements ISecretValue {
    private String sourceValue;
    private String defaultValue;
    private CheckedFunction<String, String> decryptFunction;
    private CheckedFunction<String, String> encryptFunction;
    SecretValueManager secretManager = new SecretValueManager();

    public SecretValueImpl(CheckedFunction<String, String> decryptFunction, CheckedFunction<String, String> encryptFunction) {
        this(null, decryptFunction, encryptFunction);
    }

    public SecretValueImpl(String sourceValue, CheckedFunction<String, String> decryptFunction, CheckedFunction<String, String> encryptFunction) {
        this.decryptFunction = decryptFunction;
        this.encryptFunction = encryptFunction;
        this.sourceValue = sourceValue;
    }

    public String resolveStringSecretValue() throws EngineExceptionI {
        return this.secretManager.secret(new ISecretStatement<String>(){

            @Override
            public String execute(ISecretContext context) throws Throwable {
                return SecretValueImpl.this.resolve(context, SecretValueImpl.this.sourceValue);
            }
        });
    }

    public Integer resolveIntegerSecretValue() throws EngineExceptionI {
        return this.secretManager.secret(new ISecretStatement<Integer>(){

            @Override
            public Integer execute(ISecretContext context) throws Throwable {
                return Integer.valueOf(SecretValueImpl.this.resolve(context, SecretValueImpl.this.sourceValue));
            }
        });
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    private String getValue() {
        return this.sourceValue != null ? this.sourceValue : this.defaultValue;
    }

    private String resolve(ISecretContext context, String val) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        boolean needResolution = ExternalValueResolverManager.needResolution(val);
        if (context != null) {
            if (needResolution) {
                return this.doresolve(context, val);
            }
            return val;
        }
        if (needResolution) {
            throw new SecretStatementException(Messages.getString("ActionCodeTypeI.26"));
        }
        return val;
    }

    private String doresolve(ISecretContext context, String val) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        if (context instanceof SecretValueManager.SecretContextImpl) {
            ((SecretValueManager.SecretContextImpl)context).secretValue = true;
            return ExternalValueResolverManager.instance().replace(val).resolved();
        }
        throw new SecretStatementException();
    }

    @Override
    public String getString(ISecretContext context) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        return this.resolve(context, this.getValue());
    }

    @Override
    public Long getLong(ISecretContext context) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        String str = this.resolve(context, this.getValue());
        if (str != null) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException();
            }
        }
        return null;
    }

    @Override
    public Integer getInteger(ISecretContext context) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        String str = this.resolve(context, this.getValue());
        if (str != null) {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException();
            }
        }
        return null;
    }

    @Override
    public Boolean getBoolean(ISecretContext context) throws IExternalValueResolverPlugin.ExternalValueResolverException, SecretStatementException {
        String str = this.resolve(context, this.getValue());
        if (str != null) {
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception e) {
                throw new IExternalValueResolverPlugin.ExternalValueResolverException(Messages.getString("ActionCodeTypeI.27"));
            }
        }
        return null;
    }

    @Override
    public String decryptString(ISecretContext context) throws IExternalValueResolverPlugin.ExternalValueResolverException, EngineExceptionI, SecretStatementException {
        if (this.sourceValue == null) {
            if (this.defaultValue != null) {
                boolean needResolution = ExternalValueResolverManager.needResolution(this.defaultValue);
                if (context != null && needResolution) {
                    String str = this.defaultValue;
                    return this.doresolve(context, str);
                }
            }
            return this.defaultValue;
        }
        boolean needResolution = ExternalValueResolverManager.needResolution(this.defaultValue);
        if (context != null && needResolution) {
            String str = this.sourceValue;
            return this.doresolve(context, str);
        }
        String str = this.decryptFunction.apply(this.sourceValue);
        return this.resolve(context, str);
    }

    @Override
    public String encryptString(ISecretContext context) throws Exception {
        String decrypt = this.decryptString(context);
        return this.encryptFunction.apply(decrypt);
    }

    @Override
    public boolean isNull() {
        return this.sourceValue == null && this.defaultValue == null;
    }

    @Override
    public boolean isNotEmpty() {
        return this.sourceValue != null && !this.sourceValue.isEmpty() || this.defaultValue != null && !this.defaultValue.isEmpty();
    }

    @Override
    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getSourceValue() {
        return this.sourceValue;
    }

    public void setSourceValue(String sourceValue) {
        this.sourceValue = sourceValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws EngineExceptionI;
    }
}

