/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.json;

import com.indy.engine.actionCodes.json.Messages;
import com.indy.engine.core.actionCodes.json.internal.JSONAttributes;
import com.indy.engine.core.actionCodes.json.internal.JsonXmlReader;
import com.indy.engine.core.actionCodes.json.internal.JsonXmlReader2;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JsonReader
implements XMLReader {
    private ContentHandler contentHandler;
    private String positionAttributeName = "__position__";
    private String anonymousTagName = null;

    public JsonReader() {
    }

    public JsonReader(String positionAttributeName, String anonymousTagName) {
        if (positionAttributeName != null && !positionAttributeName.isEmpty()) {
            this.positionAttributeName = positionAttributeName;
        }
        if (anonymousTagName != null && !anonymousTagName.isEmpty()) {
            this.anonymousTagName = anonymousTagName;
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        InputStream is = input.getByteStream();
        JsonXmlReader2 jsr = new JsonXmlReader2(is, this.anonymousTagName, this.positionAttributeName);
        try {
            while (((JsonXmlReader)jsr).hasNext()) {
                JsonXmlReader.JsonObject o = ((JsonXmlReader)jsr).readNext();
                switch (o.getEventType()) {
                    case 7: {
                        this.getContentHandler().startDocument();
                        this.getContentHandler().startElement(null, o.getName(), null, new JSONAttributes(this.positionAttributeName, o.getAttributePosition()));
                        break;
                    }
                    case 1: {
                        this.getContentHandler().startElement(null, o.getName(), null, new JSONAttributes(this.positionAttributeName, o.getAttributePosition()));
                        break;
                    }
                    case 4: {
                        char[] c = jsr.asCharArray(o);
                        this.getContentHandler().characters(c, 0, c.length);
                        break;
                    }
                    case 2: {
                        this.getContentHandler().endElement(null, o.getName(), null);
                        break;
                    }
                    case 8: {
                        this.getContentHandler().endDocument();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SAXException(Messages.getString("JsonReader.0"), ex);
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }
}

