/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.tools.impl;

import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.core.UtilsService;
import java.io.ByteArrayInputStream;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface JavaRealObjectHandler<T, E> {
    public int batchSize();

    public void handleObject(T var1, E var2, OutputStreamTransformer.StatisticHandler var3) throws Exception;

    public void close() throws Exception;

    public void init(E var1, JavaObjectHandler.InitHandler var2) throws Exception;

    public static JavaObjectHandler getJavaObjectHandler(final JavaRealObjectHandler handler) {
        final Class type1 = (Class)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        final Class type2 = (Class)((ParameterizedType)handler.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[1];
        JavaObjectHandler joh = new JavaObjectHandler(){
            Object metadata;

            @Override
            public int batchSize() {
                return handler.batchSize();
            }

            @Override
            public Object handleObject(List o, Object statisticHandler) throws Exception {
                for (Object oo : o) {
                    Object realObject = UtilsService.getJsonUtils().createRealObjectWithGenericalObject(oo, type1);
                    handler.handleObject(realObject, this.metadata, (OutputStreamTransformer.StatisticHandler)statisticHandler);
                    Object ooo = UtilsService.getJsonUtils().createGenericalObjectWithRealObject(realObject);
                    ((Map)oo).putAll((Map)ooo);
                }
                return o;
            }

            @Override
            public void close() throws Exception {
                handler.close();
            }

            @Override
            public void init(Map<String, String> properties, JavaObjectHandler.InitHandler ihandler) throws Exception {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    if (!entry.getKey().startsWith("metadata.json.property.")) continue;
                    String key = entry.getKey().substring("metadata.json.property.".length());
                    props.put(key, entry.getValue());
                }
                if (properties.containsKey("BASE64BINARY_AS_BYTE_ARRAY")) {
                    props.put("BASE64BINARY_AS_BYTE_ARRAY", Boolean.valueOf(properties.get("BASE64BINARY_AS_BYTE_ARRAY")));
                }
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    if (entry.getKey().startsWith("metadata.json.root.")) {
                        map.put(entry.getKey().substring("metadata.json.root.".length()), entry.getValue());
                        continue;
                    }
                    if (!entry.getKey().startsWith("metadata.json.content.") || entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    Map _map = (Map)UtilsService.getJsonUtils().deserializeToJavaObject(new ByteArrayInputStream(entry.getValue().getBytes("UTF-8")), "UTF-8", props);
                    JavaRealObjectHandler.updateMap(map, _map);
                }
                this.metadata = UtilsService.getJsonUtils().createRealObjectWithGenericalObject(map, type2);
                handler.init(this.metadata, ihandler);
            }
        };
        return joh;
    }

    public static void updateMap(Map<Object, Object> map1, Map<Object, Object> map2) {
        for (Map.Entry<Object, Object> entry : new ArrayList<Map.Entry<Object, Object>>(map2.entrySet())) {
            Object value1 = map1.get(entry.getKey());
            Object value2 = map2.get(entry.getKey());
            if (value1 instanceof Map && value2 instanceof Map) {
                JavaRealObjectHandler.updateMap((Map)value1, (Map)value2);
                continue;
            }
            if (value1 == null) {
                map1.put(entry.getKey(), value2);
                continue;
            }
            map1.put(entry.getKey(), value2);
        }
    }
}

