/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.classloader;

import com.indy.engine.core.classloader.IClassLoader;
import com.indy.engine.core.classloader.Messages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class DirectoryClassLoader
implements IClassLoader {
    static Map<String, DirectoryClassLoader> loaders = Collections.synchronizedMap(new HashMap());
    URLClassLoader classLoader;
    private File directory;
    Map<String, File> prec = new HashMap<String, File>();
    private Logger classLoaderLogger;
    ClassLoader parent;

    public static DirectoryClassLoader getLoader(ClassLoader parent, String directory, Logger logger) throws Exception {
        DirectoryClassLoader dcl = loaders.get(directory);
        if (dcl == null) {
            dcl = new DirectoryClassLoader(parent, new File(directory), logger);
            loaders.put(directory, dcl);
        }
        return dcl;
    }

    private void init(File directory) throws Exception {
        this.directory = directory;
        File log = new File(directory, "log");
        log.mkdirs();
        this.classLoaderLogger.info(Messages.getString("DirectoryClassLoader.0") + directory.getAbsolutePath());
    }

    public DirectoryClassLoader(ClassLoader parent, File directory, Logger logger) throws Exception {
        this.classLoaderLogger = logger;
        this.parent = parent;
        this.init(directory);
    }

    private void initUrlClassLoader() throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        HashMap<String, File> actual = new HashMap<String, File>();
        int difcount = 0;
        File[] fileArray = this.directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                this.classLoaderLogger.info("initUrlClassLoader: file: " + file.getName() + Messages.getString("DirectoryClassLoader.1"));
                File old = this.prec.get(file.getName());
                if (old == null || file.compareTo(old) != 0) {
                    if (old == null) {
                        this.classLoaderLogger.info("initUrlClassLoader: file: " + file.getName() + Messages.getString("DirectoryClassLoader.2"));
                    } else {
                        this.classLoaderLogger.info("initUrlClassLoader: file: " + file.getName() + Messages.getString("DirectoryClassLoader.3"));
                    }
                    ++difcount;
                }
                Object scheme = "file://";
                if (!this.directory.getAbsolutePath().startsWith("/")) {
                    scheme = (String)scheme + "/";
                }
                URL url = new URL((String)scheme + this.directory.getAbsolutePath() + "/" + file.getName());
                this.classLoaderLogger.info("initUrlClassLoader: addUrl: " + url.toString());
                list.add(url);
                actual.put(file.getName(), file);
            }
            ++n2;
        }
        if (actual.size() == 0) {
            this.classLoaderLogger.info(Messages.getString("DirectoryClassLoader.4"));
        }
        if (actual.size() < this.prec.size()) {
            for (String key : this.prec.keySet()) {
                if (actual.get(key) != null) continue;
                this.classLoaderLogger.info("initUrlClassLoader: file: " + key + Messages.getString("DirectoryClassLoader.5"));
            }
        }
        if (this.classLoader == null || difcount > 0 || !this.prec.keySet().containsAll(actual.keySet())) {
            this.classLoader = new URLClassLoader(list.toArray(new URL[list.size()]), this.getParent());
            this.classLoaderLogger.info(Messages.getString("DirectoryClassLoader.6"));
        }
        this.prec = actual;
    }

    private ClassLoader getParent() {
        return this.parent;
    }

    @Override
    public Class loadClass(String className) throws ClassNotFoundException {
        try {
            this.classLoaderLogger.info("loadClass: " + className);
            this.initUrlClassLoader();
            this.classLoaderLogger.info("loadClass: " + className + Messages.getString("DirectoryClassLoader.7"));
        }
        catch (MalformedURLException e) {
            this.classLoaderLogger.error("loadClass: " + className, (Throwable)e);
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            this.classLoaderLogger.error("loadClass: " + className, (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception, ClassNotFoundException {
    }
}

