/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common.objects2;

import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import com.indy.engine.core.common.objects2.Messages;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EngineScheduleDetail
implements IEngineScheduleDetail {
    public static final int SCHEDULE_TYPE_CRON_EXPRESSION = 1;
    public static final int SCHEDULE_TYPE_SIMPLE_TRIGGER = 2;
    private Date startTime = null;
    private Date endTime = null;
    private int repeatCount = 0;
    private long repeatInterval = 0L;
    private String cronExpression;
    private int executionType = 0;
    private Date nextExecution = null;
    private String jobName;
    private String triggerName;
    private String sessionName;
    private String purgeUnit;
    private String purgeSize;
    private String deliveryName;
    private Map<String, Object> mapParameters;
    private String triggerState;
    private Date lastExecution;
    private Integer port;
    private String host;
    private String configuration;
    private String scheduleName;
    private String logLevel;

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    @Override
    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    @Override
    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    @Override
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @Override
    public int getExecutionType() {
        return this.executionType;
    }

    @Override
    public void setExecutionType(int executionType) {
        this.executionType = executionType;
    }

    @Override
    public Date getNextExecution() {
        return this.nextExecution;
    }

    @Override
    public void setNextExecution(Date nextExecution) {
        this.nextExecution = nextExecution;
    }

    @Override
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public EngineScheduleDetail(Map<String, Object> map) {
        this.endTime = (Date)map.get("endTime");
        this.startTime = (Date)map.get("startTime");
        this.repeatCount = (Integer)map.get("repeatCount");
        this.repeatInterval = this.getLong(map.get("repeatInterval"));
        this.cronExpression = (String)map.get("cronExpression");
        this.executionType = (Integer)map.get("executionType");
        this.nextExecution = (Date)map.get("nextExecution");
        this.jobName = (String)map.get("jobName");
        this.triggerName = (String)map.get("triggerName");
        this.sessionName = (String)map.get("sessionName");
        this.purgeSize = (String)map.get("purgeSize");
        this.purgeUnit = (String)map.get("purgeUnit");
        this.deliveryName = (String)map.get("deliveryName");
        this.triggerState = (String)map.get("triggerState");
        this.lastExecution = (Date)map.get("lastExecution");
        this.host = (String)map.get("host");
        this.port = (Integer)map.get("port");
        this.configuration = (String)map.get("configuration");
        this.mapParameters = (Map)map.get("mapParameters");
        this.scheduleName = (String)map.get("scheduleName");
        this.logLevel = (String)map.get("logLevel");
    }

    public EngineScheduleDetail(int pExecutionType) {
        this.executionType = pExecutionType;
    }

    public String printString() {
        Object ret = "";
        if (this.cronExpression != null) {
            if (this.deliveryName != null && !this.deliveryName.isEmpty()) {
                ret = (String)ret + "-- Delivery Name:   " + this.deliveryName + "\n";
            }
            if (this.scheduleName != null && !this.scheduleName.isEmpty()) {
                ret = (String)ret + "-- Schedule Name:   " + this.scheduleName + "\n";
            }
            ret = (String)ret + "-- Trigger Name: " + this.getTriggerName() + "\n";
            ret = (String)ret + "-- Job Name: " + this.getJobName() + "\n";
            if (this.configuration != null) {
                ret = (String)ret + "-- Configuration: " + this.configuration + "\n";
            }
            if (this.sessionName != null) {
                ret = (String)ret + "-- Session Name: " + this.sessionName + "\n";
            }
            ret = (String)ret + "-- Cron Execution Type: ";
            if (this.executionType == 1) {
                ret = (String)ret + "Memory Mode \n";
            } else if (this.executionType == 2) {
                ret = (String)ret + "Command Line Mode \n";
            }
            try {
                ret = (String)ret + "Start time :        " + (this.startTime == null ? "NULL" : this.startTime.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ret = (String)ret + "End time:          " + (this.endTime == null ? "NULL" : this.endTime.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret = (String)ret + "Cron expression:   '" + this.cronExpression + "'\n";
            try {
                ret = (String)ret + "Next time :        " + (this.nextExecution == null ? "NULL" : this.nextExecution.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ret = (String)ret + "Last time :        " + (this.lastExecution == null ? "NULL" : this.lastExecution.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ret = (String)ret + "Trigger state :        " + (this.triggerState == null ? "NULL" : this.triggerState) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.host != null) {
                ret = (String)ret + "Remote Host : " + this.host + "\n";
            }
            if (this.port != null) {
                ret = (String)ret + "Remote Port : " + String.valueOf(this.port) + "\n";
            }
        } else {
            ret = (String)ret + "-- Simple Execution Type\n";
            try {
                ret = (String)ret + "Start time :        " + (this.startTime == null ? "NULL" : this.startTime.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ret = (String)ret + "End time :          " + (this.endTime == null ? "NULL" : this.endTime.toString()) + "\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret = (String)ret + "Repeat count :      " + String.valueOf(this.repeatCount) + "\n";
            ret = (String)ret + "Repeat interval :   " + String.valueOf(this.repeatInterval) + "\n";
        }
        if (this.purgeSize != null && !this.purgeSize.isEmpty()) {
            ret = (String)ret + "Purge size:   " + this.purgeSize + "\n";
        }
        if (this.purgeUnit != null && !this.purgeUnit.isEmpty()) {
            ret = (String)ret + "Purge unit:   " + this.purgeUnit + "\n";
        }
        if (this.logLevel != null) {
            ret = (String)ret + "Log Level :\t\t" + this.logLevel + "\n";
        }
        if (this.mapParameters != null && !this.mapParameters.isEmpty()) {
            ret = (String)ret + "-- Parameters\n";
            ret = (String)ret + this.mapParameters.toString();
        }
        return ret;
    }

    public String toString() {
        return this.printString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.endTime != null) {
            map.put("endTime", this.endTime);
        }
        if (this.cronExpression != null) {
            map.put("cronExpression", this.cronExpression);
        }
        map.put("executionType", this.executionType);
        if (this.nextExecution != null) {
            map.put("nextExecution", this.nextExecution);
        }
        if (this.lastExecution != null) {
            map.put("lastExecution", this.lastExecution);
        }
        map.put("repeatCount", this.repeatCount);
        map.put("repeatInterval", this.repeatInterval);
        if (this.startTime != null) {
            map.put("startTime", this.startTime);
        }
        if (this.jobName != null) {
            map.put("jobName", this.jobName);
        }
        if (this.triggerName != null) {
            map.put("triggerName", this.triggerName);
        }
        if (this.sessionName != null) {
            map.put("sessionName", this.sessionName);
        }
        if (this.purgeSize != null) {
            map.put("purgeSize", this.purgeSize);
        }
        if (this.purgeUnit != null) {
            map.put("purgeUnit", this.purgeUnit);
        }
        if (this.deliveryName != null) {
            map.put("deliveryName", this.deliveryName);
        }
        if (this.mapParameters != null) {
            map.put("mapParameters", this.mapParameters);
        }
        if (this.triggerState != null) {
            map.put("triggerState", this.triggerState);
        }
        if (this.host != null) {
            map.put("host", this.host);
        }
        if (this.port != null) {
            map.put("port", this.port);
        }
        if (this.configuration != null) {
            map.put("configuration", this.configuration);
        }
        if (this.scheduleName != null) {
            map.put("scheduleName", this.scheduleName);
        }
        if (this.logLevel != null) {
            map.put("logLevel", this.logLevel);
        }
        return map;
    }

    public static IEngineScheduleDetail getEngineScheduleDetail(Map<String, Object> triggerDetail) {
        if (triggerDetail != null) {
            return new EngineScheduleDetail(triggerDetail);
        }
        return null;
    }

    public static List<IEngineScheduleDetail> getEngineScheduleDetailList(List<Map<String, Object>> lstSchedules) {
        return null;
    }

    public static List<IEngineScheduleDetail> getVariableMap(List<Map<String, Object>> list) {
        if (list != null) {
            return new ArrayList(list){

                @Override
                public Object get(int i) {
                    Object sessI = super.get(i);
                    if (sessI instanceof IEngineScheduleDetail) {
                        return sessI;
                    }
                    IEngineScheduleDetail var = EngineScheduleDetail.getEngineScheduleDetail((Map)sessI);
                    if (var != null) {
                        super.add(var);
                    }
                    return var;
                }
            };
        }
        return null;
    }

    @Override
    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    @Override
    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    @Override
    public String getPurgeUnit() {
        return this.purgeUnit;
    }

    @Override
    public void setPurgeUnit(String unit) {
        this.purgeUnit = unit;
    }

    @Override
    public String getPurgeSize() {
        return this.purgeSize;
    }

    @Override
    public void setPurgeSize(String size) {
        this.purgeSize = size;
    }

    @Override
    public String getDeliveryName() {
        return this.deliveryName;
    }

    @Override
    public void setDeliveryName(String delivery) {
        this.deliveryName = delivery;
    }

    @Override
    public Map<String, Object> getMapParameters() {
        return this.mapParameters;
    }

    @Override
    public void setMapParameters(Map<String, Object> mapP) {
        this.mapParameters = mapP;
    }

    @Override
    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    @Override
    public String getTriggerState() {
        return this.triggerState;
    }

    @Override
    public Date getLastExecution() {
        return this.lastExecution;
    }

    @Override
    public void setLastExecution(Date lastExecution) {
        this.lastExecution = lastExecution;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void setConfiguration(String conf) {
        this.configuration = conf;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getScheduleName() {
        return this.scheduleName;
    }

    @Override
    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    private Long getLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        throw new NumberFormatException(Messages.getString("EngineScheduleDetail.0"));
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }
}

