/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.main.action.variable;

import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.objects2.Variable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VariableContainer {
    long cumulVar = 0L;
    long cumulStat = 0L;
    long cumulAggr = 0L;
    String containerName;
    String containerPath;
    private final Logger logger = LogManager.getLogger(VariableContainer.class);
    VariableContainer parent;
    Map<String, VariableContainer> containers = new ConcurrentHashMap<String, VariableContainer>();
    Map<String, Variable> variables = new ConcurrentHashMap<String, Variable>();
    Map<String, Variable> numericVariables = new ConcurrentHashMap<String, Variable>();
    VariableContainer root;
    Object lock = new Object();
    Map<String, AggregateNumeric> aggregates = new ConcurrentHashMap<String, AggregateNumeric>();
    Variable.VariableListener variableListener = new Variable.VariableListener(){

        @Override
        public void variableChanged(Variable var, long value, long oldValue, boolean update) {
            if (var.getValue() != null) {
                VariableContainer.this.updateAggregate(var.getShortName(), var.getType(), value, oldValue, update ? 1 : 0);
            }
        }

        @Override
        public boolean isDisposed() {
            return VariableContainer.this.isDisposed;
        }
    };
    boolean isDisposed = false;

    public String getContainerPath() {
        return this.containerPath;
    }

    public VariableContainer(String containerName, VariableContainer parent) {
        this.containerName = containerName;
        this.parent = parent;
        this.root = parent == null ? this : parent.getRootContainer();
        this.containerPath = parent != null ? parent.getContainerPath() + containerName + "/" : "";
    }

    public Map<String, Variable> findAllVariable(Selector selector) {
        HashMap<String, Variable> result = new HashMap<String, Variable>();
        for (Variable variable : this.variables.values()) {
            String key = selector.selectReturnKey(variable);
            if (key != null && key.isEmpty()) {
                key = variable.getName();
            }
            if (key == null) continue;
            result.put(key, variable);
        }
        for (VariableContainer container : this.containers.values()) {
            result.putAll(container.findAllVariable(selector));
        }
        return result;
    }

    public void scanLocalVariable(Scaner scaner) throws EngineExceptionI {
        for (Variable variable : this.variables.values()) {
            scaner.scan(variable);
        }
    }

    public void scanAllVariable(Scaner scaner) throws EngineExceptionI {
        for (Variable variable : this.variables.values()) {
            scaner.scan(variable);
        }
        for (VariableContainer container : this.containers.values()) {
            container.scanAllVariable(scaner);
        }
    }

    public Variable getLocalVariable(String name) {
        if (this.variables != null) {
            Variable v = this.variables.get(name);
            if (v == null && name != null && name.startsWith("CORE_HTTP_REQUEST_HEADER_")) {
                return this.variables.get(name.toUpperCase());
            }
            return v;
        }
        return null;
    }

    public VariableContainer getRootContainer() {
        return this.root;
    }

    private void addLocalVariable(Variable var, boolean updateExeIfExists) {
        Variable existsVar = null;
        if (!updateExeIfExists) {
            existsVar = this.variables.get(var.getShortName());
            if (existsVar != null) {
                if (existsVar.getVariablePublicationMode() == VariablePublicationMode.STATIC) {
                    existsVar.setOriginalSourceModified(true);
                }
                existsVar.setValue(var.getValue());
                var = existsVar;
            }
        } else {
            this.removeLocalVariable(var.getShortName());
        }
        this.variables.put(var.getShortName(), var);
        if (var.isNumeric() && !var.isCore()) {
            this.numericVariables.put(var.getShortName(), var);
            var.setVariableListener(this.variableListener);
        }
    }

    public void addVariable(Variable v) {
        this.addVariable(v, false);
    }

    public void addVariable(Variable var, boolean updateExeIfExists) {
        VariableContainer container = this.getRootContainer().getVariableContainer(var.getName());
        if (container != null) {
            container.addLocalVariable(var, updateExeIfExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAggregate(String name, String type, long value, long oldValue, int mode) {
        boolean changed = false;
        Map<String, AggregateNumeric> map = this.aggregates;
        synchronized (map) {
            if (mode < 2) {
                AggregateNumeric aggr = this.aggregates.get(name);
                if (aggr == null) {
                    aggr = new AggregateNumeric(name, type);
                    aggr.addValue(value);
                    this.aggregates.put(name, aggr);
                    changed = true;
                } else if (value != oldValue) {
                    if (mode == 1) {
                        aggr.removeValue(oldValue);
                    }
                    aggr.addValue(value);
                    changed = true;
                }
            } else {
                AggregateNumeric aggr = this.aggregates.get(name);
                if (aggr != null) {
                    aggr.removeValue(oldValue);
                }
                changed = true;
            }
        }
        if (changed && this.parent != null) {
            this.parent.updateAggregate(name, type, value, oldValue, mode);
        }
    }

    private String[] split(String var) {
        if (var != null && var.length() > 0) {
            String internalVar = var;
            if (var.startsWith("/")) {
                if (var.length() > 1) {
                    internalVar = var.substring(1);
                } else {
                    return new String[0];
                }
            }
            return internalVar.split("/");
        }
        return new String[0];
    }

    private VariableContainer getVariableContainer(String varPath) {
        String[] parts = this.split(varPath);
        return this.getContainer(parts, 0, 0);
    }

    public VariableContainer getActionVariableContainer(String actPath) {
        String[] parts = this.split(actPath);
        return this.getContainer(parts, 0, 1);
    }

    private VariableContainer getContainer(String[] parts, int index, int stop) {
        if (parts.length + stop <= index + 1) {
            return this;
        }
        String localName = null;
        try {
            localName = parts[index];
        }
        catch (Exception e) {
            this.logger.warn("Error while getting container", (Throwable)e);
        }
        VariableContainer vc = null;
        vc = this.containers.computeIfAbsent(localName, n -> new VariableContainer((String)n, this));
        return vc.getContainer(parts, index + 1, stop);
    }

    public Variable getAbsolutVariable(String name) {
        return this.getRootContainer().getRelativeVariable(name);
    }

    public Variable getRelativeVariable(String varName) {
        String[] parts = this.split(varName);
        VariableContainer container = this.getContainer(parts, 0, 0);
        if (container.variables != null) {
            return container.getLocalVariable(parts[parts.length - 1]);
        }
        return null;
    }

    public Map<String, Variable> getAllCopiedLocalVariables(Selector selector) {
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        for (Variable variable : this.variables.values()) {
            String key = variable.getName();
            if (selector != null && (key = selector.selectReturnKey(variable)) != null && key.isEmpty()) {
                key = variable.getName();
            }
            if (key == null) continue;
            map.put(key, variable);
        }
        return map;
    }

    public void evaluateAllVariable(Evaluator evaluator) throws EngineExceptionI {
        ArrayList<Variable> list = new ArrayList<Variable>(this.variables.values());
        if (this.aggregates.size() > 0) {
            for (AggregateNumeric aggr : this.aggregates.values()) {
                aggr.resetCurrent();
            }
        }
        for (Variable var : list) {
            String varSource = var.getSource();
            if (varSource == null) continue;
            String varExpr = evaluator.evaluate(varSource);
            var.setValueOnly(varExpr, false);
        }
    }

    public Map<String, AggregateNumeric> aggregateNumeric(AggregateSelector selector) {
        HashMap<String, AggregateNumeric> map = new HashMap<String, AggregateNumeric>();
        for (AggregateNumeric aggr : this.aggregates.values()) {
            if (selector != null && !selector.select(this, aggr)) continue;
            map.put(aggr.name, aggr);
        }
        return map;
    }

    public Map<String, Variable> getAllCopiedVariables(Selector selector) {
        HashMap<String, Variable> map = new HashMap<String, Variable>(this.getAllCopiedLocalVariables(selector));
        for (VariableContainer container : this.containers.values()) {
            map.putAll(container.getAllCopiedVariables(selector));
        }
        return map;
    }

    public void clear() throws Exception {
        if (!this.isDisposed) {
            for (Variable var : this.variables.values()) {
                var.clear();
            }
            this.variables.clear();
            this.numericVariables.clear();
            for (VariableContainer container : this.containers.values()) {
                container.clear();
            }
            this.containers.clear();
            this.parent = null;
            this.aggregates.clear();
            this.isDisposed = true;
            this.variableListener = null;
        }
    }

    public void removeAbsolutVariable(String varName) {
        this.getRootContainer().removeRelativeVariable(varName);
    }

    public void removeRelativeVariable(String varName) {
        String[] parts = this.split(varName);
        VariableContainer container = this.getContainer(parts, 0, 0);
        container.removeLocalVariable(parts[parts.length - 1]);
    }

    private void removeLocalVariable(String localName) {
        Variable old = this.variables.get(localName);
        if (old == null && localName != null && localName.startsWith("CORE_HTTP_REQUEST_HEADER_")) {
            old = this.variables.get(localName.toUpperCase());
        }
        if (old != null) {
            if (old.isNumeric()) {
                this.updateAggregate(old.getName(), null, 0L, old.getLongValue(), 2);
            }
            try {
                old.clear();
            }
            catch (Exception e) {
                this.logger.warn("Error on clear variable", (Throwable)e);
            }
        }
        this.variables.remove(localName);
        if (this.numericVariables != null) {
            this.numericVariables.remove(localName);
        }
    }

    public Variable addLocalVariable(String pName, Object pValue, String pType, boolean isRealTimeReport, boolean isCumulative, boolean replace) {
        String currentType;
        String currentValue;
        Variable var = this.getLocalVariable(pName);
        if (var != null && !replace) {
            return null;
        }
        String string = currentValue = pValue != null ? pValue.toString() : null;
        String string2 = pType != null ? pType : (currentType = pValue != null ? pValue.getClass().getSimpleName() : "String");
        if (var == null) {
            var = new Variable(this.containerPath + pName, currentValue, currentType, isRealTimeReport, isCumulative);
            this.addLocalVariable(var, false);
        } else {
            var.setValue(currentValue, isCumulative);
            var.setRealTimeReport(isRealTimeReport);
            var.setType(currentType);
        }
        return var;
    }

    public class AggregateNumeric {
        AggregateNumeric current;
        boolean isLeaf = false;
        String name;
        int count = 0;
        String type;
        long maxValue = 0L;
        long minValue = 0L;
        long sumValue = 0L;
        boolean localIsSet = false;
        long localValue = 0L;

        public AggregateNumeric(String shortName, String type) {
            this.name = shortName;
            this.type = type;
        }

        public AggregateNumeric getCurrent() {
            if (this.current == null) {
                return this;
            }
            return this.current;
        }

        public void resetCurrent() {
            this.current = new AggregateNumeric(this.getName(), this.getType());
        }

        public void addValue(long addValue) {
            if (this.current != null) {
                this.current.addValue(addValue - this.localValue);
            }
            ++this.count;
            this.sumValue += addValue;
            if (this.minValue > addValue) {
                this.minValue = addValue;
            }
            if (this.maxValue < addValue) {
                this.maxValue = addValue;
            }
            this.localValue = addValue;
            this.localIsSet = true;
        }

        public void removeValue(long value) {
            this.sumValue -= value;
            if (this.current != null) {
                this.current.removeValue(value - this.localValue);
            }
        }

        public String getName() {
            return this.name;
        }

        public long getSum() {
            return this.sumValue;
        }

        public long getAvg() {
            return this.sumValue / (long)this.count;
        }

        public int getCount() {
            return this.count;
        }

        public long getMin() {
            return this.minValue;
        }

        public long getMax() {
            return this.maxValue;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "AggregateNumeric [current=" + String.valueOf(this.current) + ", isLeaf=" + this.isLeaf + ", name=" + this.name + ", count=" + this.count + ", type=" + this.type + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", sumValue=" + this.sumValue + ", localIsSet=" + this.localIsSet + ", localValue=" + this.localValue + "]";
        }
    }

    public static interface AggregateSelector {
        public boolean select(VariableContainer var1, AggregateNumeric var2);
    }

    public static interface Evaluator {
        public String evaluate(String var1) throws EngineExceptionI;
    }

    public static interface Scaner {
        public void scan(Variable var1) throws EngineExceptionI;
    }

    public static interface Selector {
        public String selectReturnKey(Variable var1);
    }
}

