/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.main.connections.impl;

import com.indy.engine.core.main.connections.RuntimeConnection;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultRuntimeDataSource<T>
implements RuntimeDatasource<T> {
    public final Logger logger = LogManager.getLogger((String)"com.indy.engine");
    private Map<String, RuntimeConnection<T>> connectionMap = new ConcurrentHashMap<String, RuntimeConnection<T>>();
    private final Function<String, RuntimeConnection<T>> computeMapFunction;

    public DefaultRuntimeDataSource(Function<String, RuntimeConnection<T>> computeMapFunction) {
        this.computeMapFunction = computeMapFunction;
    }

    @Override
    public final RuntimeConnection<T> getConnection(String name) throws EngineExceptionI {
        try {
            return this.connectionMap.computeIfAbsent(name, this.computeMapFunction);
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof EngineExceptionI) {
                throw (EngineExceptionI)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void close(boolean commit) throws EngineExceptionI {
        for (RuntimeConnection<T> c : this.connectionMap.values()) {
            try {
                c.close(commit);
            }
            catch (Exception exception) {
                this.logger.warn("Exception while closing connection", (Throwable)exception);
            }
        }
    }
}

