/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.file;

import com.indy.runtime.file.DelimitedFileWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DelimitedFileReader {
    String stringDelimiter = "\"";
    String stringDelimiterReplacment = "\"\"";
    String rowSeparator = "\n";
    String rowSeparatorReplacment = null;
    String fieldSeparator = ",";
    String stringNullReplacment = "";
    String stringEmptyReplacment = "";
    private Reader reader;
    boolean recordEnded = true;
    int numField;
    int numLine;
    long fileSize;
    int position = -1;
    int currentSize;
    char[] buffer = new char[8192];
    boolean endOfFile = false;

    public void setStringDelimiter(String stringDelimiter, String stringDelimiterReplacment) {
        this.stringDelimiter = stringDelimiter;
        this.stringDelimiterReplacment = stringDelimiterReplacment;
    }

    public void setRowSeparator(String rowSeparator, String rowSeparatorReplacment) {
        this.rowSeparator = rowSeparator;
        this.rowSeparatorReplacment = rowSeparatorReplacment;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setStringNullReplacment(String stringNullReplacment) {
        this.stringNullReplacment = stringNullReplacment;
    }

    public void setStringEmptyReplacment(String stringEmptyReplacment) {
        this.stringEmptyReplacment = stringEmptyReplacment;
    }

    public DelimitedFileReader(InputStream is, String encoding) throws UnsupportedEncodingException {
        this.reader = new InputStreamReader(is, encoding);
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static void main(String[] args) throws IOException {
        Object str = "toto,titi\n";
        str = (String)str + "titi,tata\n";
        str = (String)str + "aaa\"titi\"\"\",\"tata\"\n\n\n";
        str = (String)str + "\" titi\"\"\",\"tata\",ddz\"kk\"ee,de\n";
        ByteArrayInputStream bais = new ByteArrayInputStream(((String)str).getBytes());
        DelimitedFileReader dfr = new DelimitedFileReader(bais, "UTF-8");
        while (!dfr.isEndOfFile()) {
            System.out.println(dfr.readLine());
        }
        DelimitedFileWriter dfw = new DelimitedFileWriter(new FileOutputStream("d:/temp/test.txt"));
        int i = 0;
        while (i < 1000) {
            dfw.writeString("test");
            dfw.writeString("test");
            dfw.writeString("test");
            dfw.writeString("test");
            dfw.endRecord();
            ++i;
        }
        dfw.close();
        DelimitedFileWriter dfw2 = new DelimitedFileWriter(new FileOutputStream("d:/temp/test2.txt"));
        DelimitedFileReader dfr2 = new DelimitedFileReader(new FileInputStream("d:/temp/test.txt"), "UTF8");
        while (!dfr2.isEndOfFile()) {
            List<String> list = dfr2.readLine();
            for (String field : list) {
                dfw2.writeString(field);
            }
            System.out.println(list);
            dfw2.endRecord();
        }
        dfw2.close();
    }

    private char read() throws IOException {
        if (this.position == -1) {
            this.currentSize = this.reader.read(this.buffer);
            if (this.currentSize == -1) {
                this.endOfFile = true;
                return '\uffff';
            }
            this.position = 0;
        } else if (this.position == this.currentSize - 1) {
            if (this.currentSize < this.buffer.length) {
                this.endOfFile = true;
                return '\uffff';
            }
            this.currentSize = this.reader.read(this.buffer);
            if (this.currentSize == -1) {
                this.endOfFile = true;
                return '\uffff';
            }
            this.position = 0;
        } else {
            ++this.position;
        }
        return this.buffer[this.position];
    }

    private boolean endsWith(StringBuffer sb, char[] st) {
        int size2 = st.length;
        int size = sb.length();
        if (size2 > size) {
            return false;
        }
        char c = sb.charAt(size - 1);
        if (c != st[st.length - 1]) {
            return false;
        }
        int i = 0;
        while (i < st.length) {
            if (sb.charAt(size - size2 + i) != st[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<String> readLine() throws IOException {
        ArrayList<String> fields;
        block12: {
            String str;
            StringBuffer sb = new StringBuffer();
            char[] fieldSep = this.fieldSeparator.toCharArray();
            char[] rowSep = this.rowSeparator.toCharArray();
            char[] stringSep = this.stringDelimiter.toCharArray();
            int mode = 1;
            boolean currentRowSepMode = false;
            fields = new ArrayList<String>();
            while (true) {
                char c = this.read();
                if (!this.endOfFile) {
                    sb.append(c);
                }
                if (mode == 1) {
                    int i;
                    if (this.endOfFile) {
                        str = sb.toString();
                        if (currentRowSepMode) {
                            i = str.lastIndexOf(this.stringDelimiter);
                            str = str.substring(0, i);
                            str = str.replace(this.stringDelimiterReplacment, this.stringDelimiter);
                        }
                        fields.add(str);
                        break block12;
                    }
                    if (this.endsWith(sb, fieldSep)) {
                        str = sb.substring(0, sb.length() - fieldSep.length);
                        if (currentRowSepMode) {
                            i = str.lastIndexOf(this.stringDelimiter);
                            str = str.substring(0, i);
                            str = str.replace(this.stringDelimiterReplacment, this.stringDelimiter);
                        }
                        fields.add(str);
                        sb = new StringBuffer();
                        currentRowSepMode = false;
                        continue;
                    }
                    if (this.endsWith(sb, rowSep)) {
                        str = sb.substring(0, sb.length() - rowSep.length);
                        if (currentRowSepMode) {
                            i = str.lastIndexOf(this.stringDelimiter);
                            str = str.substring(0, i);
                            str = str.replace(this.stringDelimiterReplacment, this.stringDelimiter);
                        }
                        fields.add(str);
                        break block12;
                    }
                    if (!this.endsWith(sb, stringSep)) continue;
                    if (!currentRowSepMode) {
                        currentRowSepMode = true;
                        sb = new StringBuffer();
                    }
                    mode = 2;
                    continue;
                }
                if (mode != 2) continue;
                if (this.endsWith(sb, stringSep)) {
                    mode = 1;
                    continue;
                }
                if (this.endOfFile) break;
            }
            str = sb.toString();
            fields.add(str);
        }
        if (fields.size() == 1 && ((String)fields.get(0)).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return fields;
    }

    public boolean isEndOfFile() {
        return this.endOfFile;
    }
}

