/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.hierarchy;

import com.indy.engine.core.UtilsService;
import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.IXMLConverter;
import com.indy.runtime.hierarchy.Messages;
import com.indy.runtime.hierarchy.event.EndElementEvent;
import com.indy.runtime.hierarchy.event.StartElementEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.xml.AbstractXMLEventReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public abstract class HierarchyEventReader {
    final XMLEventFactory eventFactory = XMLEventFactory.newFactory();
    Deque<HierarchyEvent> containerStack = new ArrayDeque<HierarchyEvent>();
    List<XMLEvent> xmlEventStack = new ArrayList<XMLEvent>();

    public abstract HierarchyEvent nextHierarchyEvent() throws Exception;

    void fill(StartElementEvent event, boolean isRoot, IXMLConverter converter) throws Exception {
        Attribute attr;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String data = null;
        if (event.getType() != Integer.MIN_VALUE) {
            attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, converter.getTypeName(event.getType()));
            attributes.add(attr);
        }
        if (event.isNull()) {
            attr = this.eventFactory.createAttribute(JsonConstants.XML_NIL, "true");
            attributes.add(attr);
        } else if (event.getStringData() != null) {
            data = event.getStringData();
        } else if (event.getData() != null) {
            data = converter.printData(event.getType(), event.getData());
        }
        this.xmlEventStack.add(this.eventFactory.createStartElement("", null, event.name, attributes.iterator(), Collections.EMPTY_LIST.iterator()));
        if (data != null) {
            this.xmlEventStack.add(this.eventFactory.createCharacters(UtilsService.getXmlUtils().escapeXML(data)));
        }
        if (isRoot) {
            this.xmlEventStack.add(this.eventFactory.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        }
    }

    protected HierarchyEventReader() {
    }

    void fill(EndElementEvent event) {
        this.xmlEventStack.add(this.eventFactory.createEndElement("", null, event.name));
    }

    public XMLEventReader creatXMLEventReader(final IXMLConverter converter) throws Exception {
        return new AbstractXMLEventReader(){

            @Override
            protected XMLEvent doNextEvent() throws XMLStreamException {
                HierarchyEvent next;
                if (!HierarchyEventReader.this.xmlEventStack.isEmpty()) {
                    return HierarchyEventReader.this.xmlEventStack.remove(0);
                }
                try {
                    next = HierarchyEventReader.this.nextHierarchyEvent();
                }
                catch (Exception e) {
                    throw new XMLStreamException(e);
                }
                if (next == null) {
                    return null;
                }
                if (next.isStartElementEvent()) {
                    try {
                        HierarchyEventReader.this.fill(next.asStartElementEvent(), HierarchyEventReader.this.containerStack.isEmpty(), converter);
                    }
                    catch (Exception e) {
                        throw new XMLStreamException(e);
                    }
                    HierarchyEventReader.this.containerStack.push(next);
                } else if (next.isEndElementEvent()) {
                    StartElementEvent e = HierarchyEventReader.this.containerStack.pop().asStartElementEvent();
                    if (!HierarchyEvent.objectEquals(e.name, next.asEndElementEvent().name)) {
                        throw new XMLStreamException(Messages.getString("HierarchyEventReader.4"));
                    }
                    HierarchyEventReader.this.fill(next.asEndElementEvent());
                } else if (next.isStartDocumentEvent()) {
                    HierarchyEventReader.this.xmlEventStack.add(HierarchyEventReader.this.eventFactory.createStartDocument());
                } else if (next.isEndDocumentEvent()) {
                    HierarchyEventReader.this.xmlEventStack.add(HierarchyEventReader.this.eventFactory.createEndDocument());
                }
                if (!HierarchyEventReader.this.xmlEventStack.isEmpty()) {
                    return HierarchyEventReader.this.xmlEventStack.remove(0);
                }
                return null;
            }

            @Override
            public void close() throws XMLStreamException {
                HierarchyEventReader.this.close();
            }
        };
    }

    public abstract void close() throws XMLStreamException;
}

