/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.json.annotation.DateFormatter;
import com.indy.engine.core.json.annotation.JsonElement;
import com.indy.engine.core.json.annotation.JsonTypeElement;
import com.indy.runtime.json.internal.JsonNodeToObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenericObjectDeserializer {
    private GenericObjectDeserializer() {
    }

    private static boolean isTypeAnnotated(Field field) {
        return field.getDeclaringClass().isAnnotationPresent(JsonTypeElement.class);
    }

    private static boolean shouldSerialize(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null && !je.deserialiazeOnly() || GenericObjectDeserializer.isTypeAnnotated(field);
    }

    private static boolean shouldDeserialize(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null && !je.serialiazeOnly() || GenericObjectDeserializer.isTypeAnnotated(field);
    }

    private static String getJsonName(Field field) {
        JsonElement je = field.getAnnotation(JsonElement.class);
        return je != null ? je.name() : field.getName();
    }

    public static Object serialize(Object v) throws Exception {
        return GenericObjectDeserializer.serialize(v, null);
    }

    private static Object serialize(Object v, Field currentField) throws Exception {
        if (v != null) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            Class<?> c = v.getClass();
            Field[] fieldArray = c.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (GenericObjectDeserializer.shouldSerialize(field)) {
                    GenericObjectDeserializer.serializeField(v, ret, field);
                }
                ++n2;
            }
            if (!ret.isEmpty()) {
                return ret;
            }
            if (c == Date.class && currentField != null && currentField.isAnnotationPresent(DateFormatter.class)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sssZ");
                return df.format(v);
            }
            return v;
        }
        return v;
    }

    private static void serializeField(Object v, Map<String, Object> ret, Field field) throws Exception {
        Object s;
        Object o = field.get(v);
        if (o == null) {
            s = null;
        } else if (o instanceof Map) {
            Map m = (Map)o;
            s = GenericObjectDeserializer.serializeMap(m);
        } else if (o instanceof List) {
            List l = (List)o;
            s = GenericObjectDeserializer.serializeList(l);
        } else if (o instanceof Iterator) {
            Iterator ait = (Iterator)o;
            s = GenericObjectDeserializer.serializeIterator(ait);
        } else {
            s = o.getClass().isEnum() ? o.toString() : (o instanceof IJsonUtils.Adapter ? o : GenericObjectDeserializer.serialize(o, field));
        }
        ret.put(GenericObjectDeserializer.getJsonName(field), s);
    }

    private static Object serializeIterator(Iterator<?> ait) {
        return ait;
    }

    private static Object serializeList(List<Object> l) throws Exception {
        ArrayList list = l instanceof JsonNodeToObject.IterativeValueArrayList ? new JsonNodeToObject.IterativeValueArrayList() : new ArrayList();
        for (Object entry : l) {
            list.add(GenericObjectDeserializer.serialize(entry));
        }
        return list;
    }

    private static Object serializeMap(Map<Object, Object> m) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : m.entrySet()) {
            map.put(GenericObjectDeserializer.serialize(entry.getKey()), GenericObjectDeserializer.serialize(entry.getValue()));
        }
        return map;
    }

    private static void setField(Field field, Object target, Object value) throws Exception {
        boolean isPrivate = !field.isAccessible();
        field.setAccessible(true);
        field.set(target, value);
        field.setAccessible(isPrivate);
    }

    public static Object deserialize(Class clazz, Object v) throws Exception {
        if (v instanceof Map) {
            Map map = (Map)v;
            Object targetObject = clazz.newInstance();
            Class c = clazz;
            if (c.equals(Object.class)) {
                return v;
            }
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                Field field = fieldArray[n2];
                if (GenericObjectDeserializer.shouldDeserialize(field) && (value = map.get(GenericObjectDeserializer.getJsonName(field))) != null) {
                    if (value instanceof Map) {
                        if (field.getType() == Map.class) {
                            Map map1 = (Map)value;
                            HashMap<Object, Object> map2 = new HashMap<Object, Object>();
                            ParameterizedType type = (ParameterizedType)field.getGenericType();
                            Type type1 = type.getActualTypeArguments()[0];
                            Type type2 = type.getActualTypeArguments()[1];
                            for (Map.Entry entry : map1.entrySet()) {
                                map2.put(GenericObjectDeserializer.deserialize((Class)type1, entry.getKey()), GenericObjectDeserializer.deserialize((Class)type2, entry.getValue()));
                            }
                            GenericObjectDeserializer.setField(field, targetObject, map2);
                        } else if (field.getType() == Object.class) {
                            field.set(targetObject, value);
                        } else {
                            GenericObjectDeserializer.setField(field, targetObject, GenericObjectDeserializer.deserialize(field.getType(), value));
                        }
                    } else if (value instanceof List) {
                        ArrayList list = value instanceof JsonNodeToObject.IterativeValueArrayList ? new JsonNodeToObject.IterativeValueArrayList() : new ArrayList();
                        GenericObjectDeserializer.setField(field, targetObject, list);
                        ParameterizedType type = (ParameterizedType)field.getGenericType();
                        Type type2 = type.getActualTypeArguments()[0];
                        for (Object o : (List)value) {
                            list.add(GenericObjectDeserializer.deserialize((Class)type2, o));
                        }
                    } else {
                        Object oo = null;
                        if (field.getType() == Date.class) {
                            if (field.isAnnotationPresent(DateFormatter.class)) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sssZ");
                                oo = df.parse((String)value);
                            }
                        } else {
                            oo = GenericObjectDeserializer.deserialize(field.getType(), value);
                        }
                        if (oo != null) {
                            if (field.getType() == List.class) {
                                List list = (List)field.get(targetObject);
                                if (list == null) {
                                    list = new JsonNodeToObject.IterativeValueArrayList();
                                    GenericObjectDeserializer.setField(field, targetObject, list);
                                }
                                list.add(oo);
                            } else {
                                GenericObjectDeserializer.setField(field, targetObject, oo);
                            }
                        }
                    }
                }
                ++n2;
            }
            return targetObject;
        }
        Class c = clazz;
        if (c.isEnum()) {
            Method method = clazz.getMethod("valueOf", String.class);
            return method.invoke(null, v);
        }
        if ((clazz == Boolean.TYPE || clazz == Boolean.class) && v instanceof String) {
            return Boolean.valueOf((String)v);
        }
        return v;
    }
}

