/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.Messages;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class JsonNodeImpl
extends JsonNode {
    JsonNodeImpl() {
    }

    @Override
    public boolean isObject() {
        return this instanceof JsonObject;
    }

    @Override
    public boolean isArray() {
        return this instanceof JsonArray;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String getString() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.0"));
    }

    @Override
    public Boolean getBoolean() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.1"));
    }

    @Override
    public Number getNumber() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.2"));
    }

    @Override
    public boolean isNull() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.3"));
    }

    @Override
    public Iterator getIterator() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.4"));
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("http://finance.yahoo.com/webservice/v1/symbols/allcurrencies/quote?format=json");
        JsonNode root = JsonNodeImpl.parse(url.openConnection().getInputStream(), "UTF-8");
        System.out.println(root);
        System.out.println(root.isString());
    }

    @Override
    public int length() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.7"));
    }

    @Override
    public JsonNode get(int position) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.8"));
    }

    @Override
    public boolean exists(String name) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.9"));
    }

    @Override
    public Collection<String> keys() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.10"));
    }

    @Override
    public JsonNode get(String name) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.11"));
    }

    @Override
    public boolean isNull(String name) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.12"));
    }

    @Override
    public boolean isNull(int position) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.13"));
    }

    @Override
    public void add(String name, JsonNode node) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.14"));
    }

    @Override
    public void setString(String value) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.15"));
    }

    @Override
    public void setNull() {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.16"));
    }

    @Override
    public void setBoolean(Boolean value) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.17"));
    }

    @Override
    public void setNumber(Number value) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.18"));
    }

    @Override
    public void add(JsonNode node) {
        throw new RuntimeException(Messages.getString("JsonNodeImpl.19"));
    }

    static class JsonArray
    extends JsonNodeImpl {
        List<JsonNode> nodes = new ArrayList<JsonNode>();

        JsonArray() {
        }

        @Override
        public Iterator getIterator() {
            return this.nodes.iterator();
        }

        @Override
        public boolean isNull() {
            throw new RuntimeException(Messages.getString("JsonNodeImpl.5"));
        }

        @Override
        public void add(JsonNode node) {
            this.nodes.add(node);
        }

        @Override
        public int length() {
            return this.nodes.size();
        }

        private JsonNode _get(int position) {
            boolean isNull = this.isNull(position);
            if (isNull) {
                throw new RuntimeException(position + Messages.getString("JsonNodeImpl.6"));
            }
            return this.nodes.get(position);
        }

        @Override
        public JsonNode get(int position) {
            JsonNode node = this._get(position);
            return node;
        }

        @Override
        public boolean isNull(int position) {
            JsonNode node = this.nodes.get(position);
            return node != null && node instanceof JsonValue && ((JsonValue)node).isNull();
        }

        public String toString() {
            Object tmp = "[";
            int i = 0;
            int size = this.nodes.size();
            int j = 0;
            while (j < this.nodes.size()) {
                JsonNode node = this.nodes.get(j);
                tmp = (String)tmp + "\n";
                tmp = (String)tmp + node.toString();
                if (++i < size) {
                    if (node.isArray() || node.isObject()) {
                        tmp = (String)tmp + "\n";
                    }
                    tmp = (String)tmp + ",";
                }
                ++j;
            }
            tmp = (String)tmp + "\n]";
            return tmp;
        }
    }

    static class JsonObject
    extends JsonArray {
        Map<String, JsonNode> index = new HashMap<String, JsonNode>();
        List<String> keys = new ArrayList<String>();

        JsonObject() {
        }

        @Override
        public void add(String name, JsonNode node) {
            super.add(node);
            this.keys.add(name);
            this.index.put(name, node);
        }

        @Override
        public Collection<String> keys() {
            return new ArrayList<String>(this.keys);
        }

        @Override
        public JsonNode get(String name) {
            return this.index.get(name);
        }

        @Override
        public boolean isNull(String name) {
            JsonNode node = this.index.get(name);
            return node != null && node instanceof JsonValue && ((JsonValue)node).isNull();
        }

        @Override
        public boolean exists(String name) {
            JsonNode node = this.index.get(name);
            return node != null;
        }

        @Override
        public String toString() {
            Object tmp = "{";
            int i = 0;
            int size = this.keys.size();
            for (String key : this.keys()) {
                JsonNode node = this.index.get(key);
                String memberName = key;
                tmp = (String)tmp + "\n";
                tmp = (String)tmp + "\"" + memberName + "\" : ";
                tmp = (String)tmp + node.toString();
                if (++i >= size) continue;
                if (node.isArray() || node.isObject()) {
                    tmp = (String)tmp + "\n";
                }
                tmp = (String)tmp + ",";
            }
            tmp = (String)tmp + "\n}";
            return tmp;
        }
    }

    static class JsonValue
    extends JsonNodeImpl {
        Object value;
        int type;

        JsonValue() {
        }

        @Override
        public String getString() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            if (this.value instanceof Boolean) {
                return String.valueOf(this.value);
            }
            if (this.value instanceof BigInteger) {
                return String.valueOf(((BigInteger)this.value).longValue());
            }
            if (this.value instanceof BigDecimal) {
                return String.valueOf(((BigDecimal)this.value).doubleValue());
            }
            return null;
        }

        public String toString() {
            Object tmp = "";
            tmp = this.value instanceof String ? (String)tmp + "\"" + String.valueOf(this.value) + "\"" : (this.value != null ? (String)tmp + this.getString() : (String)tmp + "null");
            return tmp;
        }

        @Override
        public Number getNumber() {
            if (this.value instanceof Number) {
                return (Number)this.value;
            }
            if (this.value instanceof String) {
                if (((String)this.value).contains(".")) {
                    return BigDecimal.valueOf(Double.valueOf((String)this.value));
                }
                return BigInteger.valueOf(Long.valueOf((String)this.value));
            }
            if (this.value instanceof Boolean) {
                return BigInteger.valueOf((Boolean)this.value != false ? 1 : 0);
            }
            return null;
        }

        @Override
        public Boolean getBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            if (this.value instanceof String) {
                return Boolean.valueOf((String)this.value);
            }
            if (this.value instanceof Number) {
                int i = ((Number)this.value).intValue();
                if (i > 0) {
                    return true;
                }
                return false;
            }
            return null;
        }

        @Override
        public boolean isNull() {
            return this.value == null;
        }

        @Override
        public boolean isString() {
            return this.value instanceof String;
        }

        @Override
        public boolean isNumber() {
            return this.value instanceof Number;
        }

        @Override
        public boolean isBoolean() {
            return this.value instanceof Boolean;
        }

        @Override
        public void setString(String value) {
            this.value = value;
        }

        @Override
        public void setNull() {
            this.value = null;
        }

        @Override
        public void setBoolean(Boolean value) {
            this.value = value;
        }

        @Override
        public void setNumber(Number value) {
            this.value = value;
        }
    }
}

