/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.engine.core.UtilsService;
import com.indy.runtime.json.JsonXmlEventReader;
import com.indy.runtime.json.Messages;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JsonXmlReader
implements XMLReader {
    JsonXmlEventReader.ArrayMode mode;
    private String rootName;
    private String arrayItemName;
    private final Logger logger = LogManager.getLogger(this.getClass());
    boolean bsonStyle;
    ContentHandler handler;

    public JsonXmlReader(JsonXmlEventReader.ArrayMode mode, String rootName, String arrayItemName) {
        this.mode = mode;
        this.rootName = rootName;
        this.arrayItemName = arrayItemName;
    }

    public JsonXmlReader() {
        this.mode = JsonXmlEventReader.ArrayMode.ARRAY_TAG;
        this.rootName = "root";
        this.arrayItemName = "e";
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String paramString) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String paramString) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setBsonStyle(boolean bsonStyle) {
        this.bsonStyle = bsonStyle;
    }

    @Override
    public void parse(InputSource paramInputSource) throws IOException, SAXException {
        JsonXmlEventReader jxer = null;
        try {
            try {
                InputStream is = paramInputSource.getByteStream();
                jxer = is != null ? new JsonXmlEventReader(is, paramInputSource.getEncoding()) : new JsonXmlEventReader(paramInputSource.getCharacterStream());
                jxer.setBsonStyle(this.bsonStyle);
                jxer.setArrayMode(this.mode);
                jxer.setArrayItemName(this.arrayItemName);
                jxer.setRootName(this.rootName);
                if (this.handler == null) {
                    throw new IOException(Messages.getString("JsonXmlReader.0"));
                }
                UtilsService.getXmlUtils().xmlReaderToContentHandler(jxer, this.handler);
            }
            catch (Exception ex) {
                throw new SAXException(Messages.getString("JsonXmlReader.1"), ex);
            }
        }
        finally {
            try {
                if (jxer != null) {
                    jxer.close();
                }
            }
            catch (XMLStreamException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler paramContentHandler) {
        this.handler = paramContentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler paramDTDHandler) {
    }

    @Override
    public void setEntityResolver(EntityResolver paramEntityResolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler paramErrorHandler) {
    }

    @Override
    public void setFeature(String paramString, boolean paramBoolean) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String paramString, Object paramObject) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

