/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json.internal;

import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.internal.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLArrayTransformer {
    XMLEvent currentEvent;
    XMLEvent nextEvent;
    XMLEventFactory eventFactory;
    public static final QName anonymous = new QName("http://www.stambia.com/2014/json", "anonymous");
    Path currentPath = new Path();
    Map<String, ArrayInfo> arrayIsOpen = new HashMap<String, ArrayInfo>();
    Set<String> disable = new HashSet<String>();
    LinkedList<QName> stack = new LinkedList();

    public XMLArrayTransformer() {
        try {
            this.eventFactory = XMLEventFactory.newFactory();
        }
        catch (NoSuchMethodError e) {
            this.eventFactory = XMLEventFactory.newInstance();
        }
    }

    private XMLEvent createVirtualStartArrayElement(QName qName, Attribute[] attrs) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attr = this.eventFactory.createAttribute(JsonConstants.JSON_ARRAY, "true");
        attributes.add(attr);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                attributes.add(attrs[i]);
                ++i;
            }
        }
        return this.eventFactory.createStartElement(qName, attributes.iterator(), Collections.EMPTY_LIST.iterator());
    }

    private XMLEvent createAnonymousElt(QName qName) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute attr = this.eventFactory.createAttribute(anonymous, "true");
        attributes.add(attr);
        return this.eventFactory.createStartElement(qName, attributes.iterator(), Collections.EMPTY_LIST.iterator());
    }

    private XMLEvent removeItemArrayAttribute(StartElement se) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator<Attribute> it = se.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            if (attr.getName().equals(JsonConstants.JSON_ARRAY_ITEM)) continue;
            attributes.add(attr);
        }
        return this.eventFactory.createStartElement(new QName("item"), attributes.iterator(), Collections.EMPTY_LIST.iterator());
    }

    private XMLEvent createVirtualEndArrayElement(QName qName) {
        ArrayList attributes = new ArrayList();
        return this.eventFactory.createEndElement(qName, Collections.EMPTY_LIST.iterator());
    }

    private void transform(XMLEvent nextEvent) throws XMLStreamException {
        XMLEvent currentEvent = this.currentEvent;
        switch (currentEvent.getEventType()) {
            case 1: {
                StartElement se = currentEvent.asStartElement();
                String currentParentPath = this.currentPath.toString();
                ArrayInfo info = this.arrayIsOpen.get(currentParentPath);
                QName name = info != null ? info.name : null;
                boolean hasNextArray = false;
                this.currentPath.addSegment(se.getName().getLocalPart());
                if (se.getAttributeByName(JsonConstants.JSON_ARRAY_ITEM) != null) {
                    StartElement n;
                    currentEvent = this.removeItemArrayAttribute(se);
                    if (this.nextEvent.isStartElement() && (n = this.nextEvent.asStartElement()).getAttributeByName(JsonConstants.JSON_ARRAY_ITEM) != null) {
                        hasNextArray = true;
                    }
                    if (hasNextArray) {
                        this.disable.add(this.currentPath.toString());
                        currentEvent = null;
                    }
                    if (name != null) {
                        if (!name.equals(se.getName())) {
                            this.fire(this.createVirtualEndArrayElement(name));
                            this.arrayIsOpen.remove(currentParentPath);
                            info = new ArrayInfo();
                            info.name = se.getName();
                            this.arrayIsOpen.put(currentParentPath, info);
                            this.fire(this.createVirtualStartArrayElement(info.name, null));
                        }
                    } else {
                        info = new ArrayInfo();
                        info.name = se.getName();
                        this.arrayIsOpen.put(currentParentPath, info);
                        this.fire(this.createVirtualStartArrayElement(info.name, null));
                    }
                } else if (name != null) {
                    this.fire(this.createVirtualEndArrayElement(name));
                    this.arrayIsOpen.remove(currentParentPath);
                }
                if (currentEvent == null) break;
                this.stack.add(currentEvent.asStartElement().getName());
                break;
            }
            case 2: {
                ArrayInfo info;
                QName name;
                if (this.disable.contains(this.currentPath.toString())) {
                    currentEvent = null;
                    this.disable.remove(this.currentPath.toString());
                }
                QName qName = name = (info = this.arrayIsOpen.get(this.currentPath.toString())) != null ? info.name : null;
                if (name != null) {
                    this.fire(this.createVirtualEndArrayElement(name));
                    this.arrayIsOpen.remove(this.currentPath.toString());
                }
                this.currentPath.removeSegment();
                if (currentEvent == null) break;
                currentEvent = this.eventFactory.createEndElement(this.stack.getLast(), Collections.EMPTY_LIST.iterator());
                this.stack.removeLast();
            }
        }
        if (currentEvent != null) {
            this.fire(currentEvent);
        }
    }

    public void add(XMLEvent event) throws XMLStreamException {
        if (this.currentEvent == null) {
            this.currentEvent = event;
            return;
        }
        this.nextEvent = event;
        this.transform(this.currentEvent);
        this.currentEvent = this.nextEvent;
        if (this.currentEvent != null && this.currentEvent.getEventType() == 8) {
            this.transform(this.currentEvent);
            this.currentEvent = null;
        }
    }

    private void fire(XMLEvent event) throws XMLStreamException {
        this.handle(event);
    }

    public abstract void handle(XMLEvent var1) throws XMLStreamException;

    class ArrayInfo {
        QName name;

        ArrayInfo() {
        }
    }
}

