/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.httprest.impl;

import com.stambia.httprest.impl.Messages;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class WebServiceUtils {
    protected static String requestToRawHttp(HttpRequest request) throws IOException {
        Object body = "";
        String uri = "";
        if (request instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)request).getEntity() != null) {
            body = EntityUtils.toString((HttpEntity)((HttpEntityEnclosingRequestBase)request).getEntity());
        } else if (request instanceof HttpRequestWrapper) {
            HttpRequest original = ((HttpRequestWrapper)request).getOriginal();
            if (original instanceof HttpUriRequest) {
                uri = ((HttpUriRequest)original).getURI().toString();
            }
            if (original instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)original).getEntity() != null) {
                body = ((HttpEntityEnclosingRequestBase)original).getEntity().getContentLength() < 24000L ? EntityUtils.toString((HttpEntity)((HttpEntityEnclosingRequestBase)original).getEntity()) + "\n" : Messages.getString("WebServiceUtils.0");
            }
        }
        StringBuilder builder = new StringBuilder("----------REQUEST----------\n");
        builder.append(uri).append("\n\n").append(request.getRequestLine()).append("\n");
        Header[] headerArray = request.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            builder.append(header.toString()).append("\n");
            ++n2;
        }
        builder.append("\n").append((String)body);
        return builder.toString();
    }

    protected static String responseToRawHttp(HttpResponse resp) throws ParseException, IOException {
        StringBuilder builder = new StringBuilder("----------RESPONSE----------\n");
        builder.append(resp.getStatusLine().toString() + "\n");
        Header[] headerArray = resp.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            builder.append(header.toString() + "\n");
            ++n2;
        }
        if (resp.getEntity() != null && resp.getEntity().getContentLength() >= 24000L) {
            builder.append(Messages.getString("WebServiceUtils.1"));
        }
        return builder.toString();
    }
}

