/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.httprest.internal;

import com.indy.addons.httprest.internal.JsonSchemaVisitor;
import com.indy.addons.httprest.internal.Utils;
import com.stambia.md.MdNode;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;

public class OpenApiVisitor {
    private final Stack<MdNode> nodes = new Stack();
    private final Stack<String> names = new Stack();
    private final Map<String, Schema<?>> knownReferencedSchemas = new HashMap();
    private final int recursivityLevel;
    private IProgressMonitor monitor;
    private static final String NODE_PATH = "com.stambia.http.rest.path";
    private static final String NODE_OPERATION = "com.stambia.http.rest.operation";
    private static final String NODE_PARAMETERS = "com.stambia.http.rest.parameters";
    private static final String NODE_PARAMETER = "com.stambia.http.rest.parameter";
    private static final String NODE_REQUESTBODY = "com.stambia.http.rest.requestbody";
    private static final String NODE_CONTENT = "com.stambia.http.rest.content";
    private static final String NODE_RESPONSES = "com.stambia.http.rest.responses";
    private static final String NODE_RESPONSE = "com.stambia.http.rest.response";
    private static final String NODE_HEADERS = "com.stambia.http.rest.headers";
    private static final String NODE_HEADER = "com.stambia.http.rest.header";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_SUMMARY = "summary";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_OPERATIONID = "operationId";
    private static final String ATTRIBUTE_LOCATION = "location";
    private static final String ATTRIBUTE_REQUIRED = "required";
    private static final String ATTRIBUTE_DEPRECATED = "deprecated";
    private static final String ATTRIBUTE_ALLOWEMPTYVALUE = "allowEmptyValue";
    private static final String ATTRIBUTE_MEDIATYPE = "mediaType";
    private static final String ATTRIBUTE_CONTENTTYPE = "contentType";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ATTRIBUTE_URL = "url";

    public OpenApiVisitor(MdNode openApiSchemaNode, int recursivityLevel, IProgressMonitor monitor) {
        this.nodes.add(openApiSchemaNode);
        this.recursivityLevel = recursivityLevel;
        this.monitor = monitor;
    }

    public final void visit(OpenAPI openAPISchema) throws Exception {
        if (openAPISchema != null) {
            Map schemas;
            Utils.logger.debug("openAPISchema");
            Components components = openAPISchema.getComponents();
            if (components != null && (schemas = components.getSchemas()) != null) {
                for (Map.Entry schemaEntry : schemas.entrySet()) {
                    String name = (String)schemaEntry.getKey();
                    Schema schema = (Schema)schemaEntry.getValue();
                    this.knownReferencedSchemas.put(name, schema);
                    this.updateMonitorWorkUnit();
                }
            }
            List servers = openAPISchema.getServers();
            this.visitServers(servers);
            Paths paths = openAPISchema.getPaths();
            this.visit(paths);
        }
    }

    private final void visitServers(List<Server> servers) {
        if (servers != null) {
            Utils.logger.debug("servers");
            Server firstServer = servers.get(0);
            this.visit(firstServer);
        }
    }

    private final void visit(Server server) {
        if (server != null) {
            String url = server.getUrl();
            Utils.logger.debug("server\turl:" + url);
            MdNode node = this.nodes.peek();
            Utils.setAttribute(node, ATTRIBUTE_URL, url);
        }
    }

    private final void visit(Paths paths) throws Exception {
        if (paths != null) {
            Utils.logger.debug("paths");
            for (Map.Entry pathEntry : paths.entrySet()) {
                String pathValue = (String)pathEntry.getKey();
                this.names.add(pathValue);
                PathItem pathItem = (PathItem)pathEntry.getValue();
                this.updateMonitorWorkUnit();
                this.visit(pathItem);
            }
        }
    }

    private final void visit(PathItem pathItem) throws Exception {
        if (pathItem != null) {
            String name = this.names.pop();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ATTRIBUTE_PATH, name);
            attributes.put(ATTRIBUTE_SUMMARY, pathItem.getSummary());
            attributes.put(ATTRIBUTE_DESCRIPTION, pathItem.getDescription());
            Utils.logger.debug("pathItem:" + String.valueOf(attributes));
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_PATH, name);
            Utils.setAttributes(node, attributes);
            this.nodes.add(node);
            Map operations = pathItem.readOperationsMap();
            this.visitOperations(operations);
            this.nodes.pop();
        }
    }

    private final void visitOperations(Map<PathItem.HttpMethod, Operation> operations) throws Exception {
        if (operations != null) {
            Utils.logger.debug("operations");
            for (Map.Entry<PathItem.HttpMethod, Operation> operationEntry : operations.entrySet()) {
                String operationValue = operationEntry.getKey().name();
                this.names.add(operationValue);
                Operation operation = operationEntry.getValue();
                this.updateMonitorWorkUnit();
                this.visit(operation);
            }
        }
    }

    private final void visit(Operation operation) throws Exception {
        if (operation != null) {
            String name = this.names.pop();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ATTRIBUTE_METHOD, name);
            attributes.put(ATTRIBUTE_SUMMARY, operation.getSummary());
            attributes.put(ATTRIBUTE_DESCRIPTION, operation.getDescription());
            attributes.put(ATTRIBUTE_OPERATIONID, operation.getOperationId());
            Utils.logger.debug("operation:" + String.valueOf(attributes));
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_OPERATION, name);
            Utils.setAttributes(node, attributes);
            this.nodes.add(node);
            List parameters = operation.getParameters();
            this.visitParameters(parameters);
            RequestBody requestBody = operation.getRequestBody();
            this.visit(requestBody);
            ApiResponses responses = operation.getResponses();
            this.visit(responses);
            this.nodes.pop();
        }
    }

    private final void visitParameters(List<Parameter> parameters) {
        if (parameters != null) {
            Utils.logger.debug("parameters");
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_PARAMETERS);
            this.nodes.add(node);
            for (Parameter parameter : parameters) {
                this.visit(parameter);
            }
            this.nodes.pop();
        }
    }

    private final void visit(Parameter parameter) {
        if (parameter != null) {
            String name = parameter.getName();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ATTRIBUTE_METHOD, name);
            attributes.put(ATTRIBUTE_LOCATION, parameter.getIn());
            attributes.put(ATTRIBUTE_DESCRIPTION, parameter.getDescription());
            attributes.put(ATTRIBUTE_REQUIRED, parameter.getRequired());
            attributes.put(ATTRIBUTE_DEPRECATED, parameter.getDeprecated());
            attributes.put(ATTRIBUTE_ALLOWEMPTYVALUE, parameter.getAllowEmptyValue());
            Utils.logger.debug("parameter:" + String.valueOf(attributes));
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_PARAMETER, name);
            Utils.setAttributes(node, attributes);
        }
    }

    private final void visit(RequestBody requestBody) throws Exception {
        if (requestBody != null) {
            Boolean required = requestBody.getRequired();
            Utils.logger.debug("requestBody\trequired:" + String.valueOf(required));
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_REQUESTBODY);
            Utils.setAttribute(node, ATTRIBUTE_REQUIRED, required);
            this.nodes.add(node);
            Content content = requestBody.getContent();
            this.visit(content);
            this.nodes.pop();
        }
    }

    private final void visit(Content content) throws Exception {
        if (content != null) {
            Utils.logger.debug("content");
            for (Map.Entry contentEntry : content.entrySet()) {
                String contentName = (String)contentEntry.getKey();
                this.names.add(contentName);
                MediaType mediaType = (MediaType)contentEntry.getValue();
                this.visit(mediaType);
            }
        }
    }

    private String computeMediaType(String contentType) {
        if (contentType != null) {
            if (contentType.toLowerCase().contains("json")) {
                return "JSON";
            }
            if (contentType.toLowerCase().contains("xml")) {
                return "XML";
            }
            if (contentType.toLowerCase().contains("text")) {
                return "TEXT";
            }
            if (contentType.toLowerCase().contains("form")) {
                return "FORM";
            }
        }
        return "BINARY";
    }

    private final void visit(MediaType mediaType) throws Exception {
        if (mediaType != null) {
            String name = this.names.pop();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ATTRIBUTE_MEDIATYPE, this.computeMediaType(name));
            attributes.put(ATTRIBUTE_CONTENTTYPE, name);
            Utils.logger.debug("mediaType\tname:" + name);
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_CONTENT, name);
            Utils.setAttributes(node, attributes);
            this.nodes.add(node);
            Schema schema = mediaType.getSchema();
            JsonSchemaVisitor jsonSchemaVisitor = new JsonSchemaVisitor(node, this.recursivityLevel, this.knownReferencedSchemas);
            jsonSchemaVisitor.visit(schema);
            this.nodes.pop();
        }
    }

    private final void visit(ApiResponses responses) throws Exception {
        if (responses != null) {
            Utils.logger.debug("responses");
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_RESPONSES);
            this.nodes.add(node);
            for (Map.Entry responseEntry : responses.entrySet()) {
                String responseName = (String)responseEntry.getKey();
                this.names.add(responseName);
                ApiResponse response = (ApiResponse)responseEntry.getValue();
                this.visit(response);
            }
            this.nodes.pop();
        }
    }

    private final void visit(ApiResponse response) throws Exception {
        if (response != null) {
            String name = this.names.pop();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(ATTRIBUTE_CODE, name);
            attributes.put(ATTRIBUTE_DESCRIPTION, response.getDescription());
            Utils.logger.debug("response:" + String.valueOf(attributes));
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_RESPONSE, name);
            Utils.setAttributes(node, attributes);
            this.nodes.add(node);
            Map headers = response.getHeaders();
            this.visitHeaders(headers);
            Content content = response.getContent();
            this.visit(content);
            this.nodes.pop();
        }
    }

    private final void visitHeaders(Map<String, Header> headers) {
        if (headers != null) {
            Utils.logger.debug("headers");
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_HEADERS);
            this.nodes.add(node);
            for (Map.Entry<String, Header> headerEntry : headers.entrySet()) {
                String headerName = headerEntry.getKey();
                this.names.add(headerName);
                Header header = headerEntry.getValue();
                this.visit(header);
            }
            this.nodes.pop();
        }
    }

    private final void visit(Header header) {
        if (header != null) {
            String name = this.names.pop();
            String description = header.getDescription();
            Utils.logger.debug("header\tname:" + name + "\tdescription:" + description);
            MdNode parent = this.nodes.peek();
            MdNode node = Utils.createNode(parent, NODE_HEADER, name);
            Utils.setAttribute(node, ATTRIBUTE_DESCRIPTION, description);
        }
    }

    private void updateMonitorWorkUnit() {
        this.monitor.worked(1);
    }
}

