/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.jws;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JWSTokenGenerator {
    public String generateCompactToken(String payload, Map<String, String> protectedHeaders, String secret) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        JsonEventWriter writer = new JsonEventWriter((OutputStream)bos, "UTF-8");
        writer.add(new JSonEvent(JSonEvent.Type.START_OBJECT, null));
        String algorithm = null;
        ArrayList<String> keys = new ArrayList<String>(protectedHeaders.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            if (s.equals("alg")) {
                algorithm = protectedHeaders.get(s);
            }
            writer.add(new JSonEvent(JSonEvent.Type.MEMBER, s));
            writer.add(new JSonEvent(JSonEvent.Type.STRING, protectedHeaders.get(s)));
        }
        writer.add(new JSonEvent(JSonEvent.Type.END_OBJECT, null));
        writer.close();
        if (algorithm == null) {
            throw new Exception("Missing alg in the JWS Protected Headers");
        }
        byte[] joseHeaderBytes = Base64.getEncoder().encode(bos.toByteArray());
        byte[] payloadBytes = Base64.getEncoder().encode(payload.getBytes());
        String message = this.base64URLEncode(new String(joseHeaderBytes)) + "." + this.base64URLEncode(new String(payloadBytes));
        Algorithm alg = Algorithm.valueOf(algorithm);
        if (alg == null) {
            throw new Exception("The algorithm " + algorithm + " is not supported");
        }
        String signature = this.base64URLEncode(new String(Base64.getEncoder().encode(alg.sign(message, "UTF-8", secret))));
        return message + "." + signature;
    }

    private String base64URLEncode(String toEncode) {
        return toEncode.replace("/", "_").replace("+", "-").replace("=", "");
    }

    public static enum Algorithm {
        HS256("HmacSHA256"),
        HS384("HmacSHA384"),
        HS512("HmacSHA512"),
        RS256("SHA256withRSA"),
        NONE("none");

        String code;

        private Algorithm(String code) {
            this.code = code;
        }

        public byte[] sign(String message, String messageEncoding, String secret) throws Exception {
            Mac mac = null;
            SecretKeySpec secret_key = null;
            switch (this) {
                case HS256: 
                case HS384: 
                case HS512: {
                    mac = Mac.getInstance(this.code);
                    secret_key = new SecretKeySpec(secret.getBytes("UTF-8"), this.code);
                    mac.init(secret_key);
                    return mac.doFinal(message.getBytes());
                }
                case RS256: {
                    byte[] b1 = Base64.getDecoder().decode(secret.getBytes());
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(b1);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    Signature privateSignature = Signature.getInstance("SHA256withRSA");
                    privateSignature.initSign(kf.generatePrivate(spec));
                    privateSignature.update(message.getBytes(messageEncoding));
                    byte[] s = privateSignature.sign();
                    return s;
                }
                case NONE: {
                    return message.getBytes(messageEncoding);
                }
            }
            throw new UnsupportedOperationException();
        }

        public static String[] stringValues() {
            String[] s = new String[Algorithm.values().length];
            Algorithm[] algorithmArray = Algorithm.values();
            int n = algorithmArray.length;
            int n2 = 0;
            while (n2 < n) {
                Algorithm a = algorithmArray[n2];
                s[a.ordinal()] = a.name();
                ++n2;
            }
            return s;
        }
    }

    public static enum SerializationMode {
        COMPACT("JWS Compact Serialization"),
        JSON("JWS JSON Serialization");

        String label;

        private SerializationMode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

