/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.oauth2.wizard;

import com.indy.addons.AttributeUtil;
import com.indy.addons.httprest.Messages;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantBean;
import com.indy.addons.oauth2.wizard.AuthorizationCodeGrantFlow;
import com.indy.addons.oauth2.wizard.OAuth2Wizard;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdAttributeReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.wizard.IWizard;

public class Linker
implements OAuth2Wizard.ILinker {
    private static final Logger logger = LogManager.getLogger(Linker.class);
    private static final String UNEXPECTED_LOG_MESSAGE = "unexpected";
    private MdNode node;
    private boolean refreshBean = false;
    private AuthorizationCodeGrantBean bean = new AuthorizationCodeGrantBean();
    private String _originalAuthURI = "";
    private String _originalTokenURI = "";
    private OAuth2Wizard.FlowType flowType;

    public Linker(OAuth2Wizard.FlowType flowType) {
        this.flowType = flowType;
    }

    @Override
    public OAuth2Wizard.FlowType getFlowType() {
        return this.flowType;
    }

    @Override
    public void setNode(MdNode node) {
        this.node = node;
        this.refreshBean = true;
    }

    @Override
    public Object getBean() {
        if (this.refreshBean) {
            this.refreshBean();
            this.refreshBean = false;
        }
        return this.bean;
    }

    public void executeFlow(IWizard w) throws Exception {
        AuthorizationCodeGrantFlow flow = new AuthorizationCodeGrantFlow((AuthorizationCodeGrantBean)this.getBean());
        AuthorizationCodeGrantFlow.AccessTokenResponse response = flow.getToken(w);
        if (response != null) {
            this.bean.token = response.token;
            this.bean.refreshToken = response.refreshToken;
            this.bean.expiresIn = response.expireIn;
            this.bean.responseInfo = response.allInfos;
            if (this.bean.token == null) {
                this.bean.token = "";
            }
            if (this.bean.refreshToken == null) {
                this.bean.refreshToken = "";
            }
            if (this.bean.expiresIn == null) {
                this.bean.expiresIn = "";
            }
        }
    }

    private void refreshBean() {
        try {
            String s = MdAttributeReader.readAttribute((String)"flowType", (MdNode)this.node, (String)"");
            if (OAuth2Wizard.FlowType.IMPLICIT_GRANT.getValue().equals(s)) {
                this.bean.isImplicit = true;
            }
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this.bean.name = this.node.getName() != null && !this.node.getName().isEmpty() ? this.node.getName() : null;
        try {
            this.bean.authorizationURI = MdAttributeReader.readAttribute((String)"authorizationEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this._originalAuthURI = this.bean.authorizationURI;
        try {
            this.bean.tokenURI = MdAttributeReader.readAttribute((String)"tokenEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this._originalTokenURI = this.bean.tokenURI;
        try {
            this.bean.clientId = MdAttributeReader.readAttribute((String)"clientId", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.clientSecret = MdAttributeReader.readAttribute((String)"clientSecret", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.redirectURI = MdAttributeReader.readAttribute((String)"redirectionEndpoint", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.scopes = new ArrayList<String>(MdAttributeReader.readAttributeList((String)"scope", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.token = MdAttributeReader.readAttribute((String)"accessToken", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.refreshToken = MdAttributeReader.readAttribute((String)"refreshToken", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.expiresIn = MdAttributeReader.readAttribute((String)"expiresIn", (MdNode)this.node, (String)"");
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.authParams = new HashMap(MdAttributeReader.readAttributeMap((String)"authorizationParameter", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        try {
            this.bean.additionalHeaders = new HashMap(MdAttributeReader.readAttributeMap((String)"additionalHttpHeaders", (MdNode)this.node));
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        this.bean.enableHostnameVerification = this.getAttributeBooleanValue("enableHostnameVerification");
        this.bean.enableCertificateVerification = this.getAttributeBooleanValue("enableCertificateVerification");
        this.bean.preconfs.clear();
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.Linker_0, this._originalAuthURI, this._originalTokenURI, false, false));
        this.bean.preconfs.add(new AuthorizationCodeGrantBean.Preconf(Messages.Linker_26, "", "", false, false));
        this.bean.preconfs.add(AuthorizationCodeGrantBean.googleConf);
        this.bean.preconfs.add(AuthorizationCodeGrantBean.linkedInConf);
    }

    @Override
    public void dispose() {
        this.node = null;
    }

    @Override
    public void updateMdNode() throws Exception {
        MdNode dummyNode = this.node.copy(0);
        dummyNode.setName(this.bean.name);
        dummyNode.setSubstituteContainer(this.node.getSubstituteContainer());
        AttributeUtil.setAttribute((String)"accessToken", (Object)this.bean.token, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"clientSecret", (Object)this.bean.clientSecret, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"authorizationEndpoint", (Object)this.bean.authorizationURI, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"clientId", (Object)this.bean.clientId, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"expiresIn", (Object)this.bean.expiresIn, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"redirectionEndpoint", (Object)this.bean.redirectURI, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"refreshToken", (Object)this.bean.refreshToken, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"scope", this.bean.scopes, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"tokenEndpoint", (Object)this.bean.tokenURI, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"authorizationParameter", this.bean.authParams, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"additionalHttpHeaders", this.bean.additionalHeaders, (MdNode)dummyNode, (MdNode)this.node);
        AttributeUtil.setAttribute((String)"authorizationProperties", this.bean.responseInfo, (MdNode)dummyNode, (MdNode)this.node);
        dummyNode.setPosition(this.node.getPosition());
        HashMap<MdNode, MdNode> reversedObject = new HashMap<MdNode, MdNode>();
        reversedObject.put(dummyNode, this.node);
        ArrayList<String> nonDeletableAttributes = new ArrayList<String>();
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.connectionTimeout");
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.expiresIn");
        nonDeletableAttributes.add("com.stambia.wsdl.oauth2.numberOfAttempts");
        IncrementalReverser ir = new IncrementalReverser(this.node.getSubstituteContainer(), reversedObject, nonDeletableAttributes, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
        ir.reverse();
    }

    @Override
    public boolean canFinish() {
        return this.bean.hasToken();
    }

    private boolean getAttributeBooleanValue(String attributeName) {
        try {
            String attributeValue = MdAttributeReader.readAttribute((String)attributeName, (MdNode)this.node);
            if (attributeValue != null && !attributeValue.isEmpty()) {
                return Boolean.valueOf(attributeValue);
            }
        }
        catch (Exception ex) {
            logger.debug(UNEXPECTED_LOG_MESSAGE, (Throwable)ex);
        }
        return false;
    }
}

