/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.editors.Messages;
import com.indy.ui.sql.editors.TableColumnViewerComparator;
import com.indy.ui.sql.editors.export.ExportAction;
import com.indy.ui.sql.editors.export.ExporterCSV;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class ResultUI {
    private static Clipboard clipboard;
    private TableViewer viewer;
    private TableViewer errorViewer;
    private Label footerLabel;
    private Composite tableComposite;
    private Composite errorComposite;
    private TableCursor cursor;
    private StackLayout layout = new StackLayout();
    private ExportAction actionCsv;

    private static Clipboard getClipboard() {
        if (clipboard == null) {
            clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        }
        return clipboard;
    }

    public void createUI(Composite parent) {
        Composite main = new Composite(parent, 2048);
        this.layout = new StackLayout();
        main.setLayout((Layout)this.layout);
        this.tableComposite = this.createViewer(main);
        this.errorComposite = this.createError(main);
        Label messageLabel = new Label(main, 64);
        messageLabel.setText(Messages.ResultUI_0);
        this.layout.topControl = messageLabel;
    }

    private Composite createError(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.errorViewer = new TableViewer(container, 0x10010300);
        this.errorViewer.getTable().setHeaderVisible(true);
        this.errorViewer.getTable().setLinesVisible(true);
        this.errorViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.errorViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn col = new TableViewerColumn(this.errorViewer, 0);
        col.getColumn().setText(Messages.ResultUI_1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IResultModel.ErrorStatus)element).getSQL();
            }
        });
        col = new TableViewerColumn(this.errorViewer, 0);
        col.getColumn().setText(Messages.ResultUI_2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IResultModel.ErrorStatus)element).getMessage();
            }
        });
        col = new TableViewerColumn(this.errorViewer, 0);
        col.getColumn().setText(Messages.ResultUI_3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                int i = ((IResultModel.ErrorStatus)element).getSQLCode();
                if (i == -1) {
                    return "";
                }
                return "" + i;
            }
        });
        return container;
    }

    private Composite createViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(container, 0x10010300);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((IResultModel)inputElement).getRows();
            }
        });
        this.footerLabel = new Label(container, 64);
        this.footerLabel.setLayoutData((Object)new GridData(4, 3, true, false));
        this.footerLabel.setText(String.format(Messages.ResultUI_12, 0, 0));
        this.createTableCursor();
        this.createContextMenu();
        return container;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        AbstractCopyToClipBoardAction action = new CopyTableAction(Messages.ResultUI_7);
        menuMgr.add((IAction)action);
        action = new CopyCellAction(Messages.ResultUI_9);
        menuMgr.add((IAction)action);
        action = new CopyCollumnAction(Messages.ResultUI_10);
        menuMgr.add((IAction)action);
        action = new CopyCollumnNameAction(Messages.ResultUI_13);
        menuMgr.add((IAction)action);
        action = new CopyRowAction(Messages.ResultUI_14);
        menuMgr.add((IAction)action);
        menuMgr.add((IContributionItem)new Separator());
        this.actionCsv = new ExportAction(Messages.ResultUI_8, new ExporterCSV());
        menuMgr.add((IAction)this.actionCsv);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.cursor.setMenu(menu);
        this.viewer.getTable().setMenu(menu);
    }

    private void createTableCursor() {
        this.cursor = new TableCursor(this.viewer.getTable(), 0);
        this.cursor.setBackground(this.viewer.getTable().getDisplay().getSystemColor(26));
        this.cursor.setForeground(this.viewer.getTable().getDisplay().getSystemColor(27));
        this.cursor.setLayout((Layout)new FillLayout());
        this.cursor.setVisible(false);
        this.viewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Table t = (Table)e.widget;
                if (t.getItemCount() != 0) {
                    ResultUI.this.cursor.setVisible(true);
                }
            }
        });
    }

    public void setData(IResultModel model) {
        TableColumn c;
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = tableColumnArray[n2];
            c.dispose();
            ++n2;
        }
        if (model.getErrorStatus() != null) {
            this.errorViewer.setInput((Object)new Object[]{model.getErrorStatus()});
            tableColumnArray = this.errorViewer.getTable().getColumns();
            n = tableColumnArray.length;
            n2 = 0;
            while (n2 < n) {
                c = tableColumnArray[n2];
                c.pack();
                ++n2;
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.sql", Messages.ResultUI_11, model.getErrorStatus().getException()), 1);
            this.layout.topControl = this.errorComposite;
        } else {
            int i = 0;
            while (i < model.getColumnNumber()) {
                final IResultModel.Column column = model.getColumn(i);
                TableViewerColumn colViewer = new TableViewerColumn(this.viewer, column.isJustifyRight() ? 131072 : 16384);
                colViewer.getColumn().setText(column.getCaption());
                colViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return column.getDisplayValue(((IResultModel.Row)element).getColumnValue(column.getColumnIndex()));
                    }
                });
                ++i;
            }
            this.footerLabel.setText(String.format(Messages.ResultUI_12, model.getExecutionTime(), model.getRowNumber()));
            this.layout.topControl = this.tableComposite;
            this.viewer.setInput((Object)model);
            this.actionCsv.setResultModel(model);
            TableColumnViewerComparator tableColumnSorter = new TableColumnViewerComparator(this.viewer);
            TableColumn[] tableColumnArray2 = this.viewer.getTable().getColumns();
            int n3 = tableColumnArray2.length;
            n = 0;
            while (n < n3) {
                TableColumn c2 = tableColumnArray2[n];
                c2.setMoveable(true);
                c2.setResizable(true);
                c2.pack();
                ++n;
            }
        }
        this.layout.topControl.getParent().layout(true);
    }

    public IResultModel getResultModel() {
        return (IResultModel)this.viewer.getInput();
    }

    private abstract class AbstractCopyToClipBoardAction
    extends Action {
        protected AbstractCopyToClipBoardAction(String text) {
            super(text);
        }

        public void doExport() {
            Clipboard clipboard = ResultUI.getClipboard();
            try {
                clipboard = new Clipboard(ResultUI.this.viewer.getControl().getDisplay());
                this.doExport(clipboard);
            }
            finally {
                clipboard.dispose();
            }
        }

        public boolean isEnabled() {
            return ResultUI.this.layout.topControl == ResultUI.this.tableComposite;
        }

        public void run() {
            BusyIndicator.showWhile((Display)Display.getCurrent(), () -> this.doExport());
        }

        protected void doExport(Clipboard clipboard) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            String lineSeparator = System.getProperty("line.separator");
            String columnSeparator = ";";
            boolean includeColumnNames = true;
            clipboard.setContents(new Object[]{this.getDataToCopy(includeColumnNames, columnSeparator, lineSeparator)}, new Transfer[]{textTransfer});
        }

        protected String format(String value) {
            if (value != null && (value.indexOf(34) > -1 || value.indexOf(39) > -1)) {
                return "\"" + value.replace("\"", "\"\"") + "\"";
            }
            return value;
        }

        protected abstract String getDataToCopy(boolean var1, String var2, String var3);
    }

    private final class CopyCellAction
    extends AbstractCopyToClipBoardAction {
        private CopyCellAction(String text) {
            super(text);
        }

        @Override
        public String getDataToCopy(boolean includeColumnNames, String columnSeparator, String lineSeparator) {
            int rowIndex;
            StringBuilder sb = new StringBuilder();
            Table table = ResultUI.this.viewer.getTable();
            int n = rowIndex = ResultUI.this.cursor.getRow() != null ? table.indexOf(ResultUI.this.cursor.getRow()) : -1;
            if (rowIndex != -1) {
                String value = table.getItems()[rowIndex].getText(ResultUI.this.cursor.getColumn());
                sb.append(this.format(value));
            }
            return sb.toString();
        }
    }

    private final class CopyCollumnAction
    extends AbstractCopyToClipBoardAction {
        private CopyCollumnAction(String text) {
            super(text);
        }

        @Override
        public String getDataToCopy(boolean includeColumnNames, String columnSeparator, String lineSeparator) {
            StringBuilder sb = new StringBuilder();
            Table table = ResultUI.this.viewer.getTable();
            int collumnIndex = ResultUI.this.cursor.getColumn();
            if (collumnIndex != -1) {
                int i = 0;
                while (i < table.getItemCount()) {
                    String val = table.getItem(i).getText(collumnIndex);
                    sb.append(this.format(val));
                    if (i < table.getItemCount() - 1) {
                        sb.append(lineSeparator);
                    }
                    ++i;
                }
            }
            return sb.toString();
        }
    }

    private final class CopyCollumnNameAction
    extends AbstractCopyToClipBoardAction {
        private CopyCollumnNameAction(String text) {
            super(text);
        }

        @Override
        public String getDataToCopy(boolean includeColumnNames, String columnSeparator, String lineSeparator) {
            StringBuilder sb = new StringBuilder();
            Table table = ResultUI.this.viewer.getTable();
            int collumnIndex = ResultUI.this.cursor.getColumn();
            if (collumnIndex != -1) {
                String val = table.getColumn(collumnIndex).getText();
                sb.append(this.format(val));
            }
            return sb.toString();
        }
    }

    private final class CopyRowAction
    extends AbstractCopyToClipBoardAction {
        private CopyRowAction(String text) {
            super(text);
        }

        @Override
        public String getDataToCopy(boolean includeColumnNames, String columnSeparator, String lineSeparator) {
            int rowIndex;
            StringBuilder sb = new StringBuilder();
            Table table = ResultUI.this.viewer.getTable();
            int n = rowIndex = ResultUI.this.cursor.getRow() != null ? table.indexOf(ResultUI.this.cursor.getRow()) : -1;
            if (rowIndex != -1) {
                TableItem tableItem = table.getItems()[rowIndex];
                int i = 0;
                while (i < table.getColumnCount()) {
                    String val = tableItem.getText(i);
                    sb.append(this.format(val));
                    if (i < table.getColumnCount() - 1) {
                        sb.append(columnSeparator);
                    }
                    ++i;
                }
            }
            return sb.toString();
        }
    }

    private final class CopyTableAction
    extends AbstractCopyToClipBoardAction {
        private CopyTableAction(String text) {
            super(text);
        }

        @Override
        public String getDataToCopy(boolean includeColumnNames, String columnSeparator, String lineSeparator) {
            String val;
            IResultModel res = ResultUI.this.getResultModel();
            StringBuilder sb = new StringBuilder();
            if (includeColumnNames) {
                int i = 0;
                while (i < res.getColumnNumber()) {
                    IResultModel.Column col = res.getColumn(i);
                    val = col.getCaption();
                    sb.append(this.format(val));
                    if (i < res.getColumnNumber() - 1) {
                        sb.append(columnSeparator);
                    }
                    ++i;
                }
                sb.append(lineSeparator);
            }
            IResultModel.Row[] rowArray = res.getRows();
            int n = rowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResultModel.Row r = rowArray[n2];
                int i = 0;
                while (i < res.getColumnNumber()) {
                    val = res.getColumn(i).getDisplayValue(r.getColumnValue(i));
                    sb.append(this.format(val));
                    if (i < res.getColumnNumber() - 1) {
                        sb.append(columnSeparator);
                    }
                    ++i;
                }
                sb.append(lineSeparator);
                ++n2;
            }
            return sb.toString();
        }
    }
}

