/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors.configuration;

import com.indy.ui.sql.ISQLDictionary;
import com.indy.ui.sql.editors.configuration.SQLWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class KeyWordRule
implements IRule {
    protected IWordDetector detector = new SQLWordDetector();
    private StringBuffer fBuffer = new StringBuffer();
    private IToken tableToken;
    private IToken keywordToken;
    private ISQLDictionary dictionary;

    public KeyWordRule(ISQLDictionary dictionary, IToken tableToken, IToken keywordToken) {
        this.tableToken = tableToken;
        this.keywordToken = keywordToken;
        this.dictionary = dictionary;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.dictionary == null) {
            return Token.UNDEFINED;
        }
        int c = scanner.read();
        if (this.detector.isWordStart((char)c)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.detector.isWordPart((char)c));
            scanner.unread();
            String tokenName = this.fBuffer.substring(0, this.fBuffer.length()).toLowerCase();
            ISQLDictionary.Item item = this.dictionary.getItem(tokenName);
            if (item != null) {
                return this.tableToken;
            }
            if (this.dictionary.getKeywords().contains(tokenName)) {
                return this.keywordToken;
            }
            this.unreadBuffer(scanner);
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

