/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors.configuration;

import com.indy.ui.sql.ISQLDictionary;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.statushandlers.StatusManager;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private char[] activationChars = new char[]{'.'};
    private ISQLDictionary dictionary;
    private static final AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

    public SQLCompletionProcessor(ISQLDictionary dictionary) {
        this.dictionary = dictionary;
    }

    protected List<ISQLDictionary.Item> getAvailableItems(String word, int indexOfDatastoreSeparator) {
        if (indexOfDatastoreSeparator > 0) {
            String datastoreName = word.substring(0, indexOfDatastoreSeparator);
            String colName = word.length() >= indexOfDatastoreSeparator + 1 ? word.substring(indexOfDatastoreSeparator + 1) : null;
            return this.dictionary.getItems().stream().filter(i -> i.getLabel() != null && i.getLabel().equalsIgnoreCase(datastoreName)).flatMap(i -> i.getChildren().stream()).filter(i -> colName == null || i.getLabel() != null && i.getLabel().toLowerCase().startsWith(colName.toLowerCase())).collect(Collectors.toList());
        }
        return this.dictionary.getItems().stream().filter(i -> word != null && (word.isEmpty() || i.getLabel().toLowerCase().startsWith(word.toLowerCase()))).collect(Collectors.toList());
    }

    protected ICompletionProposal createProposal(ISQLDictionary.Item item, String replacedWord, int offset) {
        int datastoreSperatorIndex = replacedWord.indexOf(".");
        CompletionProposal p = datastoreSperatorIndex > 0 ? new CompletionProposal(replacedWord.substring(0, datastoreSperatorIndex + 1) + item.getLabel(), offset, replacedWord.length(), item.getLabel().length() + datastoreSperatorIndex + 1, aflp.getImage(item.getData()), item.getLabel(), null, null) : new CompletionProposal(item.getLabel(), offset, replacedWord.length(), item.getLabel().length(), aflp.getImage(item.getData()), item.getLabel(), null, null);
        return p;
    }

    protected ICompletionProposal[] createProposal(List<ISQLDictionary.Item> items, String replacedWord, int offset) {
        if (items == null || items.size() == 0) {
            return null;
        }
        return (ICompletionProposal[])items.stream().map(i -> this.createProposal((ISQLDictionary.Item)i, replacedWord, offset)).sorted(new ICompletionProposalComparator()).toArray(ICompletionProposal[]::new);
    }

    protected boolean checkCharacter(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '@' || c == '/' || c == '\"';
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        int currentOffset = offset - 1;
        StringBuilder currWord = new StringBuilder();
        try {
            char currChar;
            while (currentOffset >= 0 && this.checkCharacter(currChar = document.getChar(currentOffset))) {
                currWord.insert(0, currChar);
                --currentOffset;
            }
            String _currWord = currWord.toString();
            int datastoreSeparatorIndex = _currWord.indexOf(46);
            List<ISQLDictionary.Item> availableItems = this.getAvailableItems(_currWord, datastoreSeparatorIndex);
            ICompletionProposal[] proposals = this.createProposal(availableItems, _currWord, offset - currWord.length());
            return proposals;
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.sql", e.getMessage(), (Throwable)e), 1);
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.activationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    class ICompletionProposalComparator
    implements Comparator<ICompletionProposal> {
        ICompletionProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal i1, ICompletionProposal i2) {
            String s1 = i1.getDisplayString();
            String s2 = i2.getDisplayString();
            return Collator.getInstance().compare(s1, s2);
        }
    }
}

