/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors.export;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.editors.export.ExportDialog;
import com.indy.ui.sql.editors.export.ExportOptions;
import com.indy.ui.sql.editors.export.IExporter;
import com.indy.ui.sql.editors.export.Messages;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportAction
extends Action {
    private IExporter exporter;
    private ExportOptions exportOptions;
    private IResultModel model;

    public ExportAction(String text, IExporter exporter) {
        super(text);
        this.exporter = exporter;
        this.exportOptions = ExportOptions.instance;
    }

    public void run() {
        ExportDialog exportDialog = new ExportDialog(Display.getCurrent().getActiveShell(), this.exporter, this.exportOptions);
        if (exportDialog.open() != 0) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new ExportRunnable(exportDialog));
    }

    public void setResultModel(IResultModel model) {
        this.model = model;
    }

    private final class ExportRunnable
    implements Runnable {
        private final ExportDialog exportDialog;

        private ExportRunnable(ExportDialog exportDialog) {
            this.exportDialog = exportDialog;
        }

        @Override
        public void run() {
            try {
                File file = new File(this.exportDialog.getFilename());
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                ExportAction.this.exporter.export(ExportAction.this.model, ExportAction.this.exportOptions, file);
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.ui.sql", e.getMessage(), (Throwable)e), 1);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ExportDialog_Error, (String)e.getMessage());
                    }
                });
            }
        }
    }
}

