/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.internal;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.internal.ColumnBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RowBuilder {
    private ResultSet rs;
    private ResultSetMetaData rsmd;

    public static RowBuilder of(ResultSet rs) throws SQLException {
        return new RowBuilder(rs);
    }

    private RowBuilder(ResultSet rs) throws SQLException {
        this.rsmd = rs.getMetaData();
        this.rs = rs;
    }

    public IResultModel.Row[] buildRows(int maxRows) throws SQLException {
        ArrayList<RowImpl> rows = new ArrayList<RowImpl>();
        while (this.rs.next()) {
            if (maxRows != -1 && rows.size() >= maxRows) break;
            RowImpl currentRow = new RowImpl();
            rows.add(currentRow);
            int i = 0;
            while (i < this.rsmd.getColumnCount()) {
                Object o = this.readValue(i + 1);
                if (this.rs.wasNull()) {
                    currentRow.addValue(null);
                } else {
                    currentRow.addValue(o);
                }
                ++i;
            }
        }
        return rows.toArray(new IResultModel.Row[rows.size()]);
    }

    private Object readNaturalValue(int columnIndex) throws SQLException {
        return new Long(this.rs.getLong(columnIndex));
    }

    private Object readDecimalValue(int columnIndex) throws SQLException {
        int precision = this.rs.getMetaData().getPrecision(columnIndex);
        if (precision > 16 || precision < 1) {
            BigDecimal bd = this.rs.getBigDecimal(columnIndex);
            if (bd == null) {
                return bd;
            }
            return bd.stripTrailingZeros();
        }
        try {
            return this.rs.getDouble(columnIndex);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private Object readDateValue(int columnIndex) throws SQLException {
        int dataType = this.rsmd.getColumnType(columnIndex);
        try {
            switch (dataType) {
                case 91: {
                    try {
                        return this.rs.getTimestamp(columnIndex);
                    }
                    catch (Throwable e) {
                        return this.rs.getDate(columnIndex);
                    }
                }
                case 93: {
                    return this.rs.getTimestamp(columnIndex);
                }
                case 92: {
                    return this.rs.getTime(columnIndex);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    private Object readBinaryValue(int columnIndex) throws SQLException {
        InputStream is = this.rs.getBinaryStream(columnIndex);
        if (is == null) {
            return null;
        }
        int maxLength = 10000;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            int current;
            while ((current = is.read()) != -1) {
                if (maxLength <= 0 || data.size() < maxLength) {
                    data.write(current);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
        return data.toString();
    }

    private Object readCharsValue(int columnIndex) throws SQLException {
        Reader r = this.rs.getCharacterStream(columnIndex);
        if (r == null) {
            return null;
        }
        int maxLength = 10000;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[2048];
        try {
            int len;
            while ((len = r.read(buffer)) > -1) {
                if (maxLength > 0) {
                    if (sb.length() + len < maxLength) {
                        sb.append(buffer, 0, len);
                    } else {
                        sb.append(buffer, 0, maxLength - sb.length());
                    }
                    if (maxLength < sb.length()) continue;
                    break;
                }
                sb.append(buffer, 0, len);
            }
        }
        catch (IOException e) {
            return e.getMessage();
        }
        buffer = null;
        return sb.toString();
    }

    private Object readDefaultValue(int columnIndex) throws SQLException {
        return this.rs.getString(columnIndex);
    }

    private Object readValue(int columnIndex) throws SQLException {
        switch (ColumnBuilder.DataType.fromJDBCDataType(this.rsmd.getColumnType(columnIndex))) {
            case NATURAL: {
                return this.readNaturalValue(columnIndex);
            }
            case DECIMAL: {
                return this.readDecimalValue(columnIndex);
            }
            case DATE: {
                return this.readDateValue(columnIndex);
            }
            case BINARY: {
                return this.readBinaryValue(columnIndex);
            }
            case CHARACTER: {
                return this.readCharsValue(columnIndex);
            }
        }
        return this.readDefaultValue(columnIndex);
    }

    private class RowImpl
    implements IResultModel.Row {
        private List<Object> cellValues = new ArrayList<Object>();

        private RowImpl() {
        }

        private void addValue(Object value) {
            this.cellValues.add(value);
        }

        @Override
        public Object getColumnValue(int colIndex) {
            return this.cellValues.get(colIndex);
        }
    }
}

