/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui;

import com.indy.cross.ContainerLevel;
import com.indy.cross.CrossItem;
import com.indy.cross.CrossObjectType;
import com.indy.cross.registry.RegistryCrossItem;
import com.indy.cross.ui.LineageDraw2DHelper;
import com.indy.cross.ui.Messages;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;

public class LineageTreeBuilder {
    public static final Comparator<Node> NODE_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            return o1.label.compareTo(o2.label);
        }
    };
    protected HashMap<LineageDraw2DHelper.ConnectionWrapper, Collection<URI>> filesPerLink = new HashMap();
    public static final int FORWARD = 1;
    public static final int BACKWARD = 10;
    public static final int FULL_DEPTH = -1;
    private HashMap<String, Node> nodeMap = new HashMap();
    private HashMap<Integer, HashMap<String, Node>> idsPerRank = new HashMap();
    private Collection<Node> allNodes = new HashSet<Node>();
    private Collection<Node> rootNodes = new ArrayList<Node>();
    private ResourceSet resourceSet;
    private Set<ContainerLevel> availableContainerLevels = new HashSet<ContainerLevel>();
    private ContainerLevel activeLevel = null;

    public LineageTreeBuilder() {
        this.resourceSet = new ResourceSetImpl();
        Map loadOptions = this.resourceSet.getLoadOptions();
        loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
    }

    public Collection<URI> getModelsPath4Source(Node from, Node source) {
        LineageDraw2DHelper.ConnectionWrapper w = new LineageDraw2DHelper.ConnectionWrapper(source, from);
        return this.filesPerLink.get(w);
    }

    public Collection<URI> getModelsPath4Target(Node from, Node trg) {
        LineageDraw2DHelper.ConnectionWrapper w = new LineageDraw2DHelper.ConnectionWrapper(from, trg);
        return this.filesPerLink.get(w);
    }

    public void readNext(Node startNode, IProgressMonitor monitor) throws InterruptedException {
        if (startNode.getOrientation() == 10) {
            if (!startNode.isSrcSynchronized()) {
                this.synchronizeSource(startNode, startNode.getRank() - 1, monitor, 1);
            }
        } else if (startNode.getOrientation() == 1 && !startNode.isTrgSynchronized()) {
            this.synchronizeTarget(startNode, startNode.getRank() + 1, monitor, 1);
        }
    }

    private boolean hasSource(Node startNode, IProgressMonitor monitor) throws InterruptedException {
        if (startNode instanceof GhostNode) {
            return false;
        }
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ICrossReference.class);
        String eltID = CacheHelper.extractEltID((String)startNode.getObjectId());
        String fileID = CacheHelper.extractFileID((String)startNode.getObjectId());
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        List<URI> files = this.getUsageFiles(fileID, eltID);
        for (URI uri : files) {
            if (!"map".equals(uri.fileExtension()) && !"proc".equals(uri.fileExtension()) && !"md".equals(uri.fileExtension())) continue;
            String mapFileID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            List items = registry.find((IRegistryService.IRegistryMatcher)new RegistryCrossItem.Matcher(mapFileID, fileID, eltID, this.resourceSet));
            for (ICrossReference i : items) {
                CrossItem _it = (CrossItem)i.adapt(CrossItem.class);
                if (_it.getSource().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTarget(Node startNode, IProgressMonitor monitor) throws InterruptedException {
        if (startNode instanceof GhostNode) {
            return false;
        }
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ICrossReference.class);
        String eltID = CacheHelper.extractEltID((String)startNode.getObjectId());
        String fileID = CacheHelper.extractFileID((String)startNode.getObjectId());
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        List<URI> files = this.getUsageFiles(fileID, eltID);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        for (URI uri : files) {
            SubMonitor m = sub.newChild(1);
            m.setTaskName(Messages.LineageTreeBuilder_7 + uri.path());
            if (!"map".equals(uri.fileExtension()) && !"proc".equals(uri.fileExtension()) && !"md".equals(uri.fileExtension())) continue;
            String mapFileID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            List items = registry.find((IRegistryService.IRegistryMatcher)new RegistryCrossItem.Matcher(mapFileID, fileID, eltID, this.resourceSet));
            for (ICrossReference i : items) {
                CrossItem _it = (CrossItem)i.adapt(CrossItem.class);
                if (_it.getTarget().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private List<URI> getUsageFiles(String fileID, String eltID) {
        ArrayList<URI> files = new ArrayList<URI>();
        try {
            URI f = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getResourceURIByFileId(fileID);
            if (f == null && "UUID_REGISTRY_UDF".equals(fileID)) {
                files.addAll(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsageFiles4UDF(eltID));
            } else {
                files.addAll(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().getUsage(f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return files;
    }

    private Collection<Node> getSources(Node startNode, Integer rank, IProgressMonitor monitor) throws InterruptedException {
        if (startNode instanceof GhostNode) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ICrossReference.class);
        String eltID = CacheHelper.extractEltID((String)startNode.getObjectId());
        String fileID = CacheHelper.extractFileID((String)startNode.getObjectId());
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        List<URI> files = this.getUsageFiles(fileID, eltID);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        sub.setTaskName(Messages.LineageTreeBuilder_11 + startNode.getFullPath());
        for (URI uri : files) {
            if ("map".equals(uri.fileExtension()) || "proc".equals(uri.fileExtension()) || "md".equals(uri.fileExtension())) {
                String mapFileID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                List items = registry.find((IRegistryService.IRegistryMatcher)new RegistryCrossItem.Matcher(mapFileID, fileID, eltID, this.resourceSet));
                if (!items.isEmpty()) {
                    for (ICrossReference i : items) {
                        CrossItem _it = (CrossItem)i.adapt(CrossItem.class);
                        if (_it.getProperty().get((Object)"containerLevel") != null) {
                            String[] stringArray = ((String)_it.getProperty().get((Object)"containerLevel")).split(",");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                startNode.containerLevel.add(s);
                                ++n2;
                            }
                        }
                        for (CrossItem it : ((CrossItem)i.adapt(CrossItem.class)).getSource()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            Node n = this.createNode(it, 10, rank);
                            LineageDraw2DHelper.ConnectionWrapper w = new LineageDraw2DHelper.ConnectionWrapper(n, startNode);
                            Collection<URI> c = this.filesPerLink.get(w);
                            if (c == null) {
                                c = new HashSet<URI>();
                                this.filesPerLink.put(w, c);
                            }
                            c.add(uri);
                            res.add(n);
                        }
                    }
                }
            }
            sub.worked(1);
        }
        return res;
    }

    private Collection<Node> getTargets(Node startNode, Integer rank, IProgressMonitor monitor) throws InterruptedException {
        if (startNode instanceof GhostNode) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        IRegistryService.IRegistry registry = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(ICrossReference.class);
        String eltID = CacheHelper.extractEltID((String)startNode.getObjectId());
        String fileID = CacheHelper.extractFileID((String)startNode.getObjectId());
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        List<URI> files = this.getUsageFiles(fileID, eltID);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
        sub.setTaskName(Messages.LineageTreeBuilder_16 + startNode.getFullPath());
        for (URI uri : files) {
            if ("map".equals(uri.fileExtension()) || "proc".equals(uri.fileExtension()) || "md".equals(uri.fileExtension())) {
                String mapFileID = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getSourceId(uri);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                List items = registry.find((IRegistryService.IRegistryMatcher)new RegistryCrossItem.Matcher(mapFileID, fileID, eltID, this.resourceSet));
                if (!items.isEmpty()) {
                    for (ICrossReference i : items) {
                        CrossItem _it = (CrossItem)i.adapt(CrossItem.class);
                        if (_it.getProperty().get((Object)"containerLevel") != null) {
                            String[] stringArray = ((String)_it.getProperty().get((Object)"containerLevel")).split(",");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String s = stringArray[n2];
                                startNode.containerLevel.add(s);
                                ++n2;
                            }
                        }
                        for (CrossItem it : _it.getTarget()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            Node n = this.createNode(it, 1, rank);
                            LineageDraw2DHelper.ConnectionWrapper w = new LineageDraw2DHelper.ConnectionWrapper(startNode, n);
                            Collection<URI> c = this.filesPerLink.get(w);
                            if (c == null) {
                                c = new HashSet<URI>();
                                this.filesPerLink.put(w, c);
                            }
                            c.add(uri);
                            res.add(n);
                        }
                    }
                }
            }
            sub.worked(1);
        }
        return res;
    }

    private Node createNode(CrossItem item, int orientation, Integer rank) {
        Node n = this.nodeMap.get(item.getId());
        if (n == null) {
            n = new Node(item.getId(), (String)item.getProperty().get((Object)"name"), (String)item.getProperty().get((Object)"level"), (String)item.getProperty().get((Object)"productCode"), item.getFullPath(), orientation, rank, item.getType() == CrossObjectType.METADATALINK, (String)item.getProperty().get((Object)"containerLevel"));
            this.nodeMap.put(n.getObjectId(), n);
            HashMap<String, Node> map = this.idsPerRank.get(rank);
            if (map == null) {
                map = new HashMap();
                this.idsPerRank.put(rank, map);
            }
            map.put(n.getObjectId(), n);
            this.allNodes.add(n);
        } else {
            HashMap<String, Node> map;
            String lvls = (String)item.getProperty().get((Object)"containerLevel");
            if (lvls != null) {
                String[] stringArray = lvls.split(",");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String s = stringArray[n3];
                    n.containerLevel.add(s);
                    ++n3;
                }
            }
            if ((map = this.idsPerRank.get(rank)) == null) {
                map = new HashMap();
                this.idsPerRank.put(rank, map);
                String string = n.getObjectId();
                n = new GhostNode(n, orientation, rank);
                map.put(string, n);
                this.allNodes.add(n);
            } else {
                Node nRank = map.get(n.getObjectId());
                if (nRank != null) {
                    n = nRank;
                } else {
                    String string = n.getObjectId();
                    n = new GhostNode(n, orientation, rank);
                    map.put(string, n);
                    this.allNodes.add(n);
                }
            }
        }
        return n;
    }

    private Node createNode(MdNode node) {
        String id = CacheHelper.extractEltID((EObject)node) + "?fileId=" + CacheHelper.extractFileID((EObject)node) + "?";
        if (node.eResource() instanceof IRegistryService.IRegistrationContribution && ((IRegistryService.IRegistrationContribution)node.eResource()).getContributedRegistries().contains(UDF.class)) {
            for (UDF udf : ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(UDF.class).getAll()) {
                if (!udf.getMdNodeSourceURI().fragment().equals(node.eResource().getURIFragment((EObject)node))) continue;
                id = CacheHelper.extractEltID((String)udf.getURI().fragment()) + "?fileId=" + CacheHelper.extractFileID((String)udf.getURI().fragment()) + "?";
                break;
            }
        }
        String productCode = null;
        try {
            productCode = node.evaluateXpathExpressionCached("INTERN_PRODUCT_CODE_GUI", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> levels = new HashSet<String>();
        ContainerLevel[] containerLevelArray = ContainerLevel.values();
        int n = containerLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContainerLevel l = containerLevelArray[n2];
            try {
                Configuration c = node.evaluateXpathExpressionMdNode("INTERNAL_MD_CONTAINER_NODE_" + l.name());
                if (c instanceof MdNode && c == node && !this.availableContainerLevels.contains(l)) {
                    this.availableContainerLevels.add(l);
                    levels.add(l.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        Node n3 = new Node(id, node.getName(), node.getLevel().getCode(), productCode, node.getFullPath(false), -1, 0, false, null);
        n3.containerLevel.addAll(levels);
        this.nodeMap.put(n3.getObjectId(), n3);
        HashMap<String, Node> map = this.idsPerRank.get(0);
        if (map == null) {
            map = new HashMap();
            this.idsPerRank.put(0, map);
        }
        if (map.get(n3.getObjectId()) == null) {
            map.put(n3.getObjectId(), n3);
        }
        return n3;
    }

    public Collection<Node> buildTree(IProgressMonitor monitor, Collection inputs, int recursiveDepth) throws Exception {
        this.availableContainerLevels.clear();
        this.activeLevel = null;
        ArrayList<Node> res = new ArrayList<Node>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        for (Object o : inputs) {
            if (!(o instanceof MdNode)) continue;
            Node nn = this.createNode((MdNode)o);
            this.rootNodes.add(nn);
            res.add(nn);
            sub.subTask(Messages.LineageTreeBuilder_24);
            res.addAll(this.synchronizeTarget(nn, 1, (IProgressMonitor)sub.newChild(1), recursiveDepth));
            sub.worked(1);
            sub.subTask(Messages.LineageTreeBuilder_25);
            res.addAll(this.synchronizeSource(nn, -1, (IProgressMonitor)sub.newChild(1), recursiveDepth));
            sub.worked(1);
        }
        for (Node n : this.rootNodes) {
            for (String s : n.getContainerLevelNames()) {
                ContainerLevel l = ContainerLevel.getByName((String)s);
                if (l == null) continue;
                this.availableContainerLevels.add(l);
            }
        }
        if (this.availableContainerLevels.size() > 0) {
            for (ContainerLevel l : this.availableContainerLevels) {
                if (this.activeLevel != null && this.activeLevel.ordinal() >= l.ordinal()) continue;
                this.activeLevel = l;
            }
        }
        return res;
    }

    public Collection<ContainerLevel> getAvailableLevels() {
        return this.availableContainerLevels;
    }

    public ContainerLevel getActiveContainerLevel() {
        return this.activeLevel;
    }

    private Collection<Node> synchronizeTarget(Node nn, Integer rank, IProgressMonitor monitor, int depth) throws InterruptedException {
        HashSet<Node> res = new HashSet<Node>();
        SubMonitor sub = null;
        sub = depth <= 0 ? SubMonitor.convert((IProgressMonitor)monitor) : (Math.abs(rank) + 1 <= depth ? SubMonitor.convert((IProgressMonitor)monitor, (int)(depth - (Math.abs(rank) + 1))) : SubMonitor.convert((IProgressMonitor)monitor));
        for (Node n : this.getTargets(nn, rank, (IProgressMonitor)sub.newChild(1))) {
            if (monitor != null && monitor.isCanceled()) {
                throw new CancellationException();
            }
            res.add(n);
            if (!nn.getTargets().contains(n)) {
                nn.getTargets().add(n);
            }
            if (!n.getSources().contains(nn)) {
                n.getSources().add(nn);
            }
            if (!(n instanceof GhostNode)) {
                this.nodeMap.put(n.getObjectId(), n);
            }
            if (!(n instanceof GhostNode || depth > 0 && Math.abs(rank) + 1 > depth)) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                res.addAll(this.synchronizeTarget(n, rank + 1, (IProgressMonitor)sub.newChild(1), depth));
                continue;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.hasTarget(n, (IProgressMonitor)sub.newChild(1))) continue;
            n.syncTrg = true;
        }
        nn.syncTrg = true;
        return res;
    }

    private Collection<Node> synchronizeSource(Node nn, Integer rank, IProgressMonitor monitor, int depth) throws InterruptedException {
        HashSet<Node> res = new HashSet<Node>();
        SubMonitor sub = null;
        sub = depth <= 0 ? SubMonitor.convert((IProgressMonitor)monitor) : (Math.abs(rank) + 1 <= depth ? SubMonitor.convert((IProgressMonitor)monitor, (int)(depth - (Math.abs(rank) + 1))) : SubMonitor.convert((IProgressMonitor)monitor));
        for (Node n : this.getSources(nn, rank, (IProgressMonitor)sub.newChild(1))) {
            if (monitor != null && monitor.isCanceled()) {
                throw new CancellationException();
            }
            if (!nn.getSources().contains(n)) {
                nn.getSources().add(n);
            }
            if (!n.getSources().contains(nn)) {
                n.getTargets().add(nn);
            }
            res.add(n);
            if (!(n instanceof GhostNode)) {
                this.nodeMap.put(n.getObjectId(), n);
            }
            if (!(n instanceof GhostNode || depth > 0 && Math.abs(rank) + 1 > depth)) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                res.addAll(this.synchronizeSource(n, rank - 1, (IProgressMonitor)sub.newChild(1), depth));
                continue;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.hasSource(n, (IProgressMonitor)sub)) continue;
            n.syncSrc = true;
        }
        nn.syncSrc = true;
        return res;
    }

    class GhostNode
    extends Node {
        private Node baseNode;

        public GhostNode(Node baseNode, int orientation, int rank) {
            super(baseNode.getObjectId(), baseNode.getLabel(), baseNode.getLevelCode(), baseNode.getProduct(), baseNode.getFullPath(), orientation, rank, baseNode.isMdLink(), null);
            this.baseNode = baseNode;
        }

        @Override
        public Collection<String> getContainerLevelNames() {
            return this.baseNode.getContainerLevelNames();
        }

        public Node getBaseNode() {
            return this.baseNode;
        }
    }

    public class Node
    implements IAdaptable {
        private Collection<Node> targets = new HashSet<Node>();
        private Collection<Node> sources = new HashSet<Node>();
        private boolean startingPoint = false;
        private Collection<Node> children = new HashSet<Node>();
        private Node parent;
        private String objectId;
        private String label;
        private String lvlCode;
        private String product;
        private String fullPath;
        protected int ORIENTATION = -1;
        protected boolean syncSrc = false;
        protected boolean syncTrg = false;
        protected boolean isMdLink = false;
        private int rank;
        protected Set<String> containerLevel = new HashSet<String>();
        private IFile fileModel;
        private URI fileURI;

        public Node(String objectId, String label, String lvlCode, String product, String fullPath, int ORIENTATION, int rank, boolean isMdLink, String containerLevel) {
            this.objectId = objectId;
            this.isMdLink = isMdLink;
            this.label = label == null ? "" : URI.decode((String)label);
            this.lvlCode = lvlCode;
            if (containerLevel != null) {
                String[] stringArray = containerLevel.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.containerLevel.add(s);
                    ++n2;
                }
            }
            this.ORIENTATION = ORIENTATION;
            this.rank = rank;
            this.product = product;
            this.fullPath = fullPath;
        }

        public boolean isMdLink() {
            return this.isMdLink;
        }

        public int getRank() {
            return this.rank;
        }

        public boolean isSrcSynchronized() {
            return this.syncSrc;
        }

        public boolean isTrgSynchronized() {
            return this.syncTrg;
        }

        public int getOrientation() {
            return this.ORIENTATION;
        }

        public Node getParent() {
            return this.parent;
        }

        public Collection<Node> getChildren() {
            return this.children;
        }

        public Node getRoot() {
            Node n = this;
            while (n.getParent() != null) {
                n = n.getParent();
            }
            return n;
        }

        public Collection<Node> getDescendants() {
            HashSet<Node> res = new HashSet<Node>();
            for (Node n : this.getChildren()) {
                res.add(n);
                res.addAll(n.getDescendants());
            }
            return res;
        }

        public Collection<String> getContainerLevelNames() {
            return this.containerLevel;
        }

        public Collection<Node> getTargets() {
            return this.targets;
        }

        public Collection<Node> getSources() {
            return this.sources;
        }

        public void sort() {
            this.sources = new ArrayList<Node>(this.sources);
            this.targets = new ArrayList<Node>(this.targets);
            Collections.sort((List)this.sources, NODE_COMPARATOR);
            Collections.sort((List)this.targets, NODE_COMPARATOR);
        }

        public boolean isStartingPoint() {
            return this.startingPoint || this.getOrientation() == -1;
        }

        public void removeSource(Node source) {
            if (this.sources.remove(source)) {
                this.sources.addAll(source.getSources());
                for (Node n : source.getSources()) {
                    if (n == source) continue;
                    n.getTargets().add(this);
                }
            }
        }

        public void removeTarget(Node target) {
            if (this.targets.remove(target)) {
                this.targets.addAll(target.getTargets());
                for (Node n : target.getTargets()) {
                    if (n == target) continue;
                    n.getSources().add(this);
                }
            }
        }

        public URI getFileURI() {
            if (this.fileURI == null) {
                this.fileURI = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((String)this.objectId));
            }
            return this.fileURI;
        }

        public String getWrappedObjectFileLocation() {
            if (this.fileModel == null) {
                this.refreshFileModel();
            }
            return this.fileModel.getFullPath().toOSString();
        }

        private void refreshFileModel() {
            this.fileModel = Util.convertEMFURIToFile((URI)((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((String)this.objectId)));
            if (this.fileModel == null && this.objectId.contains("!")) {
                String[] p = CacheHelper.extractEltID((String)this.objectId).split("!");
                this.fileModel = Util.convertEMFURIToFile((URI)((UDF)((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(UDF.class).find((IRegistryService.IRegistryMatcher)new UDF.UDFMatcher(p[0] + "::" + p[1], Integer.valueOf(p[2]).intValue())).get(0)).getMdNodeSourceURI());
            }
        }

        public String getLevelCode() {
            return this.lvlCode;
        }

        public String getLabel() {
            return this.label;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public String getProduct() {
            return this.product == null ? "" : this.product;
        }

        public String getFullPath() {
            return this.fullPath == null ? "" : this.fullPath;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == EObject.class && this.fileURI != null && this.objectId != null) {
                URI uri = this.fileURI.appendFragment(this.objectId);
                try {
                    return LineageTreeBuilder.this.resourceSet.getEObject(uri, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

