/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.reverse;

import com.indy.md.ui.editor.reverse.CompareContentProvider;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class MdDiffBuilder {
    public static void buildTree(IncrementalReverser.DefaulteverseMatchingStrategy defaultReverseMode, MdDiffNode currentDiff, Set<String> defTypeToIgnore, Collection<String> attributeCodeIgnored, Map<String, IncrementalReverser.IReverseMatchingStrategy> nodeMatchingMap) {
        ArrayList<MdDiffNode> children = new ArrayList<MdDiffNode>();
        if (currentDiff.getState() == MdDiffNode.State.NEW) {
            node = currentDiff.getNewNode();
            for (MdNode childNode : node.getNode()) {
                if (defTypeToIgnore.contains(childNode.getDefType())) continue;
                nodeMatchingMode = nodeMatchingMap != null && nodeMatchingMap.containsKey(childNode.getDefType()) ? nodeMatchingMap.get(childNode.getDefType()) : defaultReverseMode;
                children.add(new MdDiffNode(currentDiff, null, childNode, attributeCodeIgnored, nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition));
            }
        } else if (currentDiff.getState() == MdDiffNode.State.OLD) {
            node = currentDiff.getOldNode();
            for (MdNode childNode : node.getNode()) {
                if (defTypeToIgnore.contains(childNode.getDefType())) continue;
                nodeMatchingMode = nodeMatchingMap != null && nodeMatchingMap.containsKey(childNode.getDefType()) ? nodeMatchingMap.get(childNode.getDefType()) : defaultReverseMode;
                children.add(new MdDiffNode(currentDiff, childNode, null, attributeCodeIgnored, nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition));
            }
        } else {
            Object nodeMatchingMode;
            MdNode newNode = currentDiff.getNewNode();
            MdNode oldNode = currentDiff.getOldNode();
            ArrayList<MdNode> handledFromNew = new ArrayList<MdNode>();
            for (MdNode oldChild : oldNode.getNode()) {
                if (defTypeToIgnore.contains(oldChild.getDefType())) continue;
                nodeMatchingMode = nodeMatchingMap != null && nodeMatchingMap.containsKey(oldChild.getDefType()) ? nodeMatchingMap.get(oldChild.getDefType()) : defaultReverseMode;
                MdNode newChild = null;
                newChild = MdDiffBuilder.findNewChild(newNode, oldChild, (IncrementalReverser.IReverseMatchingStrategy)nodeMatchingMode);
                if (newChild != null) {
                    handledFromNew.add(newChild);
                }
                children.add(new MdDiffNode(currentDiff, oldChild, newChild, attributeCodeIgnored, nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition));
            }
            for (MdNode newChild : newNode.getNode()) {
                if (defTypeToIgnore.contains(newChild.getDefType()) || handledFromNew.contains(newChild)) continue;
                nodeMatchingMode = nodeMatchingMap != null && nodeMatchingMap.containsKey(newChild.getDefType()) ? nodeMatchingMap.get(newChild.getDefType()) : defaultReverseMode;
                MdNode oldChild = MdDiffBuilder.findNewChild(oldNode, newChild, (IncrementalReverser.IReverseMatchingStrategy)nodeMatchingMode);
                children.add(new MdDiffNode(currentDiff, oldChild, newChild, defTypeToIgnore, nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition));
            }
        }
        Collections.sort(children, CompareContentProvider.comparator);
        for (MdDiffNode n : children) {
            MdDiffBuilder.buildTree(defaultReverseMode, n, defTypeToIgnore, attributeCodeIgnored, nodeMatchingMap);
        }
    }

    private static MdNode findNewChild(MdNode newNode, MdNode oldChild, IncrementalReverser.IReverseMatchingStrategy nodeMatchingMode) {
        for (MdNode child : newNode.getNodeByCode(oldChild.getDefType())) {
            if (!nodeMatchingMode.getMatcher().match(oldChild, child)) continue;
            return child;
        }
        return null;
    }
}

