/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.presentation;

import com.indy.md.ui.editor.ui.MdMenuUtil;
import com.indy.ui.custom.out.tools.MenuManagerCleaner;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.presentation.Messages;
import com.stambia.md.provider.MdEditPlugin;
import com.stambia.tech.Level;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorActionBars;

public class MdActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(MdEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MdActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                MdEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(MdEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MdActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (MdActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)MdActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    private IMenuManager customActionMenuManager;
    private Collection<IAction> customActions;
    private Collection<IAction> customChildActions;
    private IMenuManager changeToMenuManager;
    private Collection<IAction> changeToActions;
    private Collection<IAction> customCreateFileActions;

    public MdActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("md-settings"));
        toolBarManager.add((IContributionItem)new Separator("md-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        if (menuManager.getId().equals("org.eclipse.ui.main.menu")) {
            return;
        }
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_MdEditor_menu"), "com.stambia.mdMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        this.customActionMenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_Custom_Md_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.customActionMenuManager);
        this.changeToMenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_Change_To_Md_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.changeToMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
            this.activeEditor = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.depopulateAll();
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 1) {
            boolean allMdLinkCapabilities = true;
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (o instanceof MetaDataLinkCapability) continue;
                allMdLinkCapabilities = false;
                break;
            }
            if (allMdLinkCapabilities) {
                this.customActions = new ArrayList<IAction>();
                this.customActions.addAll(MdMenuUtil.getExecutableAction(((IStructuredSelection)selection).toList(), Display.getCurrent().getActiveShell(), true, false));
            } else {
                this.customActions = null;
            }
            this.customCreateFileActions = null;
            this.customChildActions = new ArrayList<IAction>();
            this.changeToActions = null;
            this.createChildActions = null;
            this.createSiblingActions = null;
            return;
        }
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            for (Object o : newChildDescriptors) {
                if (!(o instanceof CommandParameter) || ((CommandParameter)o).getEStructuralFeature() != MdPackage.eINSTANCE.getMdNode_MetaDataLink()) continue;
                newChildDescriptors.remove(o);
                break;
            }
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
            if (object instanceof MetaDataLinkCapability) {
                IAction wizard;
                this.customActions = new ArrayList<IAction>();
                IAction properties = MdMenuUtil.getPropertyPageAction(selection);
                if (properties != null) {
                    this.customActions.add(properties);
                }
                if ((wizard = MdMenuUtil.getWizardAction(selection)) != null) {
                    this.customActions.add(wizard);
                }
                this.customActions.addAll(MdMenuUtil.getCreateChildWizard(selection, false));
                this.customActions.addAll(MdMenuUtil.getExecutableAction((MetaDataLinkCapability)object, Display.getCurrent().getActiveShell(), true, false));
                this.customChildActions = new ArrayList<IAction>();
                this.customChildActions.addAll(MdMenuUtil.getCreateChildWizard(selection, true));
            } else {
                this.customActions = null;
            }
            if (object instanceof MdNode) {
                this.customCreateFileActions = MdMenuUtil.getCreateFileAction((MdNode)object, this.selectionProvider.getSelection());
                this.changeToActions = MdMenuUtil.getChangeToAction(selection);
            } else {
                this.changeToActions = null;
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.customCreateFileActions, null);
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
        if (this.customActionMenuManager != null) {
            this.populateManager((IContributionManager)this.customActionMenuManager, this.customActions, null);
            this.customActionMenuManager.update(true);
        }
        if (this.changeToMenuManager != null) {
            this.populateManager((IContributionManager)this.changeToMenuManager, this.changeToActions, null);
            this.changeToMenuManager.update(true);
        }
    }

    private void depopulateAll() {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.customCreateFileActions);
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.customChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        if (this.customActionMenuManager != null) {
            this.depopulateManager((IContributionManager)this.customActionMenuManager, this.customActions);
        }
        if (this.changeToMenuManager != null) {
            this.depopulateManager((IContributionManager)this.changeToMenuManager, this.changeToActions);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                CommandParameter cp = (CommandParameter)descriptor;
                CreateChildAction action = new CreateChildAction(this.activeEditorPart, selection, descriptor);
                if (cp.getValue() instanceof Configuration && ((StructuredSelection)selection).getFirstElement() instanceof MdNode) {
                    this.updAction((IAction)action, (MdNode)((StructuredSelection)selection).getFirstElement(), (Configuration)cp.getValue());
                }
                if (cp.feature == MdPackage.eINSTANCE.getMdNode_Template()) continue;
                actions.add((IAction)action);
            }
        }
        return actions;
    }

    protected void updAction(IAction action, MdNode parent, Configuration child) {
        Level level = null;
        level = !(child instanceof MdNode) ? parent.getLevel() : child.getLevel(parent.eResource());
        boolean isConfiguration = false;
        if (level != null) {
            if (level.getDisplayName() != null) {
                if (!(child instanceof MdNode)) {
                    action.setText(Messages.bind((String)Messages.MdActionBarContributor_25, (Object)level.getDisplayName()));
                    isConfiguration = true;
                } else {
                    action.setText(level.getDisplayName());
                }
            }
            if (level.getIcon() != null && !level.getIcon().equals("")) {
                URL im2 = level.getIconURL();
                ImageDescriptor desc = null;
                if (isConfiguration) {
                    ArrayList<Object> images = new ArrayList<Object>();
                    images.add(ExtendedImageRegistry.getInstance().getImageDescriptor((Object)im2));
                    images.add(MdEditPlugin.INSTANCE.getImage("full/custom/16x16/conf_decoration.png"));
                    ComposedImage im = new ComposedImage(images);
                    desc = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)im);
                } else {
                    desc = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)im2);
                }
                action.setImageDescriptor(desc);
            }
        }
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                CommandParameter cp = (CommandParameter)descriptor;
                CreateSiblingAction action = new CreateSiblingAction(this.activeEditorPart, selection, descriptor);
                if (cp.getValue() instanceof Configuration && ((StructuredSelection)selection).getFirstElement() instanceof MdNode) {
                    this.updAction((IAction)action, (MdNode)((StructuredSelection)selection).getFirstElement(), (Configuration)cp.getValue());
                }
                actions.add((IAction)action);
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_Custom_Md_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.customActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_Change_To_Md_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.changeToActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        submenuManager.add((IContributionItem)new Separator("md.custom.createChild"));
        this.populateManager((IContributionManager)submenuManager, this.customChildActions, null);
        submenuManager.add((IContributionItem)new Separator());
        this.populateManager((IContributionManager)submenuManager, this.customCreateFileActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(MdEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        submenuManager.setVisible(false);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
        MenuManagerCleaner.removeEmfEditorEntries((IMenuManager)menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.depopulateAll();
        ((EditorActionBars)this.getActionBars()).clearGlobalActionHandlers();
        ((EditorActionBars)this.getActionBars()).deactivate();
        ((EditorActionBars)this.getActionBars()).setEditorContributor(null);
        this.validateAction = null;
        this.copyAction = null;
        this.cutAction = null;
        this.deleteAction = null;
        this.redoAction = null;
        this.undoAction = null;
        this.selectionProvider = null;
        this.pasteAction = null;
        this.controlAction = null;
        this.loadResourceAction = null;
        if (this.createChildActions != null) {
            this.createChildActions.clear();
        }
        this.createChildActions = null;
        if (this.createChildMenuManager != null) {
            this.createChildMenuManager.dispose();
        }
        this.createChildMenuManager = null;
        if (this.createSiblingActions != null) {
            this.createSiblingActions.clear();
        }
        this.createSiblingActions = null;
        if (this.createSiblingMenuManager != null) {
            this.createSiblingMenuManager.dispose();
        }
        this.createSiblingMenuManager = null;
        if (this.customActions != null) {
            this.customActions.clear();
        }
        this.customActions = null;
        if (this.customChildActions != null) {
            this.customChildActions.clear();
        }
        this.customChildActions = null;
        if (this.customCreateFileActions != null) {
            this.customCreateFileActions.clear();
        }
        this.customCreateFileActions = null;
        if (this.customActionMenuManager != null) {
            this.customActionMenuManager.dispose();
        }
        this.customActionMenuManager = null;
        if (this.changeToMenuManager != null) {
            this.changeToMenuManager.dispose();
        }
        if (this.changeToActions != null) {
            this.changeToActions.clear();
        }
        this.refreshViewerAction = null;
        this.showPropertiesViewAction = null;
        try {
            this.init(null);
        }
        catch (Exception exception) {}
        try {
            ((EditorActionBars)this.getActionBars()).setEditorContributor(null);
        }
        catch (Exception exception) {}
    }
}

