/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.ui.mapper;

import com.indy.gmf.map.edit.provider.custom.MapperAdapter;
import com.indy.map.ComputedField;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.QueryField;
import com.indy.map.ref.RLogicalField;
import com.indy.ui.custom.out.common.FilterViewerHelper;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FilteredViewerComponent {
    private TreeViewer viewer;
    private PatternFilter viewerFilter;
    private Composite main;
    private Listener handler;
    private MapperAdapter.LabelProviderHelper imageProvider;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Mode mode;
    private Color selectionColor = null;
    private Color lightSelectionColor = null;
    private Color srcColor = null;
    private Color trgColor = null;
    private Collection<Object> itemsToColor = Collections.EMPTY_LIST;
    private SortingMode sortingMode = SortingMode.ALPHA;
    private boolean disableFilter = false;
    Object hovered;

    public FilteredViewerComponent(TabbedPropertySheetWidgetFactory widgetFactory, Mode mode) {
        this.widgetFactory = widgetFactory;
        this.mode = mode;
    }

    public void setSortingMode(SortingMode mode) {
        if (mode != this.sortingMode) {
            this.sortingMode = mode;
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                Object[] exp = this.viewer.getExpandedElements();
                ISelection s = this.viewer.getSelection();
                this.viewer.collapseAll();
                this.viewer.refresh();
                this.viewer.setExpandedElements(exp);
                if (!s.isEmpty()) {
                    this.viewer.reveal(((IStructuredSelection)s).getFirstElement());
                    this.viewer.setSelection(s);
                }
            }
        }
    }

    public Composite createControl(Composite parent) {
        if (this.selectionColor == null || this.selectionColor.isDisposed()) {
            this.selectionColor = new Color((Device)parent.getDisplay(), StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.sourceColor.selected", "#000000", new IScopeContext[]{InstanceScope.INSTANCE})));
            this.srcColor = new Color((Device)parent.getDisplay(), StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.sourceColor", "#000000", new IScopeContext[]{InstanceScope.INSTANCE})));
            this.trgColor = new Color((Device)parent.getDisplay(), StringConverter.asRGB((String)Platform.getPreferencesService().getString("com.indy.gmf.map.diagram", "Appearance.targetColor", "#000000", new IScopeContext[]{InstanceScope.INSTANCE})));
            this.lightSelectionColor = new Color(null, (this.selectionColor.getRed() + 192) / 2, (this.selectionColor.getGreen() + 192) / 2, (this.selectionColor.getBlue() + 192) / 2);
        }
        this.main = this.widgetFactory.createComposite(parent);
        this.main.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredViewerComponent.this.selectionColor.dispose();
                FilteredViewerComponent.this.lightSelectionColor.dispose();
                FilteredViewerComponent.this.srcColor.dispose();
                FilteredViewerComponent.this.trgColor.dispose();
            }
        });
        GridLayout gl = null;
        gl = new GridLayout();
        this.main.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        Text filter = this.widgetFactory.createText(this.main, "", 2048);
        filter.setLayoutData((Object)new GridData(4, 1, true, false));
        filter.addModifyListener((ModifyListener)new FilterViewerHelper.FilterTextModifyListener(true, 100){

            protected void doFilter(ModifyEvent e) {
                if (FilteredViewerComponent.this.disableFilter) {
                    return;
                }
                String pattern = ((Text)e.widget).getText();
                if (pattern.trim().isEmpty()) {
                    pattern = null;
                }
                FilteredViewerComponent.this.viewerFilter.setPattern(pattern);
                FilteredViewerComponent.this.viewer.refresh();
                if (pattern == null) {
                    FilteredViewerComponent.this.viewer.expandAll();
                }
                FilteredViewerComponent.this.handler.handleRepaint();
            }
        });
        this.viewer = new TreeViewer(this.widgetFactory.createTree(this.main, 68352));
        this.viewer.setUseHashlookup(true);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IContainer) {
                    return !((IContainer)element).getLogicalField().isEmpty();
                }
                if (element instanceof Field) {
                    return !((Field)element).getChildren().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof Field) {
                    return ((Field)element).getParent() != null ? ((Field)element).getParent() : ((Field)element).eContainer();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Collection c = (Collection)inputElement;
                return c.toArray(new Object[c.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList c = null;
                if (parentElement instanceof IContainer) {
                    if (c == null) {
                        ArrayList l = new ArrayList();
                        l.addAll(((IContainer)parentElement).getLogicalField());
                        if (((IContainer)parentElement).getComputedField() != null) {
                            l.addAll(((IContainer)parentElement).getComputedField());
                        }
                        l.removeAll(l.stream().filter(f -> f instanceof Field && ((Field)f).getParent() != null).collect(Collectors.toSet()));
                        c = l;
                    }
                } else if (parentElement instanceof Field) {
                    c = ((Field)parentElement).getChildren();
                }
                if (c != null) {
                    return c.toArray(new Object[c.size()]);
                }
                return null;
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                if (e1.getClass() == e2.getClass() && (e1 instanceof Field || e1 instanceof QueryField)) {
                    boolean mappingOrder;
                    boolean bl = mappingOrder = FilteredViewerComponent.this.sortingMode != SortingMode.ALPHA;
                    if (mappingOrder) {
                        BigInteger i1 = ((RLogicalField)((IReferencable)e1).getMapReference()).getPosition();
                        BigInteger i2 = ((RLogicalField)((IReferencable)e2).getMapReference()).getPosition();
                        if (i1 != null) {
                            if (i2 != null) {
                                return i1.compareTo(i2);
                            }
                            return 1;
                        }
                        if (i2 != null) {
                            return -1;
                        }
                        return 0;
                    }
                    try {
                        Level lvl1 = ((MdNode)((Field)e1).getRef()).getLevel();
                        Level lvl2 = ((MdNode)((Field)e2).getRef()).getLevel();
                        if (lvl1 != lvl2) {
                            int r = lvl1.getPosition().compareTo(lvl2.getPosition());
                            if (r == 1) {
                                return lvl1.getCode().compareTo(lvl2.getCode());
                            }
                            return r;
                        }
                    }
                    catch (Exception lvl1) {
                        // empty catch block
                    }
                }
                String name1 = e1 instanceof IContainer ? ((IContainer)e1).getAlias().toString() : ((ILogicalField)e1).getLabel();
                String name2 = e1 instanceof IContainer ? ((IContainer)e2).getAlias().toString() : ((ILogicalField)e2).getLabel();
                return this.getComparator().compare(name1, name2);
            }

            public int category(Object element) {
                if (element instanceof IContainer) {
                    return 0;
                }
                if (element instanceof Field) {
                    Field f = (Field)element;
                    int count = 10;
                    while (f.getParent() != null) {
                        ++count;
                        f = f.getParent();
                    }
                    return count;
                }
                if (element instanceof ComputedField) {
                    return 9999;
                }
                return 1;
            }
        });
        this.viewerFilter = new PatternFilter();
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        this.viewerFilter.setPattern(null);
        this.viewerFilter.setIncludeLeadingWildcard(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FilteredViewerComponent.this.handler != null) {
                    FilteredViewerComponent.this.handler.handleSelectionChanged((IStructuredSelection)event.getSelection());
                }
            }
        });
        if (this.mode == Mode.TARGET) {
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        }
        return this.main;
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
        if (this.viewer.getTree().getVerticalBar() != null) {
            this.viewer.getTree().getVerticalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilteredViewerComponent.this.handler.handleRepaint();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        org.eclipse.swt.widgets.Listener hoverListener = new org.eclipse.swt.widgets.Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 7: {
                        this.handleExit(event);
                        break;
                    }
                    case 6: {
                        this.handleEnter(event);
                        break;
                    }
                    case 5: {
                        this.handleMove(event);
                    }
                }
            }

            private void handleMove(Event event) {
                Object old = FilteredViewerComponent.this.hovered;
                FilteredViewerComponent.this.hovered = FilteredViewerComponent.this.viewer.getTree().getItem(new Point(event.x, event.y));
                if (old != FilteredViewerComponent.this.hovered) {
                    FilteredViewerComponent.this.viewer.getTree().redraw();
                }
            }

            private void handleEnter(Event event) {
                Object old = FilteredViewerComponent.this.hovered;
                FilteredViewerComponent.this.hovered = FilteredViewerComponent.this.viewer.getTree().getItem(new Point(event.x, event.y));
                if (old != FilteredViewerComponent.this.hovered) {
                    FilteredViewerComponent.this.viewer.getTree().redraw();
                }
            }

            private void handleExit(Event event) {
                Object old = FilteredViewerComponent.this.hovered;
                FilteredViewerComponent.this.hovered = FilteredViewerComponent.this.viewer.getTree().getItem(new Point(event.x, event.y));
                if (old != FilteredViewerComponent.this.hovered) {
                    FilteredViewerComponent.this.viewer.getTree().redraw();
                }
            }
        };
        this.viewer.getTree().addListener(6, hoverListener);
        this.viewer.getTree().addListener(7, hoverListener);
        this.viewer.getTree().addListener(5, hoverListener);
    }

    public void configure(Listener listener, MapperAdapter.LabelProviderHelper imageProvider) {
        this.handler = listener;
        this.imageProvider = imageProvider;
        this.viewer.refresh();
    }

    public void configureDnd() {
        int dndOperations = 1;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        if (this.mode == Mode.SOURCE) {
            this.viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)this.viewer));
        }
        if (this.mode == Mode.TARGET) {
            this.viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new DropAdapter());
        }
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public IStructuredSelection getAll() {
        ArrayList<Object> l = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() instanceof IContainer) {
                l.addAll(((IContainer)i.getData()).getLogicalField());
            } else {
                l.add(i.getData());
            }
            ++n2;
        }
        return new StructuredSelection(l);
    }

    public Point getAnchor(Object trg) {
        Widget w = this.viewer.testFindItem(trg);
        if (w != null) {
            Point pt = null;
            Rectangle r = ((TreeItem)w).getBounds();
            Rectangle treeBounds = this.viewer.getTree().getBounds();
            int y = 0;
            y = r.y + r.height / 2 > treeBounds.height ? treeBounds.height : (r.y + r.height / 2 < 0 ? 0 : r.y + r.height / 2);
            pt = this.mode == Mode.SOURCE ? new Point(this.main.getBounds().width, y) : new Point(0, y);
            pt.y += treeBounds.y;
            return pt;
        }
        return null;
    }

    public Control getControl() {
        return this.main;
    }

    public void refreshSelection() {
        this.viewer.refresh(((IStructuredSelection)this.viewer.getSelection()).getFirstElement(), true);
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setSelection(IStructuredSelection initialSelection) {
        this.viewer.setSelection((ISelection)initialSelection);
    }

    public void setColoredObjects(Set<Object> toColor) {
        this.itemsToColor = toColor;
        this.viewer.getControl().redraw();
    }

    private class ComponentLabelProvider
    extends OwnerDrawLabelProvider
    implements ILabelProvider {
        private ComponentLabelProvider() {
        }

        protected void erase(Event event, Object element) {
            Rectangle bounds;
            if (element == null) {
                return;
            }
            if (FilteredViewerComponent.this.mode == Mode.TARGET) {
                bounds = event.getBounds();
                if ((event.detail & 2) != 0) {
                    event.gc.setBackground(FilteredViewerComponent.this.selectionColor);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(1));
                    event.gc.fillRectangle(bounds);
                    event.detail &= 0xFFFFFFFD;
                }
                event.detail = 0;
            } else {
                if (FilteredViewerComponent.this.itemsToColor.contains(element)) {
                    bounds = event.getBounds();
                    event.gc.setAlpha(255);
                    event.gc.setBackground(FilteredViewerComponent.this.srcColor);
                    if ((event.detail & 2) != 0) {
                        event.gc.setForeground(event.item.getDisplay().getSystemColor(1));
                        event.detail &= 0xFFFFFFFD;
                    }
                    event.gc.fillRectangle(bounds);
                }
                event.detail = 0;
            }
            if (FilteredViewerComponent.this.hovered instanceof TreeItem) {
                bounds = event.getBounds();
                if (((TreeItem)FilteredViewerComponent.this.hovered).getData() == element) {
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(26));
                }
            }
        }

        public boolean useNativeToolTip(Object object) {
            return false;
        }

        public Image getToolTipImage(Object object) {
            return FilteredViewerComponent.this.imageProvider.getTooltipIcon(object);
        }

        public String getToolTipText(Object element) {
            return FilteredViewerComponent.this.imageProvider.getTooltip(element);
        }

        protected void measure(Event event, Object element) {
            if (element == null) {
                return;
            }
            Point imageSize = new Point(0, 0);
            for (Image im : FilteredViewerComponent.this.imageProvider.getImages(element)) {
                if (im == null) continue;
                Rectangle rectangle = im.getBounds();
                imageSize.x += rectangle.width;
                imageSize.y = 16;
            }
            String s = this.getText(element);
            Point point = event.gc.stringExtent(s);
            event.width = FilteredViewerComponent.this.viewer.getTree().getClientArea().width - event.x;
            event.height = Math.min(Math.max(imageSize.y, point.y), 16) + 1;
        }

        protected void paint(Event event, Object element) {
            if (element == null) {
                return;
            }
            Rectangle bounds = event.getBounds();
            String s = this.getText(element);
            int offset = 0;
            for (Image im : FilteredViewerComponent.this.imageProvider.getImages(element)) {
                if (im == null) continue;
                event.gc.drawImage(im, bounds.x + offset, bounds.y);
                offset += im.getBounds().width;
            }
            if ((event.detail & 2) != 0) {
                if (FilteredViewerComponent.this.mode == Mode.TARGET) {
                    event.gc.setBackground(FilteredViewerComponent.this.selectionColor);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(1));
                } else if (FilteredViewerComponent.this.itemsToColor.contains(element)) {
                    event.gc.setBackground(FilteredViewerComponent.this.srcColor);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(1));
                } else {
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(1));
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(2));
                }
            } else if (FilteredViewerComponent.this.mode == Mode.TARGET) {
                event.gc.setBackground(event.item.getDisplay().getSystemColor(1));
                event.gc.setForeground(event.item.getDisplay().getSystemColor(2));
            } else if (FilteredViewerComponent.this.itemsToColor.contains(element)) {
                event.gc.setBackground(FilteredViewerComponent.this.srcColor);
                event.gc.setForeground(event.item.getDisplay().getSystemColor(1));
            } else {
                event.gc.setBackground(event.item.getDisplay().getSystemColor(1));
                event.gc.setForeground(event.item.getDisplay().getSystemColor(2));
            }
            event.gc.drawText(s, bounds.x + offset + 1, bounds.y + 1);
            event.gc.setForeground(event.item.getDisplay().getSystemColor(2));
            if (FilteredViewerComponent.this.hovered != null && ((TreeItem)FilteredViewerComponent.this.hovered).getData() == element) {
                Point point = event.gc.stringExtent(s);
                event.gc.setForeground(FilteredViewerComponent.this.mode == Mode.SOURCE ? FilteredViewerComponent.this.srcColor : FilteredViewerComponent.this.selectionColor);
                event.gc.drawRectangle(0, bounds.y, FilteredViewerComponent.this.viewer.getTree().getClientArea().width - 1, point.y + 2);
            }
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            try {
                return element instanceof IContainer ? ((IContainer)element).getAlias().getLocalPart() : ((ILogicalField)element).getLabel();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "";
            }
        }
    }

    private class DropAdapter
    extends ViewerDropAdapter {
        protected DropAdapter() {
            super((Viewer)FilteredViewerComponent.this.viewer);
            this.setFeedbackEnabled(false);
            this.setScrollEnabled(true);
            this.setScrollExpandEnabled(true);
            this.setFeedbackEnabled(false);
        }

        public boolean performDrop(Object data) {
            FilteredViewerComponent.this.handler.doDrop(data, this.getCurrentTarget());
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (target instanceof ILogicalField) {
                this.overrideOperation(1);
                return true;
            }
            return false;
        }
    }

    public static interface Listener {
        public void doDrop(Object var1, Object var2);

        public void handleSelectionChanged(IStructuredSelection var1);

        public void handleRepaint();
    }

    public static enum Mode {
        SOURCE,
        TARGET;

    }

    public static enum SortingMode {
        ALPHA,
        POSITION;

    }
}

